/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.services.ManageableServiceFactory;
import org.gatein.wsrp.services.ServiceWrapper;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPServiceFactory
implements ManageableServiceFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String wsdlDefinitionURL;
    private static final QName SERVICE = new QName("urn:oasis:names:tc:wsrp:v1:wsdl", "WSRPService");
    private Map<Class, Object> services = new ConcurrentHashMap<Class, Object>();
    private String markupURL;
    private String serviceDescriptionURL;
    private String portletManagementURL;
    private String registrationURL;
    private boolean failed;
    private boolean available;
    private int msBeforeTimeOut = 10000;

    @Override
    public <T> T getService(Class<T> clazz) throws Exception {
        this.log.debug("Getting service for class " + clazz);
        if (!this.isAvailable() && !this.isFailed()) {
            this.start();
        }
        Object service = this.services.get(clazz);
        String portAddress = null;
        boolean isMandatoryInterface = false;
        if (WSRPV1ServiceDescriptionPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.serviceDescriptionURL;
            isMandatoryInterface = true;
        } else if (WSRPV1MarkupPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.markupURL;
            isMandatoryInterface = true;
        } else if (WSRPV1RegistrationPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.registrationURL;
        } else if (WSRPV1PortletManagementPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.portletManagementURL;
        }
        if (service != null) {
            if (portAddress != null) {
                this.log.debug("Setting the end point to: " + portAddress);
                ((BindingProvider)service).getRequestContext().put("javax.xml.ws.service.endpoint.address", portAddress);
                T result = ServiceWrapper.getServiceWrapper(clazz, service, this);
                this.setFailed(false);
                this.setAvailable(true);
                return result;
            }
            if (isMandatoryInterface) {
                this.setFailed(true);
                throw new IllegalStateException("Mandatory interface URLs were not properly initialized: no proper service URL for " + clazz.getName());
            }
            throw new IllegalStateException("No URL was provided for optional interface " + clazz.getName());
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public String getServiceDescriptionURL() {
        return this.serviceDescriptionURL;
    }

    @Override
    public String getMarkupURL() {
        return this.markupURL;
    }

    @Override
    public String getRegistrationURL() {
        return this.registrationURL;
    }

    @Override
    public String getPortletManagementURL() {
        return this.portletManagementURL;
    }

    @Override
    public void setServiceDescriptionURL(String serviceDescriptionURL) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)serviceDescriptionURL, (String)"Mandatory Service Description interface", null);
        this.serviceDescriptionURL = serviceDescriptionURL;
        this.setFailed(false);
    }

    @Override
    public void setMarkupURL(String markupURL) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)markupURL, (String)"Mandatory Markup interface", null);
        this.markupURL = markupURL;
        this.setFailed(false);
    }

    @Override
    public void setRegistrationURL(String registrationURL) {
        this.registrationURL = registrationURL;
        this.setFailed(false);
    }

    @Override
    public void setPortletManagementURL(String portletManagementURL) {
        this.portletManagementURL = portletManagementURL;
        this.setFailed(false);
    }

    @Override
    public void stop() {
    }

    @Override
    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public void setWSOperationTimeOut(int msBeforeTimeOut) {
        if (msBeforeTimeOut < 0) {
            msBeforeTimeOut = 10000;
        }
        this.msBeforeTimeOut = msBeforeTimeOut;
    }

    @Override
    public int getWSOperationTimeOut() {
        return this.msBeforeTimeOut;
    }

    @Override
    public String getWsdlDefinitionURL() {
        return this.wsdlDefinitionURL;
    }

    @Override
    public void setWsdlDefinitionURL(String wsdlDefinitionURL) {
        this.wsdlDefinitionURL = wsdlDefinitionURL;
        this.setAvailable(false);
        this.setFailed(false);
    }

    @Override
    public void start() throws Exception {
        try {
            URI wsdlURL = new URI(this.wsdlDefinitionURL);
            Service service = Service.create((URL)wsdlURL.toURL(), (QName)SERVICE);
            WSRPV1MarkupPortType markupPortType = (WSRPV1MarkupPortType)service.getPort(WSRPV1MarkupPortType.class);
            this.services.put(WSRPV1MarkupPortType.class, markupPortType);
            this.markupURL = (String)((BindingProvider)markupPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
            WSRPV1ServiceDescriptionPortType sdPort = (WSRPV1ServiceDescriptionPortType)service.getPort(WSRPV1ServiceDescriptionPortType.class);
            this.services.put(WSRPV1ServiceDescriptionPortType.class, sdPort);
            this.serviceDescriptionURL = (String)((BindingProvider)sdPort).getRequestContext().get("javax.xml.ws.service.endpoint.address");
            WSRPV1PortletManagementPortType managementPortType = (WSRPV1PortletManagementPortType)service.getPort(WSRPV1PortletManagementPortType.class);
            this.services.put(WSRPV1PortletManagementPortType.class, managementPortType);
            this.portletManagementURL = (String)((BindingProvider)managementPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
            WSRPV1RegistrationPortType registrationPortType = (WSRPV1RegistrationPortType)service.getPort(WSRPV1RegistrationPortType.class);
            this.services.put(WSRPV1RegistrationPortType.class, registrationPortType);
            this.registrationURL = (String)((BindingProvider)registrationPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
            this.setFailed(false);
            this.setAvailable(true);
        }
        catch (MalformedURLException e) {
            this.setFailed(true);
            throw new IllegalArgumentException(this.wsdlDefinitionURL + " is not a well-formed URL specifying where to find the WSRP services definition.", e);
        }
        catch (Exception e) {
            this.log.info("Couldn't access WSDL information. Service won't be available", (Throwable)e);
            this.setAvailable(false);
            this.setFailed(true);
            throw e;
        }
    }
}

