/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.portlet.info;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.TransportGuarantee;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.info.CacheInfo;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.EventInfo;
import org.gatein.pc.api.info.EventingInfo;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferenceInfo;
import org.gatein.pc.api.info.PreferencesInfo;
import org.gatein.pc.api.info.RuntimeOptionInfo;
import org.gatein.pc.api.info.SecurityInfo;
import org.gatein.pc.api.info.WindowStateInfo;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.oasis.wsrp.v1.LocalizedString;
import org.oasis.wsrp.v1.MarkupType;
import org.oasis.wsrp.v1.ModelDescription;
import org.oasis.wsrp.v1.PortletDescription;
import org.oasis.wsrp.v1.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v1.PropertyDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPPortletInfo
implements PortletInfo {
    private WSRPCapabilitiesInfo capabilities;
    private MetaInfo metaInfo;
    private boolean usesMethodGet;
    private boolean defaultMarkupSecure;
    private boolean onlySecure;
    private boolean hasUserSpecificState;
    private boolean userContextStoredInSession;
    private boolean templatesStoredInSession;
    private boolean doesUrlTemplateProcessing;
    private String applicationName;
    private String groupId;
    private PreferencesInfo prefInfo;
    private ProducerInfo originatingProducer;
    private String portletHandle;

    public WSRPPortletInfo(PortletDescription portletDescription, ProducerInfo originatingProducerInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletDescription, (String)"PortletDescription");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)originatingProducerInfo, (String)"ProducerInfo");
        this.createCapabilitiesInfo(portletDescription);
        this.createMetaInfo(portletDescription);
        this.createWSRPInfo(portletDescription, originatingProducerInfo.getId());
        this.originatingProducer = originatingProducerInfo;
        this.portletHandle = portletDescription.getPortletHandle();
    }

    public WSRPPortletInfo(WSRPPortletInfo other, String newHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)other, (String)"WSRPPortletInfo");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)newHandle, (String)"new portlet handle", (String)"WSRPPortletInfo");
        this.usesMethodGet = other.usesMethodGet;
        this.defaultMarkupSecure = other.defaultMarkupSecure;
        this.onlySecure = other.onlySecure;
        this.hasUserSpecificState = other.hasUserSpecificState;
        this.userContextStoredInSession = other.userContextStoredInSession;
        this.templatesStoredInSession = other.templatesStoredInSession;
        this.doesUrlTemplateProcessing = other.doesUrlTemplateProcessing;
        this.groupId = other.groupId;
        this.applicationName = other.applicationName;
        WSRPCapabilitiesInfo otherCapabilities = (WSRPCapabilitiesInfo)other.getCapabilities();
        this.capabilities = new WSRPCapabilitiesInfo(new HashMap<MediaType, MediaTypeInfo>(otherCapabilities.mediaTypes), new HashSet<ModeInfo>(otherCapabilities.modes), new HashSet<WindowStateInfo>(otherCapabilities.windowStates), new HashSet<Locale>(otherCapabilities.locales));
        WSRPMetaInfo otherMeta = (WSRPMetaInfo)other.getMeta();
        this.metaInfo = new WSRPMetaInfo(new HashMap<String, org.gatein.common.i18n.LocalizedString>(otherMeta.metaInfos));
        WSRPPreferencesInfo otherPref = (WSRPPreferencesInfo)other.getPreferences();
        this.prefInfo = new WSRPPreferencesInfo(new HashMap<String, PreferenceInfo>(otherPref.preferences));
        this.originatingProducer = other.originatingProducer;
        this.portletHandle = newHandle;
    }

    public String getName() {
        return this.portletHandle;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public CapabilitiesInfo getCapabilities() {
        return this.capabilities;
    }

    public PreferencesInfo getPreferences() {
        if (this.prefInfo == null) {
            ModelDescription modelDesc;
            PortletPropertyDescriptionResponse propertyDescs = this.originatingProducer.getPropertyDescriptionsFor(this.portletHandle);
            Map<String, Object> prefInfos = null;
            if (propertyDescs != null && (modelDesc = propertyDescs.getModelDescription()) != null) {
                List descs = modelDesc.getPropertyDescriptions();
                if (descs != null) {
                    prefInfos = new HashMap<String, PreferenceInfo>(descs.size());
                    for (PropertyDescription desc : descs) {
                        String key = desc.getName();
                        prefInfos.put(key, new WSRPPreferenceInfo(key, this.getPortalLocalizedStringOrNullFrom(desc.getLabel()), this.getPortalLocalizedStringOrNullFrom(desc.getHint())));
                    }
                } else {
                    prefInfos = Collections.emptyMap();
                }
            }
            if (prefInfos == null) {
                prefInfos = Collections.emptyMap();
            }
            this.prefInfo = new WSRPPreferencesInfo(prefInfos);
        }
        return this.prefInfo;
    }

    public MetaInfo getMeta() {
        return this.metaInfo;
    }

    public SecurityInfo getSecurity() {
        return new SecurityInfo(){

            public boolean containsTransportGuarantee(TransportGuarantee transportGuarantee) {
                return TransportGuarantee.NONE.equals((Object)transportGuarantee);
            }

            public Set<TransportGuarantee> getTransportGuarantees() {
                return Collections.singleton(TransportGuarantee.NONE);
            }
        };
    }

    public CacheInfo getCache() {
        return new CacheInfo(){

            public int getExpirationSecs() {
                Integer expirationCacheSeconds = WSRPPortletInfo.this.originatingProducer.getExpirationCacheSeconds();
                return expirationCacheSeconds != null ? expirationCacheSeconds : 0;
            }
        };
    }

    public Boolean isRemotable() {
        return Boolean.FALSE;
    }

    public EventingInfo getEventing() {
        return new EventingInfo(){

            public Map<QName, ? extends EventInfo> getProducedEvents() {
                return Collections.emptyMap();
            }

            public Map<QName, ? extends EventInfo> getConsumedEvents() {
                return Collections.emptyMap();
            }
        };
    }

    public NavigationInfo getNavigation() {
        return new NavigationInfo(){

            public ParameterInfo getPublicParameter(String s) {
                return null;
            }

            public ParameterInfo getPublicParameter(QName qName) {
                return null;
            }

            public Collection<? extends ParameterInfo> getPublicParameters() {
                return Collections.emptyList();
            }
        };
    }

    public <T> T getAttachment(Class<T> tClass) throws IllegalArgumentException {
        return null;
    }

    public Map<String, RuntimeOptionInfo> getRuntimeOptionsInfo() {
        return Collections.emptyMap();
    }

    public boolean isUsesMethodGet() {
        return this.usesMethodGet;
    }

    public boolean isDefaultMarkupSecure() {
        return this.defaultMarkupSecure;
    }

    public boolean isOnlySecure() {
        return this.onlySecure;
    }

    public boolean isHasUserSpecificState() {
        return this.hasUserSpecificState;
    }

    public boolean isUserContextStoredInSession() {
        return this.userContextStoredInSession;
    }

    public boolean isTemplatesStoredInSession() {
        return this.templatesStoredInSession;
    }

    public boolean isDoesUrlTemplateProcessing() {
        return this.doesUrlTemplateProcessing;
    }

    public String getGroupId() {
        return this.groupId;
    }

    private void createWSRPInfo(PortletDescription portletDescription, String consumerId) {
        this.usesMethodGet = Boolean.TRUE.equals(portletDescription.isUsesMethodGet());
        this.defaultMarkupSecure = Boolean.TRUE.equals(portletDescription.isDefaultMarkupSecure());
        this.onlySecure = Boolean.TRUE.equals(portletDescription.isOnlySecure());
        this.userContextStoredInSession = Boolean.TRUE.equals(portletDescription.isUserContextStoredInSession());
        this.templatesStoredInSession = Boolean.TRUE.equals(portletDescription.isTemplatesStoredInSession());
        this.hasUserSpecificState = Boolean.TRUE.equals(portletDescription.isHasUserSpecificState());
        this.doesUrlTemplateProcessing = Boolean.TRUE.equals(portletDescription.isDoesUrlTemplateProcessing());
        this.groupId = portletDescription.getGroupID();
        this.applicationName = ParameterValidation.isNullOrEmpty((String)this.groupId) ? consumerId : this.groupId;
    }

    private void createCapabilitiesInfo(PortletDescription portletDescription) {
        List markupTypes = portletDescription.getMarkupTypes();
        HashMap<MediaType, MediaTypeInfo> mediaTypes = new HashMap<MediaType, MediaTypeInfo>(markupTypes.size());
        this.capabilities = new WSRPCapabilitiesInfo();
        for (MarkupType markupType : markupTypes) {
            MediaType mediaType = MediaType.create((String)markupType.getMimeType());
            MediaTypeInfo mediaTypeInfo = new MediaTypeInfo(markupType);
            mediaTypes.put(mediaType, mediaTypeInfo);
            this.capabilities.addModes(mediaTypeInfo.modes);
            this.capabilities.addWindowStates(mediaTypeInfo.windowStates);
            this.capabilities.addLocales(mediaTypeInfo.locales);
        }
        this.capabilities.setMediaTypes(mediaTypes);
    }

    private void createMetaInfo(PortletDescription portletDescription) {
        int keywordsNb;
        HashMap<String, org.gatein.common.i18n.LocalizedString> metaInfos = new HashMap<String, org.gatein.common.i18n.LocalizedString>();
        metaInfos.put("description", this.getPortalLocalizedStringOrNullFrom(portletDescription.getDescription()));
        metaInfos.put("display-name", this.getPortalLocalizedStringOrNullFrom(portletDescription.getDisplayName()));
        metaInfos.put("short-title", this.getPortalLocalizedStringOrNullFrom(portletDescription.getShortTitle()));
        metaInfos.put("title", this.getPortalLocalizedStringOrNullFrom(portletDescription.getTitle()));
        List keywords = portletDescription.getKeywords();
        String keywordsString = "";
        Locale locale = Locale.ENGLISH;
        if (keywords != null && (keywordsNb = keywords.size()) > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < keywordsNb; ++i) {
                LocalizedString keyword = (LocalizedString)keywords.get(i);
                sb.append(keyword.getValue());
                if (i == keywordsNb - 1) continue;
                sb.append(",");
            }
            keywordsString = sb.toString();
            locale = WSRPUtils.getLocale((String)((LocalizedString)keywords.get(0)).getLang());
        }
        metaInfos.put("keywords", new org.gatein.common.i18n.LocalizedString(keywordsString, locale));
        this.metaInfo = new WSRPMetaInfo(metaInfos);
    }

    private org.gatein.common.i18n.LocalizedString getPortalLocalizedStringOrNullFrom(LocalizedString wsrpLocalizedString) {
        if (wsrpLocalizedString != null) {
            return new org.gatein.common.i18n.LocalizedString(wsrpLocalizedString.getValue(), WSRPUtils.getLocale((String)wsrpLocalizedString.getLang()));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WSRPPreferenceInfo
    implements PreferenceInfo {
        private String key;
        private org.gatein.common.i18n.LocalizedString displayName;
        private org.gatein.common.i18n.LocalizedString description;

        public WSRPPreferenceInfo(String key, org.gatein.common.i18n.LocalizedString displayName, org.gatein.common.i18n.LocalizedString description) {
            this.key = key;
            this.displayName = displayName;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public org.gatein.common.i18n.LocalizedString getDisplayName() {
            return this.displayName;
        }

        public org.gatein.common.i18n.LocalizedString getDescription() {
            return this.description;
        }

        public Boolean isReadOnly() {
            return null;
        }

        public List<String> getDefaultValue() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WSRPPreferencesInfo
    implements PreferencesInfo {
        private Map<String, PreferenceInfo> preferences;

        public WSRPPreferencesInfo(Map<String, PreferenceInfo> preferences) {
            this.preferences = preferences;
        }

        public Set<String> getKeys() {
            return Collections.unmodifiableSet(this.preferences.keySet());
        }

        public PreferenceInfo getPreference(String key) throws IllegalArgumentException {
            return this.preferences.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WSRPMetaInfo
    implements MetaInfo {
        private final Map<String, org.gatein.common.i18n.LocalizedString> metaInfos;

        public WSRPMetaInfo(Map<String, org.gatein.common.i18n.LocalizedString> metaInfos) {
            this.metaInfos = metaInfos;
        }

        public org.gatein.common.i18n.LocalizedString getMetaValue(String key) {
            return this.metaInfos.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WSRPCapabilitiesInfo
    implements CapabilitiesInfo {
        private Map<MediaType, MediaTypeInfo> mediaTypes;
        private Set<ModeInfo> modes;
        private Set<WindowStateInfo> windowStates;
        private Set<Locale> locales;

        private WSRPCapabilitiesInfo() {
        }

        private void setMediaTypes(Map<MediaType, MediaTypeInfo> mediaTypes) {
            this.mediaTypes = mediaTypes;
        }

        public WSRPCapabilitiesInfo(Map<MediaType, MediaTypeInfo> mediaTypes, Set<ModeInfo> modes, Set<WindowStateInfo> windowStates, Set<Locale> locales) {
            this.mediaTypes = mediaTypes;
            this.modes = modes;
            this.windowStates = windowStates;
            this.locales = locales;
        }

        public Set<MediaType> getMediaTypes() {
            return this.mediaTypes.keySet();
        }

        public Set<ModeInfo> getAllModes() {
            return this.modes;
        }

        public Set<ModeInfo> getModes(MediaType mediaType) {
            MediaTypeInfo mimeTypeInfo = this.mediaTypes.get(mediaType);
            if (mimeTypeInfo == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(mimeTypeInfo.modes);
        }

        public ModeInfo getMode(Mode mode) {
            for (ModeInfo info : this.modes) {
                if (!info.getMode().equals((Object)mode)) continue;
                return info;
            }
            return null;
        }

        public Set<WindowStateInfo> getAllWindowStates() {
            return this.windowStates;
        }

        public Set<WindowStateInfo> getWindowStates(MediaType mediaType) {
            MediaTypeInfo mimeTypeInfo = this.mediaTypes.get(mediaType);
            if (mimeTypeInfo == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(mimeTypeInfo.windowStates);
        }

        public WindowStateInfo getWindowState(WindowState windowState) {
            for (WindowStateInfo info : this.windowStates) {
                if (!info.getWindowState().equals((Object)windowState)) continue;
                return info;
            }
            return null;
        }

        public Set<Locale> getAllLocales() {
            return this.locales;
        }

        public Set<Locale> getLocales(MediaType mediaType) {
            MediaTypeInfo mimeTypeInfo = this.mediaTypes.get(mediaType);
            if (mimeTypeInfo == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(mimeTypeInfo.locales);
        }

        private void addModes(Set<ModeInfo> modes) {
            if (modes != null) {
                int size = modes.size();
                if (this.modes == null) {
                    this.modes = new HashSet<ModeInfo>(size);
                }
                this.modes.addAll(modes);
            }
        }

        private void addWindowStates(Set<WindowStateInfo> windowStates) {
            if (windowStates != null) {
                int size = windowStates.size();
                if (this.windowStates == null) {
                    this.windowStates = new HashSet<WindowStateInfo>(size);
                }
                this.windowStates.addAll(windowStates);
            }
        }

        private void addLocales(Set<Locale> locales) {
            if (locales != null) {
                int size = locales.size();
                if (this.locales == null) {
                    this.locales = new HashSet<Locale>(size);
                }
                this.locales.addAll(locales);
            }
        }
    }

    class BasicModeInfo
    implements ModeInfo {
        Mode mode;

        public BasicModeInfo(Mode mode) {
            this.mode = mode;
        }

        public org.gatein.common.i18n.LocalizedString getDescription() {
            return new org.gatein.common.i18n.LocalizedString(this.getModeName() + " mode", Locale.ENGLISH);
        }

        public Mode getMode() {
            return this.mode;
        }

        public String getModeName() {
            return this.mode.toString();
        }
    }

    class BasicWindowStateInfo
    implements WindowStateInfo {
        WindowState state;

        public BasicWindowStateInfo(WindowState state) {
            this.state = state;
        }

        public org.gatein.common.i18n.LocalizedString getDescription() {
            return new org.gatein.common.i18n.LocalizedString(this.getWindowStateName() + " window state", Locale.ENGLISH);
        }

        public WindowState getWindowState() {
            return this.state;
        }

        public String getWindowStateName() {
            return this.state.toString();
        }
    }

    class MediaTypeInfo {
        MediaType mimeType;
        Set<ModeInfo> modes;
        Set<WindowStateInfo> windowStates;
        Set<Locale> locales;

        public MediaTypeInfo(MarkupType markupType) {
            this.mimeType = MediaType.create((String)markupType.getMimeType());
            List modeNames = markupType.getModes();
            this.modes = new HashSet<ModeInfo>(modeNames.size());
            for (String modeName : modeNames) {
                this.modes.add(new BasicModeInfo(WSRPUtils.getJSR168PortletModeFromWSRPName((String)modeName)));
            }
            List windStateNames = markupType.getWindowStates();
            this.windowStates = new HashSet<WindowStateInfo>(windStateNames.size());
            for (String windStateName : windStateNames) {
                this.windowStates.add(new BasicWindowStateInfo(WSRPUtils.getJSR168WindowStateFromWSRPName((String)windStateName)));
            }
            List localeNames = markupType.getLocales();
            if (localeNames != null) {
                this.locales = new HashSet<Locale>(localeNames.size());
                for (String localeName : localeNames) {
                    this.locales.add(WSRPUtils.getLocale((String)localeName));
                }
            } else {
                this.locales = Collections.emptySet();
            }
        }
    }
}

