/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.gatein.wsrp.consumer.ProducerSessionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHeaderClientHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final ThreadLocal local = new ThreadLocal();
    private static final RFC2109Spec cookieParser = new RFC2109Spec();
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderClientHandler.class);

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        if (Boolean.TRUE.equals(soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound"))) {
            return this.handleRequest(soapMessageContext);
        }
        return this.handleResponse((MessageContext)soapMessageContext);
    }

    public boolean handleFault(SOAPMessageContext soapMessageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public boolean handleRequest(SOAPMessageContext msgContext) {
        String userCookie;
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info == null) {
            return true;
        }
        ProducerSessionInformation sessionInfo = info.sessionInfo;
        if (sessionInfo == null) {
            return true;
        }
        SOAPMessage message = msgContext.getMessage();
        MimeHeaders mimeHeaders = message.getMimeHeaders();
        StringBuffer cookie = new StringBuffer(64);
        if (sessionInfo.isPerGroupCookies()) {
            if (info.groupId == null) {
                throw new IllegalStateException("Was expecting a current group Id...");
            }
            String groupCookie = sessionInfo.getGroupCookieFor(info.groupId);
            if (groupCookie != null) {
                cookie.append(groupCookie);
            }
        }
        if ((userCookie = sessionInfo.getUserCookie()) != null) {
            if (cookie.length() != 0) {
                cookie.append(',');
            }
            cookie.append(userCookie);
        }
        if (cookie.length() != 0) {
            mimeHeaders.setHeader("Cookie", cookie.toString());
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        SOAPMessageContext smc = (SOAPMessageContext)msgContext;
        SOAPMessage message = smc.getMessage();
        MimeHeaders mimeHeaders = message.getMimeHeaders();
        String[] cookieValues = mimeHeaders.getHeader("Set-Cookie");
        if (cookieValues != null) {
            String cookieValue = this.coalesceCookies(cookieValues);
            Cookie[] cookies = this.extractCookies((String)msgContext.get((Object)"javax.xml.ws.service.endpoint.address"), cookieValue);
            CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(true);
            ProducerSessionInformation sessionInfo = info.sessionInfo;
            if (sessionInfo.isPerGroupCookies()) {
                if (info.groupId == null) {
                    throw new IllegalStateException("Was expecting a current group Id...");
                }
                sessionInfo.setGroupCookieFor(info.groupId, cookies);
            } else {
                sessionInfo.setUserCookie(cookies);
            }
        }
        return true;
    }

    private String coalesceCookies(String[] cookieValues) {
        assert (cookieValues != null);
        StringBuffer logBuffer = null;
        if (log.isDebugEnabled()) {
            logBuffer = new StringBuffer(128);
            logBuffer.append("Cookie headers:\n");
        }
        int cookieNumber = cookieValues.length;
        StringBuffer cookieBuffer = new StringBuffer(cookieNumber * 128);
        for (int i = 0; i < cookieNumber; ++i) {
            String cookieValue = cookieValues[i];
            cookieBuffer.append(cookieValue);
            if (i < cookieNumber - 1) {
                cookieBuffer.append(',');
            }
            if (!log.isDebugEnabled()) continue;
            logBuffer.append("\t").append(i).append(":\t").append(cookieValue).append("\n");
        }
        if (log.isDebugEnabled()) {
            log.debug(logBuffer.toString());
        }
        return cookieBuffer.toString();
    }

    private Cookie[] extractCookies(String endpointAddress, String cookieValue) {
        Cookie[] cookies;
        URL hostURL;
        if (endpointAddress == null) {
            throw new NullPointerException("Was expecting an endpoint address but none was provided in the MessageContext");
        }
        try {
            hostURL = new URL(endpointAddress);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(endpointAddress + " is not a valid URL for the endpoint address.");
        }
        try {
            String host = hostURL.getHost();
            int port = hostURL.getPort();
            if (port == -1) {
                port = 80;
            }
            String path = hostURL.getPath();
            boolean secure = hostURL.getProtocol().endsWith("s");
            for (Cookie cookie : cookies = cookieParser.parse(host, port, path, secure, cookieValue)) {
                cookieParser.validate(host, port, path, secure, cookie);
            }
        }
        catch (MalformedCookieException e) {
            throw new IllegalArgumentException("Malformed cookie: " + cookieValue);
        }
        return cookies;
    }

    public static void setCurrentInfo(String groupId, ProducerSessionInformation sessionInformation) {
        local.set(new CurrentInfo(groupId, sessionInformation));
    }

    public static void resetCurrentInfo() {
        local.set(null);
    }

    public static ProducerSessionInformation getCurrentProducerSessionInformation() {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info != null) {
            return info.sessionInfo;
        }
        return null;
    }

    public static String getCurrentGroupId() {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info != null) {
            return info.groupId;
        }
        return null;
    }

    public static void setCurrentGroupId(String groupId) {
        CurrentInfo currentInfo = (CurrentInfo)local.get();
        if (currentInfo == null) {
            throw new IllegalStateException("Cannot set current group id when the current info hasn't been initialized.");
        }
        currentInfo.groupId = groupId;
    }

    private static CurrentInfo getCurrentInfo(boolean createIfNeeded) {
        CurrentInfo info = (CurrentInfo)local.get();
        if (info == null && createIfNeeded) {
            info = new CurrentInfo(null, new ProducerSessionInformation());
            local.set(info);
        }
        return info;
    }

    static class CurrentInfo {
        String groupId;
        ProducerSessionInformation sessionInfo;

        public CurrentInfo(String groupId, ProducerSessionInformation sessionInfo) {
            this.groupId = groupId;
            this.sessionInfo = sessionInfo;
        }
    }
}

