/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services;

import java.lang.reflect.ParameterizedType;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;
import org.gatein.wsrp.services.ManageableServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceWrapper<T> {
    protected T service;
    protected ManageableServiceFactory parentFactory;
    private static final String JBOSS_WS_TIMEOUT = "org.jboss.ws.timeout";
    private static final String SUN_WS_TIMEOUT = "com.sun.xml.ws.request.timeout";
    private static final String IBM_WS_TIMEOUT = "com.ibm.SOAP.requestTimeout";

    protected ServiceWrapper(Object service, ManageableServiceFactory parentFactory) {
        if (service == null) {
            throw new IllegalArgumentException("Cannot create a ServiceWrapper without a valid service!");
        }
        Class<?> serviceClass = service.getClass();
        BindingProvider bindingProvider = (BindingProvider)service;
        ServiceWrapper.setTimeout(bindingProvider, parentFactory);
        Class tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (!tClass.isAssignableFrom(serviceClass)) {
            throw new IllegalArgumentException(service + " is not an instance of " + tClass.getSimpleName());
        }
        this.service = service;
        this.parentFactory = parentFactory;
    }

    private static void setTimeout(BindingProvider bindingProvider, ManageableServiceFactory parentFactory) {
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put(JBOSS_WS_TIMEOUT, parentFactory.getWSOperationTimeOut());
        requestContext.put(SUN_WS_TIMEOUT, parentFactory.getWSOperationTimeOut());
        requestContext.put(IBM_WS_TIMEOUT, parentFactory.getWSOperationTimeOut());
    }

    public static <T> T getServiceWrapper(Class<T> expectedServiceInterface, Object service, ManageableServiceFactory parentFactory) {
        ServiceWrapper.setTimeout((BindingProvider)service, parentFactory);
        return expectedServiceInterface.cast(service);
    }

    protected void handleRemoteException(RemoteException e) throws RemoteException {
        if (!(e.getCause() instanceof SOAPFaultException)) {
            this.parentFactory.setAvailable(false);
        }
        throw e;
    }
}

