/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.Set;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.consumer.InvocationHandler;
import org.gatein.wsrp.consumer.ProducerInfo;

public class MarkupProcessor {
    private final PortletInvocationContext context;
    private final URLFormat format;
    private final Set<String> supportedCustomModes;
    private final Set<String> supportedCustomWindowStates;
    private final String serverAddress;
    private final String portletApplicationName;
    private final String namespace;
    public static final int URL_DELIMITER_LENGTH = "*".length();

    protected MarkupProcessor(String namespace, PortletInvocationContext context, PortletContext target, URLFormat format, ProducerInfo info) {
        this.namespace = namespace;
        this.context = context;
        this.format = format;
        this.supportedCustomModes = info.getSupportedCustomModes();
        this.supportedCustomWindowStates = info.getSupportedCustomWindowStates();
        this.serverAddress = info.getEndpointConfigurationInfo().getRemoteHostAddress();
        this.portletApplicationName = target.getApplicationName();
    }

    public String getReplacementFor(String match, String prefix, String suffix) {
        if (prefix.equals(match)) {
            return this.namespace;
        }
        if (match.startsWith("?")) {
            match = match.substring("?".length());
            WSRPPortletURL portletURL = WSRPPortletURL.create((String)match, this.supportedCustomModes, this.supportedCustomWindowStates, (boolean)true);
            return this.context.renderURL((ContainerURL)portletURL, this.format);
        }
        return match;
    }

    static String getResourceURL(String urlAsString, WSRPResourceURL resource) {
        String resourceURL = resource.getResourceURL().toExternalForm();
        if (InvocationHandler.log.isDebugEnabled()) {
            InvocationHandler.log.debug("URL '" + urlAsString + "' refers to a resource which are not currently well supported. " + "Attempting to craft a URL that we might be able to work with: '" + resourceURL + "'");
        }
        return resourceURL;
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, MarkupProcessor generator, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries, boolean suffixIsOptional) {
        boolean suffixAbsent;
        if (ParameterValidation.isNullOrEmpty((String)initial)) {
            return initial;
        }
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)generator, (String)"StringReplacementGenerator");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)prefix, (String)"prefix", (String)"Tools.replaceBoundedString");
        StringBuilder tmp = new StringBuilder(initial);
        int prefixIndex = tmp.indexOf(prefix);
        int prefixLength = prefix.length();
        boolean bl = suffixAbsent = suffix == null;
        if (!suffixIsOptional && suffix != null && tmp.indexOf(suffix) == -1) {
            return initial;
        }
        while (prefixIndex != -1) {
            int nextPrefixIndex;
            if (suffixAbsent) {
                if (keepBoundaries) {
                    tmp.insert(prefixIndex + prefixLength, generator.getReplacementFor(prefix, prefix, suffix));
                } else {
                    tmp.delete(prefixIndex, prefixIndex + prefixLength);
                    tmp.insert(prefixIndex, generator.getReplacementFor(prefix, prefix, suffix));
                }
                prefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
                continue;
            }
            int suffixIndex = tmp.indexOf(suffix, prefixIndex);
            if (suffixIndex == -1) {
                suffixAbsent = true;
                continue;
            }
            if (suffixIsOptional && (nextPrefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength)) != -1 && nextPrefixIndex <= suffixIndex) {
                tmp.delete(prefixIndex, prefixIndex + prefixLength);
                String replacement = generator.getReplacementFor(prefix, prefix, suffix);
                tmp.insert(prefixIndex, replacement);
                prefixIndex = nextPrefixIndex - prefixLength + replacement.length();
                continue;
            }
            if (replaceIfBoundedStringEmpty || suffixIndex != prefixIndex + prefixLength) {
                String match = tmp.substring(prefixIndex + prefixLength, suffixIndex);
                if (keepBoundaries) {
                    if (suffix != null) {
                        tmp.delete(prefixIndex + prefixLength, suffixIndex);
                    }
                    tmp.insert(prefixIndex + prefixLength, generator.getReplacementFor(match, prefix, suffix));
                } else {
                    int suffixLength;
                    int n = suffixLength = suffix != null ? suffix.length() : 0;
                    if (suffix != null) {
                        tmp.delete(prefixIndex, suffixIndex + suffixLength);
                    } else {
                        tmp.delete(prefixIndex, prefixIndex + prefixLength);
                    }
                    tmp.insert(prefixIndex, generator.getReplacementFor(match, prefix, suffix));
                }
            }
            prefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
        }
        return tmp.toString();
    }
}

