/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.gatein.common.io.IOTools;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.net.media.TypeDef;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.wsrp.consumer.InvocationHandler;
import org.gatein.wsrp.consumer.RequestPrecursor;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.handler.CookieUtil;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.UserContext;

public class ResourceHandler
extends InvocationHandler {
    protected ResourceHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    protected void updateUserContext(Object request, UserContext userContext) {
    }

    protected void updateRegistrationContext(Object request) throws PortletInvokerException {
    }

    protected RuntimeContext getRuntimeContextFrom(Object request) {
        return null;
    }

    protected Object performRequest(Object request) throws Exception {
        ContentResponse result;
        ResourceInvocation invocation = (ResourceInvocation)request;
        String resourceId = invocation.getResourceId();
        URL url = new URL(resourceId);
        URLConnection urlConnection = url.openConnection();
        String contentType = urlConnection.getContentType();
        Map<String, List<String>> headers = urlConnection.getHeaderFields();
        ResponseProperties props = new ResponseProperties();
        MultiValuedPropertyMap transportHeaders = props.getTransportHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            List<String> values;
            String key = entry.getKey();
            if (key == null || (values = entry.getValue()) == null) continue;
            if ("Set-Cookie".equals(key)) {
                Cookie[] cookies = CookieUtil.extractCookiesFrom(url, values.toArray(new String[values.size()]));
                List propCookies = props.getCookies();
                for (Cookie cookie : cookies) {
                    propCookies.add(CookieUtil.convertFrom(cookie));
                }
                continue;
            }
            for (String value : values) {
                transportHeaders.addValue(key, (Object)value);
            }
        }
        int length = urlConnection.getContentLength();
        byte[] bytes = IOTools.getBytes((InputStream)urlConnection.getInputStream(), (int)length);
        MediaType type = MediaType.create((String)contentType);
        if (TypeDef.TEXT.equals(type.getType())) {
            String charset = "UTF-8";
            if (contentType != null) {
                for (String part : contentType.split(";")) {
                    if (!part.startsWith("charset=")) continue;
                    charset = part.substring("charset=".length());
                }
            }
            result = new ContentResponse(props, Collections.emptyMap(), contentType, null, new String(bytes, charset), null);
        } else {
            result = new ContentResponse(props, Collections.emptyMap(), contentType, bytes, null, null);
        }
        return result;
    }

    protected Object prepareRequest(RequestPrecursor requestPrecursor, PortletInvocation invocation) {
        if (!(invocation instanceof ResourceInvocation)) {
            throw new IllegalArgumentException("ResourceHandler can only handle ResourceInvocations!");
        }
        return invocation;
    }

    protected PortletInvocationResponse processResponse(Object response, PortletInvocation invocation, RequestPrecursor requestPrecursor) throws PortletInvokerException {
        if (response instanceof ContentResponse) {
            return (ContentResponse)response;
        }
        throw new PortletInvokerException("Invalid response object: " + response);
    }
}

