/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.gatein.wsrp.consumer.handlers.NavigationalStateUpdatingHandler;
import org.oasis.wsrp.v2.Event;
import org.oasis.wsrp.v2.EventParams;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.HandleEventsFailed;
import org.oasis.wsrp.v2.HandleEventsResponse;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandler
extends NavigationalStateUpdatingHandler<EventInvocation, HandleEvents, HandleEventsResponse> {
    public EventHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    @Override
    protected void updateUserContext(HandleEvents request, UserContext userContext) {
        request.setUserContext(userContext);
    }

    @Override
    protected void updateRegistrationContext(HandleEvents request) throws PortletInvokerException {
        request.setRegistrationContext(this.consumer.getRegistrationContext());
    }

    @Override
    protected RuntimeContext getRuntimeContextFrom(HandleEvents request) {
        return request.getRuntimeContext();
    }

    @Override
    protected HandleEventsResponse performRequest(HandleEvents request) throws Exception {
        if (InvocationHandler.debug) {
            InvocationHandler.log.debug("handleEvents on '" + request.getPortletContext().getPortletHandle() + "'");
        }
        Holder failedEvents = new Holder();
        Holder updateResponse = new Holder();
        this.consumer.getMarkupService().handleEvents(request.getRegistrationContext(), request.getPortletContext(), request.getRuntimeContext(), request.getUserContext(), request.getMarkupParams(), request.getEventParams(), (Holder<UpdateResponse>)updateResponse, (Holder<List<HandleEventsFailed>>)failedEvents, (Holder<List<Extension>>)new Holder());
        HandleEventsResponse response = WSRPTypeFactory.createHandleEventsReponse();
        response.setUpdateResponse((UpdateResponse)updateResponse.value);
        if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)failedEvents.value))) {
            response.getFailedEvents().addAll((Collection)failedEvents.value);
        }
        return response;
    }

    @Override
    protected HandleEvents prepareRequest(InvocationHandler.RequestPrecursor<EventInvocation> requestPrecursor, EventInvocation invocation) {
        PortletContext portletContext = requestPrecursor.getPortletContext();
        if (InvocationHandler.debug) {
            InvocationHandler.log.debug("Consumer about to attempt action on portlet '" + portletContext.getPortletHandle() + "'");
        }
        InstanceContext instanceContext = invocation.getInstanceContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)instanceContext, (String)"instance context");
        AccessMode accessMode = instanceContext.getAccessMode();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)accessMode, (String)"access mode");
        if (InvocationHandler.debug) {
            InvocationHandler.log.debug("Portlet is requesting " + accessMode + " access mode");
        }
        QName name = invocation.getName();
        Serializable payload = invocation.getPayload();
        Event event = WSRPTypeFactory.createEvent((QName)name, (Serializable)payload);
        EventParams eventParams = WSRPTypeFactory.createEventParams(Collections.singletonList(event), (StateChange)WSRPUtils.getStateChangeFromAccessMode((AccessMode)accessMode));
        return WSRPTypeFactory.createHandleEvents((PortletContext)portletContext, (RuntimeContext)requestPrecursor.getRuntimeContext(), (MarkupParams)requestPrecursor.getMarkupParams(), (EventParams)eventParams);
    }

    @Override
    protected PortletInvocationResponse processResponse(HandleEventsResponse response, EventInvocation invocation, InvocationHandler.RequestPrecursor<EventInvocation> requestPrecursor) throws PortletInvokerException {
        List failed = response.getFailedEvents();
        if (ParameterValidation.existsAndIsNotEmpty((Collection)failed)) {
            return new ErrorResponse("Couldn't process events: " + failed);
        }
        return this.processUpdateResponse(invocation, requestPrecursor, response.getUpdateResponse());
    }
}

