/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gatein.common.util.MarkupInfo;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.portlet.impl.jsr168.PortletUtils;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.SessionHandler;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.NavigationalContext;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.UserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationHandler<Invocation extends PortletInvocation, Request, Response> {
    protected final WSRPConsumerImpl consumer;
    protected static Logger log = LoggerFactory.getLogger(InvocationHandler.class);
    protected static boolean debug = log.isDebugEnabled();
    protected static boolean trace = log.isTraceEnabled();
    private static final int DO_NOT_RETRY = -1;
    private static final int MAXIMUM_RETRY_NUMBER = 3;

    protected InvocationHandler(WSRPConsumerImpl consumer) {
        this.consumer = consumer;
    }

    public PortletInvocationResponse handle(Invocation invocation) throws PortletInvokerException {
        RequestPrecursor<Invocation> requestPrecursor = new RequestPrecursor<Invocation>(this.consumer, invocation);
        Request request = this.prepareRequest(requestPrecursor, invocation);
        try {
            Response response = this.performRequest(request, (PortletInvocation)invocation);
            return this.processResponse(response, invocation, requestPrecursor);
        }
        catch (Exception e) {
            if (!(e instanceof PortletInvokerException)) {
                ErrorResponse errorResponse = this.dealWithError(e, invocation, this.getRuntimeContextFrom(request));
                if (errorResponse != null) {
                    return this.unwrapWSRPError(errorResponse);
                }
                return new ErrorResponse((Throwable)e);
            }
            throw (PortletInvokerException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response performRequest(Request request, PortletInvocation invocation) throws Exception {
        int retryCount = 0;
        Object response = null;
        while (response == null && retryCount++ <= 3) {
            if (debug) {
                log.debug("performRequest: " + retryCount + " attempt(s) out of " + 3 + " possible");
            }
            SessionHandler sessionHandler = this.consumer.getSessionHandler();
            this.updateRegistrationContext(request);
            RuntimeContext runtimeContext = this.getRuntimeContextFrom(request);
            if (runtimeContext != null) {
                WindowContext windowContext = invocation.getWindowContext();
                runtimeContext.setNamespacePrefix(InvocationHandler.getNamespaceFrom(windowContext));
                InstanceContext instanceContext = invocation.getInstanceContext();
                runtimeContext.setPortletInstanceKey(instanceContext == null ? null : instanceContext.getId());
                this.updateUserContext(request, this.consumer.getUserContextFrom(invocation, runtimeContext));
                this.consumer.setTemplatesIfNeeded(invocation, runtimeContext);
            }
            try {
                sessionHandler.initCookieIfNeeded(invocation);
                sessionHandler.initProducerSessionInformation(invocation);
                response = this.performRequest(request);
                sessionHandler.updateCookiesIfNeeded(invocation);
            }
            finally {
                sessionHandler.resetCurrentlyHeldInformation();
            }
        }
        if (retryCount >= 3) {
            throw new RuntimeException("Tried to perform request 3 times before giving up. This usually happens if an error in the WS stack prevented the messages to be properly transmitted. Look at server.log for clues as to what happened...");
        }
        if (debug) {
            log.debug("performRequest finished. Response is " + (response != null ? response.getClass().getName() : null));
        }
        return (Response)response;
    }

    protected static String getNamespaceFrom(WindowContext windowContext) {
        if (windowContext != null) {
            return PortletUtils.generateNamespaceFrom((String)windowContext.getId());
        }
        return null;
    }

    private ErrorResponse dealWithError(Exception error, Invocation invocation, RuntimeContext runtimeContext) throws PortletInvokerException {
        log.error("The portlet threw an exception", (Throwable)error);
        SessionHandler sessionHandler = this.consumer.getSessionHandler();
        if (error instanceof InvalidCookie) {
            log.debug("Re-initializing cookies after InvalidCookieFault.");
            this.consumer.refreshProducerInfo();
            try {
                sessionHandler.initCookieIfNeeded((PortletInvocation)invocation);
            }
            catch (Exception e) {
                log.debug("Couldn't init cookie: " + e.getLocalizedMessage());
                return new ErrorResponse((Throwable)e);
            }
        } else if (error instanceof InvalidSession) {
            log.debug("Session invalidated after InvalidSessionFault, will re-send session-stored information.");
            sessionHandler.handleInvalidSessionFault((PortletInvocation)invocation, runtimeContext);
        } else if (error instanceof InvalidRegistration) {
            log.debug("Invalid registration");
            this.consumer.handleInvalidRegistrationFault();
        } else {
            return new ErrorResponse((Throwable)error);
        }
        return null;
    }

    protected ErrorResponse unwrapWSRPError(ErrorResponse errorResponse) {
        Throwable cause = errorResponse.getCause();
        if (cause != null) {
            if (cause instanceof OperationFailed && cause.getCause() != null) {
                cause = cause.getCause();
            } else if (cause instanceof RemoteException) {
                cause = ((RemoteException)cause).detail;
            }
            log.debug("Invocation of action failed: " + cause.getMessage(), cause);
            return new ErrorResponse(cause);
        }
        log.debug("Invocation of action failed: " + errorResponse.getMessage());
        return errorResponse;
    }

    protected abstract void updateUserContext(Request var1, UserContext var2);

    protected abstract void updateRegistrationContext(Request var1) throws PortletInvokerException;

    protected abstract RuntimeContext getRuntimeContextFrom(Request var1);

    protected abstract Response performRequest(Request var1) throws Exception;

    protected abstract Request prepareRequest(RequestPrecursor<Invocation> var1, Invocation var2);

    protected abstract PortletInvocationResponse processResponse(Response var1, Invocation var2, RequestPrecursor<Invocation> var3) throws PortletInvokerException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RequestPrecursor<Invocation extends PortletInvocation> {
        private static final Logger log = LoggerFactory.getLogger(RequestPrecursor.class);
        private org.oasis.wsrp.v2.PortletContext portletContext;
        private RuntimeContext runtimeContext;
        private MarkupParams markupParams;
        private static final String PORTLET_HANDLE = "portlet handle";
        private static final String SECURITY_CONTEXT = "security context";
        private static final String USER_CONTEXT = "user context";
        private static final String INVOCATION_CONTEXT = "invocation context";
        private static final String STREAM_INFO = "stream info in invocation context";
        private static final String USER_AGENT = "User-Agent";

        public RequestPrecursor(WSRPConsumerImpl wsrpConsumer, Invocation invocation) throws PortletInvokerException {
            String windowState;
            String mode;
            this.portletContext = WSRPUtils.convertToWSRPPortletContext((PortletContext)WSRPConsumerImpl.getPortletContext(invocation));
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)this.getPortletHandle(), (String)PORTLET_HANDLE, null);
            if (log.isDebugEnabled()) {
                log.debug("About to invoke on portlet: " + this.getPortletHandle());
            }
            SecurityContext securityContext = invocation.getSecurityContext();
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)securityContext, (String)SECURITY_CONTEXT);
            String authType = WSRPUtils.convertRequestAuthTypeToWSRPAuthType((String)securityContext.getAuthType());
            this.setRuntimeContext(WSRPTypeFactory.createRuntimeContext((String)authType));
            wsrpConsumer.getSessionHandler().setSessionIdIfNeeded((PortletInvocation)invocation, this.getRuntimeContext(), this.getPortletHandle());
            wsrpConsumer.setTemplatesIfNeeded((PortletInvocation)invocation, this.getRuntimeContext());
            org.gatein.pc.api.spi.UserContext userContext = invocation.getUserContext();
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)userContext, (String)USER_CONTEXT);
            PortletInvocationContext context = invocation.getContext();
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)context, (String)INVOCATION_CONTEXT);
            MarkupInfo streamInfo = context.getMarkupInfo();
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)streamInfo, (String)STREAM_INFO);
            try {
                mode = WSRPUtils.getWSRPNameFromJSR168PortletMode((Mode)invocation.getMode());
            }
            catch (Exception e) {
                log.debug("Mode was null in context.");
                mode = "wsrp:view";
            }
            try {
                windowState = WSRPUtils.getWSRPNameFromJSR168WindowState((WindowState)invocation.getWindowState());
            }
            catch (Exception e) {
                log.debug("WindowState was null in context.");
                windowState = "wsrp:normal";
            }
            this.setMarkupParams(WSRPTypeFactory.createMarkupParams((boolean)securityContext.isSecure(), (List)WSRPUtils.convertLocalesToRFC3066LanguageTags((List)userContext.getLocales()), Collections.singletonList(streamInfo.getMediaType().getValue()), (String)mode, (String)windowState));
            String userAgent = WSRPConsumerImpl.getHttpRequest(invocation).getHeader(USER_AGENT);
            this.getMarkupParams().setClientData(WSRPTypeFactory.createClientData((String)userAgent));
            StateString navigationalState = invocation.getNavigationalState();
            Map publicNavigationalState = invocation.getPublicNavigationalState();
            NavigationalContext navigationalContext = WSRPTypeFactory.createNavigationalContextOrNull((StateString)navigationalState, (Map)publicNavigationalState);
            this.getMarkupParams().setNavigationalContext(navigationalContext);
            if (log.isDebugEnabled()) {
                log.debug(WSRPUtils.toString((MarkupParams)this.getMarkupParams()));
            }
        }

        public String getPortletHandle() {
            return this.portletContext.getPortletHandle();
        }

        public org.oasis.wsrp.v2.PortletContext getPortletContext() {
            return this.portletContext;
        }

        public RuntimeContext getRuntimeContext() {
            return this.runtimeContext;
        }

        private void setRuntimeContext(RuntimeContext runtimeContext) {
            this.runtimeContext = runtimeContext;
        }

        public MarkupParams getMarkupParams() {
            return this.markupParams;
        }

        private void setMarkupParams(MarkupParams markupParams) {
            this.markupParams = markupParams;
        }
    }
}

