/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.gatein.wsrp.consumer.handlers.MimeResponseHandler;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderHandler
extends MimeResponseHandler<RenderInvocation, GetMarkup, MarkupResponse, MarkupContext> {
    public RenderHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    @Override
    protected SessionContext getSessionContextFrom(MarkupResponse response) {
        return response.getSessionContext();
    }

    @Override
    protected MarkupContext getMimeResponseFrom(MarkupResponse markupResponse) {
        return markupResponse.getMarkupContext();
    }

    @Override
    protected PortletInvocationResponse createContentResponse(MarkupContext markupContext, RenderInvocation invocation, ResponseProperties properties, Map<String, Object> attributes, String mimeType, byte[] bytes, String markup, CacheControl cacheControl) {
        return new FragmentResponse(properties, attributes, mimeType, bytes, markup, markupContext.getPreferredTitle(), cacheControl, invocation.getPortalContext().getModes());
    }

    @Override
    protected GetMarkup prepareRequest(InvocationHandler.RequestPrecursor<RenderInvocation> requestPrecursor, RenderInvocation invocation) {
        PortletContext portletContext = requestPrecursor.getPortletContext();
        if (debug) {
            log.debug("Consumer about to attempt rendering portlet '" + portletContext.getPortletHandle() + "'");
        }
        return WSRPTypeFactory.createMarkupRequest((PortletContext)portletContext, (RuntimeContext)requestPrecursor.getRuntimeContext(), (MarkupParams)requestPrecursor.getMarkupParams());
    }

    @Override
    protected void updateUserContext(GetMarkup request, UserContext userContext) {
        request.setUserContext(userContext);
    }

    @Override
    protected void updateRegistrationContext(GetMarkup request) throws PortletInvokerException {
        request.setRegistrationContext(this.consumer.getRegistrationContext());
    }

    @Override
    protected RuntimeContext getRuntimeContextFrom(GetMarkup request) {
        return request.getRuntimeContext();
    }

    @Override
    protected MarkupResponse performRequest(GetMarkup request) throws Exception {
        if (debug) {
            log.debug("getMarkup on '" + request.getPortletContext().getPortletHandle() + "'");
        }
        Holder sessionContextHolder = new Holder();
        Holder markupContextHolder = new Holder();
        this.consumer.getMarkupService().getMarkup(request.getRegistrationContext(), request.getPortletContext(), request.getRuntimeContext(), request.getUserContext(), request.getMarkupParams(), (Holder<MarkupContext>)markupContextHolder, (Holder<SessionContext>)sessionContextHolder, (Holder<List<Extension>>)new Holder());
        MarkupResponse markupResponse = new MarkupResponse();
        markupResponse.setMarkupContext((MarkupContext)markupContextHolder.value);
        markupResponse.setSessionContext((SessionContext)sessionContextHolder.value);
        return markupResponse;
    }
}

