/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.util.Map;
import java.util.Set;
import org.gatein.common.text.TextTools;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.cache.CacheScope;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.oasis.wsrp.v2.CacheControl;
import org.oasis.wsrp.v2.MimeResponse;
import org.oasis.wsrp.v2.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MimeResponseHandler<Invocation extends PortletInvocation, Request, Response, LocalMimeResponse extends MimeResponse>
extends InvocationHandler<Invocation, Request, Response> {
    private static final org.gatein.pc.api.cache.CacheControl DEFAULT_CACHE_CONTROL = new org.gatein.pc.api.cache.CacheControl(0, CacheScope.PRIVATE, null);

    protected MimeResponseHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    protected abstract SessionContext getSessionContextFrom(Response var1);

    protected abstract LocalMimeResponse getMimeResponseFrom(Response var1);

    @Override
    protected PortletInvocationResponse processResponse(Response response, Invocation invocation, InvocationHandler.RequestPrecursor<Invocation> requestPrecursor) throws PortletInvokerException {
        String mimeType;
        this.consumer.getSessionHandler().updateSessionIfNeeded(this.getSessionContextFrom(response), (PortletInvocation)invocation, requestPrecursor.getPortletHandle());
        LocalMimeResponse mimeResponse = this.getMimeResponseFrom(response);
        String markup = mimeResponse.getItemString();
        byte[] binary = mimeResponse.getItemBinary();
        if (markup != null && binary != null) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Markup response cannot contain both string and binary markup. Per Section 6.1.10 of the WSRP specification, this is a Producer error."));
        }
        if (markup == null && binary == null && !mimeResponse.isUseCachedItem().booleanValue()) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Markup response must contain at least string or binary markup. Per Section 6.1.10 of the WSRP specification, this is a Producer error."));
        }
        if (markup != null && markup.length() > 0 && Boolean.TRUE.equals(mimeResponse.isRequiresRewriting())) {
            markup = MimeResponseHandler.processMarkup(markup, MimeResponseHandler.getNamespaceFrom(invocation.getWindowContext()), invocation.getContext(), invocation.getTarget(), new URLFormat(Boolean.valueOf(invocation.getSecurityContext().isSecure()), Boolean.valueOf(invocation.getSecurityContext().isAuthenticated()), Boolean.valueOf(true), Boolean.valueOf(true)), this.consumer);
        }
        if ((mimeType = mimeResponse.getMimeType()) == null || mimeType.length() == 0) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("No MIME type was provided for portlet content."));
        }
        return this.createContentResponse(mimeResponse, invocation, null, null, mimeType, binary, markup, this.createCacheControl(mimeResponse));
    }

    protected PortletInvocationResponse createContentResponse(LocalMimeResponse mimeResponse, Invocation invocation, ResponseProperties properties, Map<String, Object> attributes, String mimeType, byte[] bytes, String markup, org.gatein.pc.api.cache.CacheControl cacheControl) {
        return new ContentResponse(properties, attributes, mimeType, bytes, markup, cacheControl);
    }

    static String processMarkup(String markup, String namespace, PortletInvocationContext context, PortletContext target, URLFormat format, WSRPConsumer consumer) {
        if (!WSRPConstants.RUNS_IN_EPP) {
            markup = markup.replaceFirst("%3ftimeout%3d.*%2f", "%2f");
        }
        markup = TextTools.replaceBoundedString((String)markup, (String)"wsrp_rewrite?", (String)"/wsrp_rewrite", (TextTools.StringReplacementGenerator)new MarkupProcessor(namespace, context, target, format, consumer.getProducerInfo()), (boolean)true, (boolean)false);
        markup = markup.replaceAll("wsrp_rewrite_", namespace);
        return markup;
    }

    protected org.gatein.pc.api.cache.CacheControl createCacheControl(LocalMimeResponse mimeResponse) {
        CacheControl cacheControl = mimeResponse.getCacheControl();
        org.gatein.pc.api.cache.CacheControl result = DEFAULT_CACHE_CONTROL;
        if (cacheControl != null) {
            int expires = cacheControl.getExpires();
            String userScope = cacheControl.getUserScope();
            if (this.consumer.supportsUserScope(userScope)) {
                CacheScope scope;
                if (debug) {
                    log.debug("Trying to cache markup " + userScope + " for " + expires + " seconds.");
                }
                if ("wsrp:forAll".equals(userScope)) {
                    scope = CacheScope.PUBLIC;
                } else if ("wsrp:perUser".equals(userScope)) {
                    scope = CacheScope.PRIVATE;
                } else {
                    throw new IllegalArgumentException("Unknown CacheControl user scope: " + userScope);
                }
                result = new org.gatein.pc.api.cache.CacheControl(expires, scope, cacheControl.getValidateTag());
            }
        }
        return result;
    }

    private static class MarkupProcessor
    implements TextTools.StringReplacementGenerator {
        private final PortletInvocationContext context;
        private final URLFormat format;
        private final Set<String> supportedCustomModes;
        private final Set<String> supportedCustomWindowStates;
        private final String namespace;

        protected MarkupProcessor(String namespace, PortletInvocationContext context, PortletContext target, URLFormat format, ProducerInfo info) {
            this.namespace = namespace;
            this.context = context;
            this.format = format;
            this.supportedCustomModes = info.getSupportedCustomModes();
            this.supportedCustomWindowStates = info.getSupportedCustomWindowStates();
        }

        public String getReplacementFor(String match, String prefix, String suffix) {
            match = match.replaceAll("\\\\x2D", "-").replaceAll("\\\\x26", "&amp;");
            WSRPPortletURL portletURL = WSRPPortletURL.create((String)match, this.supportedCustomModes, this.supportedCustomWindowStates, (boolean)true);
            return this.context.renderURL((ContainerURL)portletURL, this.format);
        }

        static String getResourceURL(String urlAsString, WSRPResourceURL resource) {
            String resourceURL = resource.getResourceURL().toExternalForm();
            if (InvocationHandler.log.isDebugEnabled()) {
                InvocationHandler.log.debug("URL '" + urlAsString + "' refers to a resource which are not currently well supported. " + "Attempting to craft a URL that we might be able to work with: '" + resourceURL + "'");
            }
            return resourceURL;
        }
    }
}

