/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.gatein.common.util.ParameterValidation;
import org.gatein.common.util.Version;
import org.gatein.wsrp.services.ManageableServiceFactory;
import org.gatein.wsrp.services.MarkupService;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.services.RegistrationService;
import org.gatein.wsrp.services.ServiceDescriptionService;
import org.gatein.wsrp.services.ServiceWrapper;
import org.gatein.wsrp.services.v1.V1MarkupService;
import org.gatein.wsrp.services.v1.V1PortletManagementService;
import org.gatein.wsrp.services.v1.V1RegistrationService;
import org.gatein.wsrp.services.v1.V1ServiceDescriptionService;
import org.gatein.wsrp.services.v2.V2MarkupService;
import org.gatein.wsrp.services.v2.V2PortletManagementService;
import org.gatein.wsrp.services.v2.V2RegistrationService;
import org.gatein.wsrp.services.v2.V2ServiceDescriptionService;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.oasis.wsrp.v2.WSRPV2MarkupPortType;
import org.oasis.wsrp.v2.WSRPV2PortletManagementPortType;
import org.oasis.wsrp.v2.WSRPV2RegistrationPortType;
import org.oasis.wsrp.v2.WSRPV2ServiceDescriptionPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPServiceFactory
implements ManageableServiceFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String wsdlDefinitionURL;
    private boolean isV2 = false;
    private static final String WSRP_V1_URN = "urn:oasis:names:tc:wsrp:v1:wsdl";
    private static final String WSRP_V1_BINDING = "urn:oasis:names:tc:wsrp:v1:bind";
    private static final String WSRP_V2_URN = "urn:oasis:names:tc:wsrp:v2:wsdl";
    private static final String WSRP_V2_BINDING = "urn:oasis:names:tc:wsrp:v2:bind";
    private Map<Class, Object> services = new ConcurrentHashMap<Class, Object>();
    private String markupURL;
    private String serviceDescriptionURL;
    private String portletManagementURL;
    private String registrationURL;
    private boolean failed;
    private boolean available;
    private int msBeforeTimeOut = 10000;

    @Override
    public <T> T getService(Class<T> clazz) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting service for class " + clazz);
        }
        if (!this.isAvailable() && !this.isFailed()) {
            this.start();
        }
        Object service = this.services.get(clazz);
        String portAddress = null;
        boolean isMandatoryInterface = false;
        if (WSRPV2ServiceDescriptionPortType.class.isAssignableFrom(clazz) || WSRPV1ServiceDescriptionPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.serviceDescriptionURL;
            isMandatoryInterface = true;
        } else if (WSRPV2MarkupPortType.class.isAssignableFrom(clazz) || WSRPV1MarkupPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.markupURL;
            isMandatoryInterface = true;
        } else if (WSRPV2RegistrationPortType.class.isAssignableFrom(clazz) || WSRPV1RegistrationPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.registrationURL;
        } else if (WSRPV2PortletManagementPortType.class.isAssignableFrom(clazz) || WSRPV1PortletManagementPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.portletManagementURL;
        }
        if (service != null) {
            if (portAddress != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Setting the end point to: " + portAddress);
                }
                T result = ServiceWrapper.getServiceWrapper(clazz, service, portAddress, this);
                this.setFailed(false);
                this.setAvailable(true);
                return result;
            }
            if (isMandatoryInterface) {
                this.setFailed(true);
                throw new IllegalStateException("Mandatory interface URLs were not properly initialized: no proper service URL for " + clazz.getName());
            }
            throw new IllegalStateException("No URL was provided for optional interface " + clazz.getName());
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public void stop() {
    }

    @Override
    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public void setWSOperationTimeOut(int msBeforeTimeOut) {
        if (msBeforeTimeOut < 0) {
            msBeforeTimeOut = 10000;
        }
        this.msBeforeTimeOut = msBeforeTimeOut;
    }

    @Override
    public int getWSOperationTimeOut() {
        return this.msBeforeTimeOut;
    }

    @Override
    public String getWsdlDefinitionURL() {
        return this.wsdlDefinitionURL;
    }

    @Override
    public void setWsdlDefinitionURL(String wsdlDefinitionURL) {
        this.wsdlDefinitionURL = wsdlDefinitionURL;
        this.setAvailable(false);
        this.setFailed(false);
    }

    @Override
    public void start() throws Exception {
        block5: {
            try {
                ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)this.wsdlDefinitionURL, (String)"WSDL URL", (String)"SOAPServiceFactory");
                URL wsdlURL = new URI(this.wsdlDefinitionURL).toURL();
                WSDLInfo wsdlInfo = new WSDLInfo(this.wsdlDefinitionURL);
                QName wsrp2 = wsdlInfo.getWSRP2ServiceQName();
                QName wsrp1 = wsdlInfo.getWSRP1ServiceQName();
                if (wsrp2 != null) {
                    Service service = Service.create((URL)wsdlURL, (QName)wsrp2);
                    WSRPV2MarkupPortType markupPortType = (WSRPV2MarkupPortType)service.getPort(WSRPV2MarkupPortType.class);
                    this.services.put(WSRPV2MarkupPortType.class, markupPortType);
                    this.markupURL = (String)((BindingProvider)markupPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    WSRPV2ServiceDescriptionPortType sdPort = (WSRPV2ServiceDescriptionPortType)service.getPort(WSRPV2ServiceDescriptionPortType.class);
                    this.services.put(WSRPV2ServiceDescriptionPortType.class, sdPort);
                    this.serviceDescriptionURL = (String)((BindingProvider)sdPort).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    WSRPV2PortletManagementPortType managementPortType = (WSRPV2PortletManagementPortType)service.getPort(WSRPV2PortletManagementPortType.class);
                    this.services.put(WSRPV2PortletManagementPortType.class, managementPortType);
                    this.portletManagementURL = (String)((BindingProvider)managementPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    WSRPV2RegistrationPortType registrationPortType = (WSRPV2RegistrationPortType)service.getPort(WSRPV2RegistrationPortType.class);
                    this.services.put(WSRPV2RegistrationPortType.class, registrationPortType);
                    this.registrationURL = (String)((BindingProvider)registrationPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    this.setFailed(false);
                    this.setAvailable(true);
                    this.isV2 = true;
                    break block5;
                }
                if (wsrp1 != null) {
                    Service service = Service.create((URL)wsdlURL, (QName)wsrp1);
                    WSRPV1MarkupPortType markupPortType = (WSRPV1MarkupPortType)service.getPort(WSRPV1MarkupPortType.class);
                    this.services.put(WSRPV1MarkupPortType.class, markupPortType);
                    this.markupURL = (String)((BindingProvider)markupPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    WSRPV1ServiceDescriptionPortType sdPort = (WSRPV1ServiceDescriptionPortType)service.getPort(WSRPV1ServiceDescriptionPortType.class);
                    this.services.put(WSRPV1ServiceDescriptionPortType.class, sdPort);
                    this.serviceDescriptionURL = (String)((BindingProvider)sdPort).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    WSRPV1PortletManagementPortType managementPortType = (WSRPV1PortletManagementPortType)service.getPort(WSRPV1PortletManagementPortType.class);
                    this.services.put(WSRPV1PortletManagementPortType.class, managementPortType);
                    this.portletManagementURL = (String)((BindingProvider)managementPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    WSRPV1RegistrationPortType registrationPortType = (WSRPV1RegistrationPortType)service.getPort(WSRPV1RegistrationPortType.class);
                    this.services.put(WSRPV1RegistrationPortType.class, registrationPortType);
                    this.registrationURL = (String)((BindingProvider)registrationPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    this.setFailed(false);
                    this.setAvailable(true);
                    this.isV2 = false;
                    break block5;
                }
                throw new IllegalArgumentException("Couldn't find any WSRP service in specified WSDL: " + this.wsdlDefinitionURL);
            }
            catch (MalformedURLException e) {
                this.setFailed(true);
                throw new IllegalArgumentException(this.wsdlDefinitionURL + " is not a well-formed URL specifying where to find the WSRP services definition.", e);
            }
            catch (Exception e) {
                this.log.info("Couldn't access WSDL information. Service won't be available", (Throwable)e);
                this.setAvailable(false);
                this.setFailed(true);
                throw e;
            }
        }
    }

    @Override
    public ServiceDescriptionService getServiceDescriptionService() throws Exception {
        if (this.isV2) {
            WSRPV2ServiceDescriptionPortType port = this.getService(WSRPV2ServiceDescriptionPortType.class);
            return new V2ServiceDescriptionService(port);
        }
        WSRPV1ServiceDescriptionPortType port = this.getService(WSRPV1ServiceDescriptionPortType.class);
        return new V1ServiceDescriptionService(port);
    }

    @Override
    public MarkupService getMarkupService() throws Exception {
        if (this.isV2) {
            WSRPV2MarkupPortType port = this.getService(WSRPV2MarkupPortType.class);
            return new V2MarkupService(port);
        }
        WSRPV1MarkupPortType port = this.getService(WSRPV1MarkupPortType.class);
        return new V1MarkupService(port);
    }

    @Override
    public PortletManagementService getPortletManagementService() throws Exception {
        if (this.isV2) {
            WSRPV2PortletManagementPortType port = this.getService(WSRPV2PortletManagementPortType.class);
            return new V2PortletManagementService(port);
        }
        WSRPV1PortletManagementPortType port = this.getService(WSRPV1PortletManagementPortType.class);
        return new V1PortletManagementService(port);
    }

    @Override
    public RegistrationService getRegistrationService() throws Exception {
        if (this.isV2) {
            WSRPV2RegistrationPortType port = this.getService(WSRPV2RegistrationPortType.class);
            return new V2RegistrationService(port);
        }
        WSRPV1RegistrationPortType port = this.getService(WSRPV1RegistrationPortType.class);
        return new V1RegistrationService(port);
    }

    @Override
    public Version getWSRPVersion() {
        if (this.isAvailable()) {
            if (this.isV2) {
                return WSRP2;
            }
            return WSRP1;
        }
        return null;
    }

    protected class WSDLInfo {
        private final QName wsrp2ServiceQName;
        private final QName wsrp1ServiceQName;

        public WSDLInfo(String wsdlURL) throws WSDLException {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", false);
            Definition definition = wsdlReader.readWSDL(wsdlURL);
            Map services = definition.getServices();
            int serviceNb = services.size();
            if (serviceNb > 2) {
                throw new WSDLException("OTHER_ERROR", "The specified WSDL contains more than 2 services definitions when we expected at most 2: one for WSRP 1 and one for WSRP 2.");
            }
            QName wsrp1 = null;
            QName wsrp2 = null;
            for (QName name : services.keySet()) {
                String ns = name.getNamespaceURI();
                javax.wsdl.Service service = (javax.wsdl.Service)services.get(name);
                if (SOAPServiceFactory.WSRP_V1_URN.equals(ns) || SOAPServiceFactory.WSRP_V2_URN.equals(ns)) {
                    Map ports = service.getPorts();
                    String bindingNSURI = null;
                    for (Port port : ports.values()) {
                        QName bindingName = port.getBinding().getQName();
                        String newBindingNS = bindingName.getNamespaceURI();
                        if (SOAPServiceFactory.WSRP_V1_BINDING.equals(newBindingNS) || SOAPServiceFactory.WSRP_V2_BINDING.equals(newBindingNS)) {
                            if (bindingNSURI != null && !bindingNSURI.equals(newBindingNS)) {
                                throw new WSDLException("OTHER_ERROR", "Inconsistent NS in port bindings. Aborting.");
                            }
                            bindingNSURI = newBindingNS;
                            continue;
                        }
                        SOAPServiceFactory.this.log.debug("Unknown binding namespace: " + newBindingNS + ". Ignoring binding: " + bindingName);
                    }
                    if (SOAPServiceFactory.WSRP_V1_BINDING.equals(bindingNSURI)) {
                        wsrp1 = this.checkPotentialServiceName(wsrp1, name, ns);
                        continue;
                    }
                    if (!SOAPServiceFactory.WSRP_V2_BINDING.equals(bindingNSURI)) continue;
                    wsrp2 = this.checkPotentialServiceName(wsrp2, name, ns);
                    continue;
                }
                SOAPServiceFactory.this.log.debug("Unknown service namespace: " + ns);
            }
            this.wsrp2ServiceQName = wsrp2;
            this.wsrp1ServiceQName = wsrp1;
            if (wsrp1 == null && wsrp2 == null) {
                throw new WSDLException("INVALID_WSDL", "Found no service definition with WSRP specification namespaces.");
            }
        }

        public QName getWSRP2ServiceQName() {
            return this.wsrp2ServiceQName;
        }

        public QName getWSRP1ServiceQName() {
            return this.wsrp1ServiceQName;
        }

        private QName checkPotentialServiceName(QName potentiallyExisting, QName candidate, String namespace) throws WSDLException {
            if (potentiallyExisting != null) {
                throw new WSDLException("OTHER_ERROR", "Found 2 different services using the " + namespace + " namespace. Cannot decide which one to use for service so aborting.");
            }
            return candidate;
        }
    }
}

