/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.gatein.wsrp.consumer.handlers.MimeResponseHandler;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceContext;
import org.oasis.wsrp.v2.ResourceParams;
import org.oasis.wsrp.v2.ResourceResponse;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandler
extends MimeResponseHandler<ResourceInvocation, GetResource, ResourceResponse, ResourceContext> {
    public ResourceHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    @Override
    protected SessionContext getSessionContextFrom(ResourceResponse resourceResponse) {
        return resourceResponse.getSessionContext();
    }

    @Override
    protected ResourceContext getMimeResponseFrom(ResourceResponse resourceResponse) {
        return resourceResponse.getResourceContext();
    }

    @Override
    protected RuntimeContext getRuntimeContextFrom(GetResource request) {
        return request.getRuntimeContext();
    }

    @Override
    protected GetResource prepareRequest(InvocationHandler.RequestPrecursor<ResourceInvocation> requestPrecursor, ResourceInvocation invocation) {
        String state;
        String resourceInvocationId = invocation.getResourceId();
        Map resourceMap = WSRPResourceURL.decodeResource((String)resourceInvocationId);
        String resourceId = (String)resourceMap.get("wsrp-resourceID");
        PortletContext portletContext = requestPrecursor.getPortletContext();
        MarkupParams params = requestPrecursor.getMarkupParams();
        InstanceContext instanceContext = invocation.getInstanceContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)instanceContext, (String)"instance context");
        AccessMode accessMode = instanceContext.getAccessMode();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)accessMode, (String)"access mode");
        if (debug) {
            log.debug("Portlet is requesting " + accessMode + " access mode");
        }
        if (ParameterValidation.isNullOrEmpty((String)resourceId)) {
            throw new IllegalArgumentException("GetResource needs a valid resource id.");
        }
        ResourceParams resourceParams = WSRPTypeFactory.createResourceParams((boolean)params.isSecureClientCommunication(), (List)params.getLocales(), (List)params.getMimeTypes(), (String)params.getMode(), (String)params.getWindowState(), (String)resourceId, (StateChange)WSRPUtils.getStateChangeFromAccessMode((AccessMode)accessMode));
        resourceParams.setNavigationalContext(params.getNavigationalContext());
        resourceParams.setClientData(params.getClientData());
        resourceParams.setResourceCacheability(WSRPUtils.getResourceCacheabilityFromCacheLevel((CacheLevel)invocation.getCacheLevel()));
        StateString resourceState = invocation.getResourceState();
        if (resourceState != null && !"JBPNS_".equals(state = resourceState.getStringValue())) {
            resourceParams.setResourceState(state);
        }
        return WSRPTypeFactory.createGetResource((RegistrationContext)requestPrecursor.getRegistrationContext(), (PortletContext)portletContext, (RuntimeContext)requestPrecursor.getRuntimeContext(), (UserContext)requestPrecursor.getUserContext(), (ResourceParams)resourceParams);
    }

    @Override
    protected ResourceResponse performRequest(GetResource request) throws Exception {
        Holder sessionContextHolder = new Holder();
        Holder resourceContextHolder = new Holder();
        Holder portletContextHolder = new Holder((Object)request.getPortletContext());
        this.consumer.getMarkupService().getResource(request.getRegistrationContext(), (Holder<PortletContext>)portletContextHolder, request.getRuntimeContext(), request.getUserContext(), request.getResourceParams(), (Holder<ResourceContext>)resourceContextHolder, (Holder<SessionContext>)sessionContextHolder, (Holder<List<Extension>>)new Holder());
        ResourceResponse resourceResponse = WSRPTypeFactory.createResourceResponse((ResourceContext)((ResourceContext)resourceContextHolder.value));
        resourceResponse.setPortletContext((PortletContext)portletContextHolder.value);
        resourceResponse.setSessionContext((SessionContext)sessionContextHolder.value);
        return resourceResponse;
    }
}

