/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services;

import java.lang.reflect.ParameterizedType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;
import org.gatein.wsrp.handler.RequestHeaderClientHandler;
import org.gatein.wsrp.services.ManageableServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceWrapper<T> {
    protected T service;
    protected ManageableServiceFactory parentFactory;
    private static final String JBOSS_WS_TIMEOUT = "org.jboss.ws.timeout";
    private static final String SUN_WS_TIMEOUT = "com.sun.xml.ws.request.timeout";
    private static final String IBM_WS_TIMEOUT = "com.ibm.SOAP.requestTimeout";
    private static final RequestHeaderClientHandler REQUEST_HEADER_CLIENT_HANDLER = new RequestHeaderClientHandler();
    private static final String JBOSS_WS_STUBEXT_PROPERTY_CHUNKED_ENCODING_SIZE = "http://org.jboss.ws/http#chunksize";

    protected ServiceWrapper(Object service, ManageableServiceFactory parentFactory) {
        if (service == null) {
            throw new IllegalArgumentException("Cannot create a ServiceWrapper without a valid service!");
        }
        Class<?> serviceClass = service.getClass();
        BindingProvider bindingProvider = (BindingProvider)service;
        ServiceWrapper.setTimeout(bindingProvider.getRequestContext(), parentFactory);
        ServiceWrapper.checkAssigmentValidity(this, serviceClass);
        this.service = service;
        this.parentFactory = parentFactory;
    }

    public static void checkAssigmentValidity(ServiceWrapper assignee, Class expectedImplementedInterface) {
        Class tClass = (Class)((ParameterizedType)assignee.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (!tClass.isAssignableFrom(expectedImplementedInterface)) {
            throw new IllegalArgumentException(assignee + " is not an instance of " + tClass.getSimpleName());
        }
    }

    private static void setTimeout(Map<String, Object> requestContext, ManageableServiceFactory parentFactory) {
        int timeout = parentFactory.getWSOperationTimeOut();
        requestContext.put(JBOSS_WS_TIMEOUT, timeout);
        requestContext.put(SUN_WS_TIMEOUT, timeout);
        requestContext.put(IBM_WS_TIMEOUT, timeout);
    }

    public static <T> T getServiceWrapper(Class<T> expectedServiceInterface, Object service, String portAddress, ManageableServiceFactory parentFactory) {
        BindingProvider bindingProvider = (BindingProvider)service;
        Map requestContext = bindingProvider.getRequestContext();
        ServiceWrapper.setTimeout(requestContext, parentFactory);
        requestContext.put("javax.xml.ws.service.endpoint.address", portAddress);
        requestContext.put(JBOSS_WS_STUBEXT_PROPERTY_CHUNKED_ENCODING_SIZE, "0");
        Binding binding = bindingProvider.getBinding();
        ArrayList<RequestHeaderClientHandler> handlerChain = binding.getHandlerChain();
        if (handlerChain != null) {
            if (!handlerChain.contains(REQUEST_HEADER_CLIENT_HANDLER)) {
                handlerChain.add(REQUEST_HEADER_CLIENT_HANDLER);
            }
        } else {
            handlerChain = new ArrayList<RequestHeaderClientHandler>(1);
            handlerChain.add(REQUEST_HEADER_CLIENT_HANDLER);
        }
        binding.setHandlerChain(handlerChain);
        return expectedServiceInterface.cast(service);
    }

    protected void handleRemoteException(RemoteException e) throws RemoteException {
        if (!(e.getCause() instanceof SOAPFaultException)) {
            this.parentFactory.setAvailable(false);
        }
        throw e;
    }
}

