/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import org.gatein.common.util.ParameterValidation;
import org.gatein.common.util.Version;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.wsrp.services.MarkupService;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.services.RegistrationService;
import org.gatein.wsrp.services.SOAPServiceFactory;
import org.gatein.wsrp.services.ServiceDescriptionService;
import org.gatein.wsrp.services.ServiceFactory;
import org.oasis.wsrp.v2.WSRPV2MarkupPortType;
import org.oasis.wsrp.v2.WSRPV2PortletManagementPortType;
import org.oasis.wsrp.v2.WSRPV2RegistrationPortType;
import org.oasis.wsrp.v2.WSRPV2ServiceDescriptionPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointConfigurationInfo {
    private static final Logger log = LoggerFactory.getLogger(EndpointConfigurationInfo.class);
    private transient ServiceFactory serviceFactory;
    private transient String remoteHostAddress;
    private transient boolean started;

    public EndpointConfigurationInfo() {
        this.serviceFactory = new SOAPServiceFactory();
    }

    public EndpointConfigurationInfo(ServiceFactory serviceFactory) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)serviceFactory, (String)"ServiceFactory");
        this.serviceFactory = serviceFactory;
    }

    public String getWsdlDefinitionURL() {
        return this.serviceFactory.getWsdlDefinitionURL();
    }

    public void setWsdlDefinitionURL(String wsdlDefinitionURL) {
        this.serviceFactory.setWsdlDefinitionURL(wsdlDefinitionURL);
    }

    public void start() throws Exception {
        if (!this.started) {
            this.serviceFactory.start();
            this.started = true;
        }
    }

    public void stop() throws Exception {
        if (this.started) {
            this.serviceFactory.stop();
            this.started = false;
        }
    }

    ServiceFactory getServiceFactory() {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.serviceFactory;
    }

    ServiceDescriptionService getServiceDescriptionService() throws InvokerUnavailableException {
        try {
            return this.serviceFactory.getServiceDescriptionService();
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't access ServiceDescription service. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    MarkupService getMarkupService() throws InvokerUnavailableException {
        try {
            return this.serviceFactory.getMarkupService();
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't access Markup service. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    PortletManagementService getPortletManagementService() throws InvokerUnavailableException {
        try {
            return this.serviceFactory.getPortletManagementService();
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't access PortletManagement service. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    RegistrationService getRegistrationService() throws InvokerUnavailableException {
        try {
            return this.serviceFactory.getRegistrationService();
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't access Registration service. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private <T> T getService(Class<T> clazz) throws InvokerUnavailableException {
        return this.getService(clazz, this.getServiceFactory());
    }

    private <T> T getService(Class<T> clazz, ServiceFactory serviceFactory) throws InvokerUnavailableException {
        try {
            return serviceFactory.getService(clazz);
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't access " + clazz.getSimpleName() + " service. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean isAvailable() {
        return this.serviceFactory.isAvailable();
    }

    public boolean isRefreshNeeded() {
        boolean result;
        boolean bl = result = !this.isAvailable();
        if (result && log.isDebugEnabled()) {
            log.debug("Refresh needed");
        }
        return result;
    }

    public boolean refresh() throws InvokerUnavailableException {
        return this.isRefreshNeeded() && this.forceRefresh();
    }

    boolean forceRefresh() throws InvokerUnavailableException {
        this.getService(WSRPV2ServiceDescriptionPortType.class, this.serviceFactory);
        this.getService(WSRPV2MarkupPortType.class, this.serviceFactory);
        this.getService(WSRPV2PortletManagementPortType.class, this.serviceFactory);
        this.getService(WSRPV2RegistrationPortType.class, this.serviceFactory);
        return true;
    }

    public String getRemoteHostAddress() {
        if (this.remoteHostAddress == null) {
            String wsdl = this.getWsdlDefinitionURL();
            int hostBegin = wsdl.indexOf("://") + 3;
            this.remoteHostAddress = wsdl.substring(0, wsdl.indexOf(47, hostBegin));
        }
        return this.remoteHostAddress;
    }

    public void setWSOperationTimeOut(int msBeforeTimeOut) {
        this.serviceFactory.setWSOperationTimeOut(msBeforeTimeOut);
    }

    public int getWSOperationTimeOut() {
        return this.serviceFactory.getWSOperationTimeOut();
    }

    Version getWSRPVersion() {
        return this.serviceFactory.getWSRPVersion();
    }
}

