/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.gatein.common.io.IOTools;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.net.media.TypeDef;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.InvocationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.ActionHandler;
import org.gatein.wsrp.consumer.handlers.EventHandler;
import org.gatein.wsrp.consumer.handlers.RenderHandler;
import org.gatein.wsrp.consumer.handlers.ResourceHandler;
import org.gatein.wsrp.handler.CookieUtil;

public class InvocationDispatcher {
    private final ActionHandler actionHandler;
    private final RenderHandler renderHandler;
    private final ResourceHandler resourceHandler;
    private final EventHandler eventHandler;
    private final WSRPConsumerImpl consumer;

    public InvocationDispatcher(WSRPConsumerImpl consumer) {
        this.consumer = consumer;
        this.actionHandler = new ActionHandler(consumer);
        this.renderHandler = new RenderHandler(consumer);
        this.resourceHandler = new ResourceHandler(consumer);
        this.eventHandler = new EventHandler(consumer);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public PortletInvocationResponse dispatchAndHandle(PortletInvocation invocation) throws PortletInvokerException {
        boolean preferOperation;
        String preferOperationAsString;
        String resourceURL;
        String resourceId;
        void var2_6;
        if (invocation instanceof RenderInvocation) {
            RenderHandler renderHandler = this.renderHandler;
            return var2_6.handle(invocation);
        }
        if (invocation instanceof ActionInvocation) {
            ActionHandler actionHandler = this.actionHandler;
            return var2_6.handle(invocation);
        }
        if (!(invocation instanceof ResourceInvocation)) {
            if (!(invocation instanceof EventInvocation)) throw new InvocationException("Unknown invocation type: " + invocation);
            EventHandler eventHandler = this.eventHandler;
            return var2_6.handle(invocation);
        }
        ResourceInvocation resourceInvocation = (ResourceInvocation)invocation;
        String resourceInvocationId = resourceInvocation.getResourceId();
        if (!ParameterValidation.isNullOrEmpty((String)resourceInvocationId)) {
            Map resourceMap = WSRPResourceURL.decodeResource((String)resourceInvocationId);
            resourceId = (String)resourceMap.get("wsrp-resourceID");
            resourceURL = (String)resourceMap.get("wsrp-url");
            preferOperationAsString = (String)resourceMap.get("wsrp-preferOperation");
        } else {
            resourceId = (String)resourceInvocation.getAttribute("wsrp-resourceID");
            resourceURL = (String)resourceInvocation.getAttribute("wsrp-url");
            preferOperationAsString = (String)resourceInvocation.getAttribute("wsrp-preferOperation");
        }
        boolean bl = preferOperation = preferOperationAsString != null && Boolean.parseBoolean(preferOperationAsString);
        if (this.consumer.isUsingWSRP2() && (preferOperation || resourceURL == null || resourceId != null && resourceId.length() > 0)) {
            ResourceHandler resourceHandler = this.resourceHandler;
            return var2_6.handle(invocation);
        }
        if (resourceURL == null) return new ErrorResponse("Did not get a resource URL or a resource ID, cannot fetch resource.");
        return this.performDirectURLRequest(resourceURL);
    }

    private PortletInvocationResponse performDirectURLRequest(String resourceURL) {
        try {
            ContentResponse result;
            URL url = new URL(resourceURL);
            URLConnection urlConnection = url.openConnection();
            String contentType = urlConnection.getContentType();
            Map<String, List<String>> headers = urlConnection.getHeaderFields();
            ResponseProperties props = new ResponseProperties();
            MultiValuedPropertyMap transportHeaders = props.getTransportHeaders();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                List<String> values;
                String key = entry.getKey();
                if (key == null || (values = entry.getValue()) == null) continue;
                if ("Set-Cookie".equals(key)) {
                    Cookie[] cookies = CookieUtil.extractCookiesFrom(url, values.toArray(new String[values.size()]));
                    List propCookies = props.getCookies();
                    for (Cookie cookie : cookies) {
                        propCookies.add(CookieUtil.convertFrom(cookie));
                    }
                    continue;
                }
                for (String value : values) {
                    transportHeaders.addValue(key, (Object)value);
                }
            }
            int length = urlConnection.getContentLength();
            length = length > 0 ? length : 4096;
            byte[] bytes = IOTools.getBytes((InputStream)urlConnection.getInputStream(), (int)length);
            MediaType type = MediaType.create((String)contentType);
            if (TypeDef.TEXT.equals(type.getType())) {
                String charset = "UTF-8";
                if (contentType != null) {
                    for (String part : contentType.split(";")) {
                        if (!part.startsWith("charset=")) continue;
                        charset = part.substring("charset=".length());
                    }
                }
                result = new ContentResponse(props, Collections.emptyMap(), contentType, null, new String(bytes, charset), null);
            } else {
                result = new ContentResponse(props, Collections.emptyMap(), contentType, bytes, null, null);
            }
            return result;
        }
        catch (IOException e) {
            return new ErrorResponse((Throwable)e);
        }
    }
}

