/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.EventInfo;
import org.gatein.pc.api.info.TypeInfo;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.RefreshResult;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.portlet.WSRPPortlet;
import org.gatein.wsrp.consumer.portlet.info.WSRPEventInfo;
import org.gatein.wsrp.consumer.portlet.info.WSRPPortletInfo;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.servlet.UserAccess;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.ExportDescription;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.ExtensionDescription;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.ItemDescription;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.LocalizedString;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModelTypes;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ServiceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerInfo {
    private static final Logger log = LoggerFactory.getLogger(ProducerInfo.class);
    private static final boolean debug = log.isDebugEnabled();
    public static final Integer DEFAULT_CACHE_VALUE = 300;
    private String key;
    private EndpointConfigurationInfo persistentEndpointInfo;
    private RegistrationInfo persistentRegistrationInfo;
    private String persistentId;
    private Integer persistentExpirationCacheSeconds = DEFAULT_CACHE_VALUE;
    private boolean persistentActive;
    private CookieProtocol requiresInitCookie;
    private Map<String, Portlet> popsMap;
    private Map<String, Portlet> ccpsMap;
    private Map<String, Set<Portlet>> portletGroups;
    private long expirationTimeMillis;
    private boolean isModifyRegistrationRequired;
    private ConsumerRegistry registry;
    private static final String ERASED_LOCAL_REGISTRATION_INFORMATION = "Erased local registration information!";
    private transient RegistrationInfo expectedRegistrationInfo;
    private Map<String, ItemDescription> customModes;
    private Map<String, ItemDescription> customWindowStates;
    private Map<QName, EventInfo> eventDescriptions;

    public ProducerInfo() {
        this.persistentEndpointInfo = new EndpointConfigurationInfo();
        this.persistentRegistrationInfo = RegistrationInfo.createUndeterminedRegistration(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProducerInfo that = (ProducerInfo)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return this.persistentId.equals(that.persistentId);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + this.persistentId.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProducerInfo");
        sb.append("{key='").append(this.key).append('\'');
        sb.append(", id='").append(this.persistentId).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public ConsumerRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ConsumerRegistry registry) {
        this.registry = registry;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Set<String> getSupportedCustomModes() {
        if (this.customModes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.customModes.keySet());
    }

    public Set<String> getSupportedCustomWindowStates() {
        if (this.customWindowStates == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.customWindowStates.keySet());
    }

    public EndpointConfigurationInfo getEndpointConfigurationInfo() {
        return this.persistentEndpointInfo;
    }

    public void setEndpointConfigurationInfo(EndpointConfigurationInfo endpointConfigurationInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)endpointConfigurationInfo, (String)"EndpointConfigurationInfo");
        this.persistentEndpointInfo = endpointConfigurationInfo;
    }

    public RegistrationInfo getRegistrationInfo() {
        this.persistentRegistrationInfo.setParent(this);
        return this.persistentRegistrationInfo;
    }

    public void setRegistrationInfo(RegistrationInfo registrationInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationInfo, (String)"RegistrationInfo");
        this.persistentRegistrationInfo = registrationInfo;
    }

    public boolean isRegistered() {
        return this.persistentRegistrationInfo.isRegistered();
    }

    public boolean isRegistrationRequired() {
        return this.persistentRegistrationInfo.isRegistrationDeterminedRequired();
    }

    public boolean isRegistrationChecked() {
        return this.persistentRegistrationInfo.isRegistrationRequired() != null;
    }

    public boolean hasLocalRegistrationInfo() {
        return this.persistentRegistrationInfo.hasLocalInfo();
    }

    public boolean isActive() {
        return this.persistentActive;
    }

    public void setActive(boolean active) {
        this.persistentActive = active;
    }

    public void setActiveAndSave(boolean active) {
        this.setActive(active);
        this.registry.updateProducerInfo(this);
    }

    public boolean isModifyRegistrationRequired() {
        return this.isModifyRegistrationRequired || this.persistentRegistrationInfo.isModifyRegistrationNeeded();
    }

    public void setModifyRegistrationRequired(boolean modifyRegistrationRequired) {
        this.isModifyRegistrationRequired = modifyRegistrationRequired;
    }

    public CookieProtocol getRequiresInitCookie() {
        return this.requiresInitCookie;
    }

    public RegistrationInfo getExpectedRegistrationInfo() {
        return this.expectedRegistrationInfo;
    }

    public boolean refresh(boolean forceRefresh) throws PortletInvokerException {
        return this.detailedRefresh(forceRefresh).didRefreshHappen();
    }

    public RefreshResult detailedRefresh(boolean forceRefresh) throws PortletInvokerException {
        RefreshResult result = this.internalRefresh(forceRefresh);
        if (RefreshResult.Status.FAILURE.equals((Object)result.getStatus())) {
            this.setActiveAndSave(false);
            return result;
        }
        if (result.didRefreshHappen()) {
            if (result.hasIssues()) {
                this.setActive(false);
                this.expectedRegistrationInfo = new RegistrationInfo(this.persistentRegistrationInfo);
                this.expectedRegistrationInfo.refresh(result.getServiceDescription(), this.getId(), true, true, true);
            } else {
                if (!this.isActive()) {
                    this.setActive(true);
                }
                this.expectedRegistrationInfo = this.persistentRegistrationInfo;
            }
            this.registry.updateProducerInfo(this);
        }
        return result;
    }

    private RefreshResult internalRefresh(boolean forceRefresh) throws PortletInvokerException {
        if (this.isModifyRegistrationRequired()) {
            return new RefreshResult(RefreshResult.Status.MODIFY_REGISTRATION_REQUIRED);
        }
        if (forceRefresh || this.isRefreshNeeded(true)) {
            ServiceDescription serviceDescription2;
            log.debug("Refreshing info for producer '" + this.getId() + "'");
            RefreshResult result = new RefreshResult();
            try {
                this.persistentEndpointInfo.refresh();
            }
            catch (InvokerUnavailableException e) {
                log.debug("Couldn't refresh endpoint information, attempting a second time: " + (Object)((Object)e), (Throwable)e);
                try {
                    this.persistentEndpointInfo.forceRefresh();
                }
                catch (InvokerUnavailableException e1) {
                    result.setStatus(RefreshResult.Status.FAILURE);
                    return result;
                }
            }
            try {
                serviceDescription2 = this.getUnmanagedServiceDescription(this.persistentRegistrationInfo.isUndetermined());
                result.setServiceDescription(serviceDescription2);
            }
            catch (OperationFailed operationFailedFault) {
                if (this.hasLocalRegistrationInfo()) {
                    log.debug("OperationFailedFault occurred, might indicate a need to modify registration", (Throwable)operationFailedFault);
                    return this.handleModifyRegistrationNeeded(result);
                }
                serviceDescription2 = this.rethrowAsInvokerUnvailable((Exception)((Object)operationFailedFault));
            }
            catch (InvalidRegistration invalidRegistrationFault) {
                log.debug("InvalidRegistrationFault occurred", (Throwable)invalidRegistrationFault);
                ServiceDescription serviceDescription2 = this.getServiceDescription(true);
                result.setServiceDescription(serviceDescription2);
                RefreshResult registrationResult = this.internalRefreshRegistration(serviceDescription2, false, true, true);
                if (registrationResult.hasIssues()) {
                    this.setActiveAndSave(false);
                    this.rethrowAsInvokerUnvailable((Exception)((Object)invalidRegistrationFault));
                }
                return this.refreshInfo(false, serviceDescription2, result);
            }
            catch (ModifyRegistrationRequired modifyRegistrationRequired) {
                return this.handleModifyRegistrationNeeded(result);
            }
            return this.refreshInfo(forceRefresh, serviceDescription2, result);
        }
        return new RefreshResult(RefreshResult.Status.BYPASSED);
    }

    private RefreshResult handleModifyRegistrationNeeded(RefreshResult result) throws PortletInvokerException {
        ServiceDescription serviceDescription = this.getServiceDescription(true);
        result.setServiceDescription(serviceDescription);
        RefreshResult registrationResult = this.internalRefreshRegistration(serviceDescription, false, true, true);
        if (registrationResult.hasIssues()) {
            this.setModifyRegistrationRequired(true);
            this.setActive(false);
        } else {
            log.debug("modifyRegistration was called after OperationFailedFault when a check of registration data didn't reveal any issue...");
            this.modifyRegistration(true);
        }
        result.setRegistrationResult(registrationResult);
        return result;
    }

    private RefreshResult refreshInfo(boolean forceRefresh, ServiceDescription serviceDescription, RefreshResult result) throws PortletInvokerException {
        this.requiresInitCookie = serviceDescription.getRequiresInitCookie();
        log.debug("Requires initCookie: " + this.requiresInitCookie);
        this.customModes = this.toMap(serviceDescription.getCustomModeDescriptions());
        this.customWindowStates = this.toMap(serviceDescription.getCustomWindowStateDescriptions());
        List eventDescriptions = serviceDescription.getEventDescriptions();
        if (!eventDescriptions.isEmpty()) {
            this.eventDescriptions = new HashMap<QName, EventInfo>(eventDescriptions.size());
            for (final EventDescription event : eventDescriptions) {
                QName name = event.getName();
                WSRPEventInfo eventInfo = new WSRPEventInfo(name, WSRPUtils.convertToCommonLocalizedStringOrNull((LocalizedString)event.getLabel()), WSRPUtils.convertToCommonLocalizedStringOrNull((LocalizedString)event.getDescription()), new TypeInfo(){

                    public String getName() {
                        return event.getType().toString();
                    }

                    public XmlRootElement getXMLBinding() {
                        throw new NotYetImplemented();
                    }
                }, event.getAliases());
                this.eventDescriptions.put(name, eventInfo);
            }
        }
        if (serviceDescription.isRequiresRegistration()) {
            RefreshResult registrationResult = this.internalRefreshRegistration(serviceDescription, true, forceRefresh, false);
            if (!registrationResult.hasIssues()) {
                registrationResult = this.register(serviceDescription, false);
                if (!registrationResult.hasIssues()) {
                    serviceDescription = this.getServiceDescription(false);
                }
                this.extractOfferedPortlets(serviceDescription);
            }
            result.setRegistrationResult(registrationResult);
            return result;
        }
        log.debug("Registration not required");
        this.persistentRegistrationInfo = new RegistrationInfo(this, false);
        this.extractOfferedPortlets(serviceDescription);
        return result;
    }

    private Map<String, ItemDescription> toMap(List<ItemDescription> itemDescriptions) {
        if (itemDescriptions == null) {
            return null;
        }
        HashMap<String, ItemDescription> result = new HashMap<String, ItemDescription>(itemDescriptions.size());
        for (ItemDescription itemDescription : itemDescriptions) {
            result.put(itemDescription.getItemName(), itemDescription);
        }
        return result;
    }

    public String getId() {
        return this.persistentId;
    }

    public void setId(String id) {
        this.persistentId = id;
    }

    private Map extractOfferedPortlets(ServiceDescription sd) {
        if (sd == null) {
            throw new IllegalArgumentException("Provided ServiceDescription can't be null");
        }
        List portletDescriptions = sd.getOfferedPortlets();
        if (portletDescriptions != null) {
            int length = portletDescriptions.size();
            log.debug("Extracting " + length + " portlets.");
            this.popsMap = new LinkedHashMap<String, Portlet>(length);
            this.portletGroups = new HashMap<String, Set<Portlet>>();
            for (PortletDescription portletDescription : portletDescriptions) {
                WSRPPortlet wsrpPortlet = this.createWSRPPortletFromPortletDescription(portletDescription);
                if (wsrpPortlet == null) continue;
                this.popsMap.put(wsrpPortlet.getContext().getId(), wsrpPortlet);
            }
        } else {
            this.popsMap = Collections.emptyMap();
            this.portletGroups = Collections.emptyMap();
        }
        this.resetCacheTimerIfNeeded();
        return this.popsMap;
    }

    WSRPPortlet createWSRPPortletFromPortletDescription(PortletDescription portletDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletDescription, (String)"PortletDescription");
        String portletHandle = portletDescription.getPortletHandle();
        log.debug("Extracting info for '" + portletHandle + "' portlet");
        WSRPPortletInfo info = new WSRPPortletInfo(portletDescription, this);
        WSRPPortlet wsrpPortlet = null;
        if (info.isUsesMethodGet()) {
            log.warn("Portlet '" + portletHandle + "' uses the GET method in forms. Since we don't handle this, this portlet will be excluded from " + "the list of offered portlets for producer " + this.persistentId);
        } else {
            if (info.isHasUserSpecificState()) {
                log.debug("Portlet '" + portletHandle + "' will store persistent state for each user.");
            }
            wsrpPortlet = new WSRPPortlet(PortletContext.createPortletContext((String)portletHandle), info);
            String portletGroupId = portletDescription.getGroupID();
            if (portletGroupId != null) {
                Set<Portlet> groupedPortlets = this.portletGroups.get(portletGroupId);
                if (groupedPortlets == null) {
                    groupedPortlets = new HashSet<Portlet>();
                    this.portletGroups.put(portletGroupId, groupedPortlets);
                }
                groupedPortlets.add(wsrpPortlet);
            }
        }
        return wsrpPortlet;
    }

    public Portlet getPortlet(PortletContext portletContext) throws PortletInvokerException {
        String portletHandle = portletContext.getId();
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"Portlet handle", (String)"getPortlet");
        log.debug("Retrieving portlet '" + portletHandle + "'");
        boolean justRefreshed = this.refresh(false);
        Portlet portlet = this.getPortletFromCaches(portletHandle, justRefreshed);
        if (portlet != null) {
            log.debug("Portlet was cached");
            return portlet;
        }
        log.debug("Trying to retrieve portlet via getPortletDescription");
        try {
            Holder descriptionHolder = new Holder();
            this.persistentEndpointInfo.getPortletManagementService().getPortletDescription(this.getRegistrationContext(), WSRPUtils.convertToWSRPPortletContext((PortletContext)portletContext), UserAccess.getUserContext(), WSRPConstants.getDefaultLocales(), (Holder<PortletDescription>)descriptionHolder, (Holder<ResourceList>)new Holder(), (Holder<List<Extension>>)new Holder());
            portlet = this.createWSRPPortletFromPortletDescription((PortletDescription)descriptionHolder.value);
            if (this.ccpsMap == null) {
                this.ccpsMap = new HashMap<String, Portlet>();
            }
            this.ccpsMap.put(portletHandle, portlet);
            return portlet;
        }
        catch (InvalidHandle invalidHandleFault) {
            throw new NoSuchPortletException((Throwable)invalidHandleFault, portletHandle);
        }
        catch (Exception e) {
            log.debug("Couldn't get portlet via getPortletDescription for producer '" + this.persistentId + "'. Attempting to retrieve it from the service description as this producer might not support the PortletManagement interface.", (Throwable)e);
            justRefreshed = this.refresh(true);
            portlet = this.getPortletFromCaches(portletHandle, justRefreshed);
            if (portlet == null) {
                throw new NoSuchPortletException(portletHandle);
            }
            return portlet;
        }
    }

    private Portlet getPortletFromCaches(String portletHandle, boolean justRefreshed) {
        Portlet portlet = null;
        if (justRefreshed || this.useCache() && !this.isCacheExpired()) {
            log.debug("Trying cached POPs");
            portlet = this.popsMap.get(portletHandle);
            if (portlet == null && this.ccpsMap != null) {
                log.debug("Trying cached CCPs");
                portlet = this.ccpsMap.get(portletHandle);
            }
        }
        return portlet;
    }

    Map<String, Set<Portlet>> getPortletGroupMap() throws PortletInvokerException {
        return this.portletGroups;
    }

    public Map<String, Portlet> getPortletMap() throws PortletInvokerException {
        this.refresh(false);
        return this.popsMap;
    }

    private boolean useCache() {
        return this.persistentExpirationCacheSeconds != null && this.persistentExpirationCacheSeconds > 0;
    }

    private void resetCacheTimerIfNeeded() {
        this.expirationTimeMillis = System.currentTimeMillis() + (long)(this.getSafeExpirationCacheSeconds() * 1000);
    }

    private boolean isCacheExpired() {
        boolean result;
        boolean bl = result = !this.useCache() || System.currentTimeMillis() > this.expirationTimeMillis || this.popsMap == null || this.portletGroups == null;
        if (result) {
            log.debug("Cache expired or not used");
        }
        return result;
    }

    public Integer getExpirationCacheSeconds() {
        return this.persistentExpirationCacheSeconds;
    }

    public void setExpirationCacheSeconds(Integer expirationCacheSeconds) {
        Integer previousMS = this.getSafeExpirationCacheSeconds() * 1000;
        this.persistentExpirationCacheSeconds = expirationCacheSeconds;
        long lastExpirationTimeChange = this.expirationTimeMillis - (long)previousMS.intValue();
        int newMS = this.getSafeExpirationCacheSeconds() * 1000;
        this.expirationTimeMillis = lastExpirationTimeChange > 0L ? lastExpirationTimeChange + (long)newMS : System.currentTimeMillis();
    }

    private int getSafeExpirationCacheSeconds() {
        return this.useCache() ? this.persistentExpirationCacheSeconds : 0;
    }

    private ServiceDescription getUnmanagedServiceDescription(boolean asUnregistered) throws PortletInvokerException, OperationFailed, InvalidRegistration, ModifyRegistrationRequired {
        try {
            Holder requiresRegistration = new Holder();
            Holder offeredPortlets = new Holder();
            Holder userCategoryDescriptions = new Holder();
            Holder windowStateDescriptions = new Holder();
            Holder modeDescriptions = new Holder();
            Holder requiresInitCookie = new Holder();
            Holder registrationPropertyDescription = new Holder();
            Holder locales = new Holder();
            Holder resourceList = new Holder();
            Holder eventDescriptions = new Holder();
            Holder schemaTypes = new Holder();
            Holder supportedOptions = new Holder();
            Holder exportDescription = new Holder();
            Holder mayReturnRegistrationState = new Holder();
            this.persistentEndpointInfo.getServiceDescriptionService().getServiceDescription(asUnregistered ? null : this.getRegistrationContext(), WSRPConstants.getDefaultLocales(), null, UserAccess.getUserContext(), (Holder<Boolean>)requiresRegistration, (Holder<List<PortletDescription>>)offeredPortlets, (Holder<List<ItemDescription>>)userCategoryDescriptions, (Holder<List<ExtensionDescription>>)new Holder(), (Holder<List<ItemDescription>>)windowStateDescriptions, (Holder<List<ItemDescription>>)modeDescriptions, (Holder<CookieProtocol>)requiresInitCookie, (Holder<ModelDescription>)registrationPropertyDescription, (Holder<List<String>>)locales, (Holder<ResourceList>)resourceList, (Holder<List<EventDescription>>)eventDescriptions, (Holder<ModelTypes>)schemaTypes, (Holder<List<String>>)supportedOptions, (Holder<ExportDescription>)exportDescription, (Holder<Boolean>)mayReturnRegistrationState, (Holder<List<Extension>>)new Holder());
            ServiceDescription serviceDescription = WSRPTypeFactory.createServiceDescription((boolean)((Boolean)requiresRegistration.value));
            serviceDescription.setRegistrationPropertyDescription((ModelDescription)registrationPropertyDescription.value);
            serviceDescription.setRequiresInitCookie((CookieProtocol)requiresInitCookie.value);
            serviceDescription.setResourceList((ResourceList)resourceList.value);
            if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)modeDescriptions.value))) {
                serviceDescription.getCustomModeDescriptions().addAll((Collection)modeDescriptions.value);
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)windowStateDescriptions.value))) {
                serviceDescription.getCustomWindowStateDescriptions().addAll((Collection)windowStateDescriptions.value);
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)locales.value))) {
                serviceDescription.getLocales().addAll((Collection)locales.value);
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)offeredPortlets.value))) {
                serviceDescription.getOfferedPortlets().addAll((Collection)offeredPortlets.value);
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)userCategoryDescriptions.value))) {
                serviceDescription.getUserCategoryDescriptions().addAll((Collection)userCategoryDescriptions.value);
            }
            return serviceDescription;
        }
        catch (Exception e) {
            log.debug("Caught Exception in getServiceDescription:\n", (Throwable)e);
            this.setActiveAndSave(false);
            if (e instanceof InvalidRegistration) {
                this.resetRegistration();
                throw (InvalidRegistration)((Object)e);
            }
            if (e instanceof OperationFailed) {
                throw (OperationFailed)((Object)e);
            }
            if (e instanceof ModifyRegistrationRequired) {
                throw (ModifyRegistrationRequired)((Object)e);
            }
            return this.rethrowAsInvokerUnvailable(e);
        }
    }

    ServiceDescription getServiceDescription(boolean asUnregistered) throws PortletInvokerException {
        try {
            return this.getUnmanagedServiceDescription(asUnregistered);
        }
        catch (OperationFailed operationFailedFault) {
            return this.rethrowAsInvokerUnvailable((Exception)((Object)operationFailedFault));
        }
        catch (InvalidRegistration invalidRegistrationFault) {
            return this.rethrowAsInvokerUnvailable((Exception)((Object)invalidRegistrationFault));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            return this.rethrowAsInvokerUnvailable((Exception)((Object)modifyRegistrationRequired));
        }
    }

    private ServiceDescription rethrowAsInvokerUnvailable(Exception e) throws InvokerUnavailableException {
        Throwable cause = e.getCause();
        throw new InvokerUnavailableException("Problem getting service description for producer " + this.persistentId + ", please see the logs for more information. ", cause == null ? e : cause);
    }

    public RegistrationContext getRegistrationContext() throws PortletInvokerException {
        if (this.persistentRegistrationInfo.isUndetermined()) {
            this.refresh(false);
        }
        return this.persistentRegistrationInfo.getRegistrationContext();
    }

    public void resetRegistration() throws PortletInvokerException {
        this.persistentRegistrationInfo.resetRegistration();
        this.invalidateCache();
        this.registry.updateProducerInfo(this);
    }

    public PortletPropertyDescriptionResponse getPropertyDescriptionsFor(String portletHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", null);
        try {
            PortletManagementService service = this.getEndpointConfigurationInfo().getPortletManagementService();
            Holder modelDescription = new Holder();
            Holder resourceList = new Holder();
            service.getPortletPropertyDescription(this.getRegistrationContext(), WSRPTypeFactory.createPortletContext((String)portletHandle), UserAccess.getUserContext(), WSRPConstants.getDefaultLocales(), modelDescription, resourceList, new Holder());
            PortletPropertyDescriptionResponse response = WSRPTypeFactory.createPortletPropertyDescriptionResponse(null);
            response.setModelDescription((ModelDescription)modelDescription.value);
            response.setResourceList((ResourceList)resourceList.value);
            return response;
        }
        catch (InvalidHandle invalidHandleFault) {
            throw new IllegalArgumentException("Unknown portlet '" + portletHandle + "'");
        }
        catch (InvalidRegistration invalidRegistrationFault) {
            try {
                this.resetRegistration();
            }
            catch (PortletInvokerException e) {
                throw new RuntimeException("Couldn't reset registration", e);
            }
            throw new IllegalArgumentException("Couldn't get property descriptions for portlet '" + portletHandle + "' because the provided registration is invalid!");
        }
        catch (Exception e) {
            log.debug("Couldn't get property descriptions for portlet '" + portletHandle + "'", (Throwable)e);
            return null;
        }
    }

    public void register() throws PortletInvokerException {
        try {
            this.register(null, false);
        }
        catch (PortletInvokerException e) {
            this.registry.updateProducerInfo(this);
            throw e;
        }
    }

    private RefreshResult register(ServiceDescription serviceDescription, boolean forceRefresh) throws PortletInvokerException {
        if (!this.isRegistered()) {
            this.persistentEndpointInfo.refresh();
            if (serviceDescription == null) {
                serviceDescription = this.getServiceDescription(false);
            }
            if (serviceDescription.isRequiresRegistration()) {
                RegistrationInfo.RegistrationRefreshResult result = this.persistentRegistrationInfo.refresh(serviceDescription, this.persistentId, true, forceRefresh, false);
                if (!result.hasIssues()) {
                    try {
                        log.debug("Attempting registration");
                        RegistrationData registrationData = this.persistentRegistrationInfo.getRegistrationData();
                        Holder registrationHandle = new Holder();
                        Holder registrationState = new Holder();
                        this.persistentEndpointInfo.getRegistrationService().register(registrationData, null, UserAccess.getUserContext(), (Holder<byte[]>)registrationState, (Holder<Lifetime>)new Holder(), (Holder<List<Extension>>)new Holder(), (Holder<String>)registrationHandle);
                        RegistrationContext registrationContext = WSRPTypeFactory.createRegistrationContext((String)((String)registrationHandle.value));
                        registrationContext.setRegistrationState((byte[])registrationState.value);
                        this.persistentRegistrationInfo.setRegistrationContext(registrationContext);
                        if (debug) {
                            String msg = "Consumer with id '" + this.persistentId + "' successfully registered with handle: '" + registrationContext.getRegistrationHandle() + "'";
                            log.debug(msg);
                        }
                        RefreshResult res = new RefreshResult();
                        res.setRegistrationResult(result);
                        return res;
                    }
                    catch (Exception e) {
                        this.persistentRegistrationInfo.resetRegistration();
                        this.setActive(false);
                        throw new PortletInvokerException("Couldn't register with producer '" + this.persistentId + "'", (Throwable)e);
                    }
                }
                log.debug(result.getStatus().toString());
                this.setActive(false);
                throw new PortletInvokerException("Consumer is not ready to be registered with producer because of missing or invalid registration information.");
            }
        }
        return new RefreshResult(RefreshResult.Status.BYPASSED);
    }

    public void deregister() throws PortletInvokerException {
        if (this.isRegistered()) {
            this.persistentEndpointInfo.refresh();
            try {
                RegistrationContext registrationContext = this.getRegistrationContext();
                this.persistentEndpointInfo.getRegistrationService().deregister(registrationContext, UserAccess.getUserContext());
                log.info("Consumer with id '" + this.persistentId + "' deregistered.");
            }
            catch (Exception e) {
                throw new PortletInvokerException("Couldn't deregister with producer '" + this.persistentId + "'", (Throwable)e);
            }
            finally {
                this.resetRegistration();
            }
        } else {
            throw new IllegalStateException("Cannot deregister producer '" + this.persistentId + "' as it's not registered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRegistration() throws PortletInvokerException {
        try {
            this.modifyRegistration(false);
        }
        finally {
            this.registry.updateProducerInfo(this);
        }
    }

    private void modifyRegistration(boolean force) throws PortletInvokerException {
        if (this.persistentRegistrationInfo.getRegistrationHandle() != null) {
            this.persistentEndpointInfo.refresh();
            if (force || this.isModifyRegistrationRequired()) {
                try {
                    RegistrationContext registrationContext = this.getRegistrationContext();
                    Holder registrationState = new Holder();
                    this.persistentEndpointInfo.getRegistrationService().modifyRegistration(registrationContext, this.persistentRegistrationInfo.getRegistrationData(), UserAccess.getUserContext(), (Holder<byte[]>)registrationState, (Holder<Lifetime>)new Holder(), (Holder<List<Extension>>)new Holder());
                    this.persistentRegistrationInfo.setRegistrationValidInternalState();
                    this.setModifyRegistrationRequired(false);
                    this.persistentRegistrationInfo.setRegistrationState((byte[])registrationState.value);
                    log.info("Consumer with id '" + this.persistentId + "' sucessfully modified its registration.");
                    this.invalidateCache();
                }
                catch (Exception e) {
                    throw new PortletInvokerException("Couldn't modify registration with producer '" + this.persistentId + "'", (Throwable)e);
                }
            }
        } else {
            throw new IllegalStateException("Cannot modify registration for producer '" + this.persistentId + "' as it's not registered");
        }
    }

    private void invalidateCache() {
        if (this.useCache()) {
            this.expirationTimeMillis = System.currentTimeMillis();
        }
    }

    private RefreshResult internalRefreshRegistration(ServiceDescription serviceDescription, boolean mergeWithLocalInfo, boolean forceRefresh, boolean forceCheckOfExtraProps) throws PortletInvokerException {
        RegistrationInfo.RegistrationRefreshResult result = this.persistentRegistrationInfo.refresh(serviceDescription, this.persistentId, mergeWithLocalInfo, forceRefresh, forceCheckOfExtraProps);
        log.debug("Refreshed registration information for consumer with id '" + this.persistentId + "'");
        return result;
    }

    public boolean isRefreshNeeded(boolean considerCache) {
        boolean result;
        boolean bl = result = considerCache && this.isCacheExpired() || this.persistentRegistrationInfo.isRefreshNeeded() || this.persistentEndpointInfo.isRefreshNeeded();
        if (result) {
            log.debug("Refresh needed for producer '" + this.persistentId + "'");
        }
        return result;
    }

    void removeHandleFromCaches(String portletHandle) {
        log.debug("Removing '" + portletHandle + "' from caches.");
        this.ccpsMap.remove(portletHandle);
        this.popsMap.remove(portletHandle);
    }

    public void eraseRegistrationInfo() {
        this.persistentRegistrationInfo = RegistrationInfo.createUndeterminedRegistration(this);
        this.registry.updateProducerInfo(this);
        log.warn(ERASED_LOCAL_REGISTRATION_INFORMATION);
    }

    public EventInfo getInfoForEvent(QName name) {
        if (this.eventDescriptions == null) {
            return null;
        }
        return this.eventDescriptions.get(name);
    }
}

