/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.federation.FederatedPortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.api.session.SessionEventBroadcaster;
import org.gatein.wsrp.api.session.SessionEventListener;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumerRegistry
implements ConsumerRegistry {
    private FederatingPortletInvoker federatingPortletInvoker;
    private SortedMap<String, WSRPConsumer> consumers;
    private Map<String, String> keysToIds;
    private SessionEventBroadcaster sessionEventBroadcaster = SessionEventBroadcaster.NO_OP_BROADCASTER;
    private MigrationService migrationService;
    private static final String CONSUMER_WITH_ID = "Consumer with id '";
    private static final String RELEASE_SESSIONS_LISTENER = "release_sessions_listener_";
    private static final Logger log = LoggerFactory.getLogger(AbstractConsumerRegistry.class);

    protected AbstractConsumerRegistry() {
        this.initConsumers(null);
    }

    @Override
    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    @Override
    public void setSessionEventBroadcaster(SessionEventBroadcaster sessionEventBroadcaster) {
        this.sessionEventBroadcaster = sessionEventBroadcaster;
    }

    @Override
    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    @Override
    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    @Override
    public WSRPConsumer createConsumer(String id, Integer expirationCacheSeconds, String wsdlURL) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Creating a Consumer");
        if (this.getConsumer(id) != null) {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' already exists!");
        }
        ProducerInfo info = new ProducerInfo();
        info.setId(id);
        info.setRegistry(this);
        info.setExpirationCacheSeconds(expirationCacheSeconds);
        info.getEndpointConfigurationInfo().setWsdlDefinitionURL(wsdlURL);
        this.save(info, "Couldn't create Consumer '" + id + "'");
        log.debug(CONSUMER_WITH_ID + id + "' created");
        return this.createConsumerFrom(info);
    }

    @Override
    public void destroyConsumer(String id) {
        ProducerInfo info;
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Destroying a Consumer");
        WSRPConsumer consumer = this.getConsumer(id);
        if (consumer != null) {
            info = consumer.getProducerInfo();
            try {
                consumer.releaseSessions();
            }
            catch (PortletInvokerException e) {
                log.debug("releaseSessions failed when attempting to destroy Consumer with id '" + id + "'");
            }
            if (info.isRegistered()) {
                this.registerOrDeregisterConsumerWith(id, false);
            }
        } else {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' doesn't exist!");
        }
        this.deactivateConsumer(consumer);
        this.remove(consumer);
        this.delete(info);
        log.debug(CONSUMER_WITH_ID + id + "' destroyed");
    }

    @Override
    public void persistConsumer(WSRPConsumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        ProducerInfo info = consumer.getProducerInfo();
        this.save(info, CONSUMER_WITH_ID + info.getId() + "' couldn't be persisted!");
        this.createConsumerFrom(info);
    }

    @Override
    public void setFederatingPortletInvoker(FederatingPortletInvoker federatingPortletInvoker) {
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    @Override
    public ProducerInfo getProducerInfoByKey(String key) {
        String id = this.keysToIds.get(key);
        if (id != null) {
            return this.getConsumer(id).getProducerInfo();
        }
        return null;
    }

    private WSRPConsumer createConsumerFrom(ProducerInfo producerInfo) {
        WSRPConsumer consumer = this.newConsumer(producerInfo);
        this.add(consumer);
        return consumer;
    }

    protected WSRPConsumer newConsumer(ProducerInfo producerInfo) {
        return new WSRPConsumerImpl(producerInfo, this.migrationService);
    }

    @Override
    public void activateConsumerWith(String id) throws ConsumerException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Activating a Consumer");
        this.activateConsumer(this.getConsumer(id));
    }

    protected void activateConsumer(WSRPConsumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"WSRPConsumer");
        String id = consumer.getProducerId();
        if (this.federatingPortletInvoker.getFederatedInvoker(id) == null) {
            this.startOrStopConsumer(consumer, true);
        } else if (!consumer.isActive()) {
            this.federatingPortletInvoker.unregisterInvoker(id);
            this.startOrStopConsumer(consumer, true);
        }
    }

    @Override
    public void deactivateConsumerWith(String id) throws ConsumerException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Deactivating a Consumer");
        this.deactivateConsumer(this.getConsumer(id));
    }

    protected void deactivateConsumer(WSRPConsumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        String id = consumer.getProducerId();
        if (this.federatingPortletInvoker.getFederatedInvoker(id) != null) {
            this.startOrStopConsumer(consumer, false);
        } else if (consumer.isActive()) {
            this.federatingPortletInvoker.registerInvoker(id, (PortletInvoker)consumer);
            this.startOrStopConsumer(consumer, false);
        }
    }

    @Override
    public void updateProducerInfo(ProducerInfo producerInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)producerInfo, (String)"ProducerInfo");
        String oldId = this.update(producerInfo);
        if (oldId != null) {
            this.remove(this.getConsumer(oldId));
            WSRPConsumer consumer = this.createConsumerFrom(producerInfo);
            FederatedPortletInvoker invoker = this.federatingPortletInvoker.getFederatedInvoker(oldId);
            if (invoker != null) {
                this.federatingPortletInvoker.unregisterInvoker(oldId);
                this.federatingPortletInvoker.registerInvoker(producerInfo.getId(), (PortletInvoker)consumer);
            }
        }
    }

    @Override
    public void start() throws Exception {
        this.reloadConsumers();
    }

    @Override
    public void reloadConsumers() {
        this.initConsumers(null);
        Iterator<ProducerInfo> producerInfos = this.getProducerInfosFromStorage();
        while (producerInfos.hasNext()) {
            ProducerInfo producerInfo = producerInfos.next();
            producerInfo.setRegistry(this);
            this.createConsumerFrom(producerInfo);
        }
    }

    @Override
    public void stop() throws Exception {
        for (WSRPConsumer consumer : this.getConsumers(false)) {
            String producerId = consumer.getProducerId();
            if (consumer.getProducerInfo().isActive() && this.federatingPortletInvoker.getFederatedInvoker(producerId) != null) {
                this.federatingPortletInvoker.unregisterInvoker(producerId);
            }
            try {
                consumer.stop();
            }
            catch (Exception e) {}
        }
        this.clearConsumers();
    }

    @Override
    public List<WSRPConsumer> getConfiguredConsumers() {
        return new ArrayList<WSRPConsumer>(this.getConsumers());
    }

    @Override
    public WSRPConsumer getConsumer(String id) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"consumer id", null);
        return (WSRPConsumer)this.consumers.get(id);
    }

    @Override
    public void registerOrDeregisterConsumerWith(String id, boolean register) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Registering or deregistering a Consumer");
        WSRPConsumer consumer = this.getConsumer(id);
        if (consumer == null) {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' doesn't exist!");
        }
        try {
            if (register) {
                consumer.getProducerInfo().register();
            } else {
                consumer.getProducerInfo().deregister();
            }
        }
        catch (Exception e) {
            this.deactivateConsumer(consumer);
            Throwable cause = e.getCause();
            throw new ConsumerException("Couldn't " + (register ? "register" : "deregister") + CONSUMER_WITH_ID + id + "'", cause != null ? cause : e);
        }
    }

    private void startOrStopConsumer(WSRPConsumer consumer, boolean start) {
        block5: {
            try {
                String id = consumer.getProducerId();
                if (start) {
                    consumer.activate();
                    this.federatingPortletInvoker.registerInvoker(id, (PortletInvoker)consumer);
                    this.sessionEventBroadcaster.registerListener(this.getListenerIdFrom(id), (SessionEventListener)consumer);
                    break block5;
                }
                FederatedPortletInvoker fedInvoker = this.federatingPortletInvoker.getFederatedInvoker(id);
                if (fedInvoker != null) {
                    PortletInvoker invoker = fedInvoker.getPortletInvoker();
                    if (invoker instanceof WSRPConsumer) {
                        consumer = (WSRPConsumer)invoker;
                        consumer.deactivate();
                        this.federatingPortletInvoker.unregisterInvoker(id);
                        this.sessionEventBroadcaster.unregisterListener(this.getListenerIdFrom(id));
                        break block5;
                    }
                    throw new IllegalArgumentException("PortletInvoker with id '" + id + "' is not a WSRPConsumer!");
                }
                throw new IllegalArgumentException("There is no registered PortletInvoker with id '" + id + "'");
            }
            catch (Exception e) {
                throw new ConsumerException("Couldn't " + (start ? "start" : "stop") + " Consumer service '" + consumer.getProducerId() + "'", e);
            }
        }
        this.updateProducerInfo(consumer.getProducerInfo());
    }

    private String getListenerIdFrom(String id) {
        return RELEASE_SESSIONS_LISTENER + id;
    }

    protected abstract void save(ProducerInfo var1, String var2) throws ConsumerException;

    protected abstract void delete(ProducerInfo var1) throws ConsumerException;

    protected abstract String update(ProducerInfo var1);

    protected abstract Iterator<ProducerInfo> getProducerInfosFromStorage();

    protected void add(WSRPConsumer consumer) {
        String id = consumer.getProducerId();
        this.consumers.put(id, consumer);
        ProducerInfo info = consumer.getProducerInfo();
        this.keysToIds.put(info.getKey(), id);
    }

    protected WSRPConsumer remove(WSRPConsumer consumer) {
        String id = this.keysToIds.remove(consumer.getProducerInfo().getKey());
        return (WSRPConsumer)this.consumers.remove(id);
    }

    protected Collection<WSRPConsumer> getConsumers() {
        return this.getConsumers(true);
    }

    protected Collection<WSRPConsumer> getConsumers(boolean startConsumers) {
        Collection<WSRPConsumer> consumerz = this.consumers.values();
        if (startConsumers) {
            for (WSRPConsumer consumer : consumerz) {
                if (!consumer.getProducerInfo().isActive() || consumer.isActive()) continue;
                try {
                    consumer.refresh(false);
                }
                catch (Exception e) {
                    log.info("Couldn't activate consumer " + consumer.getProducerId());
                    consumer.getProducerInfo().setActiveAndSave(false);
                }
            }
        }
        return consumerz;
    }

    protected Map<String, String> getKeyMappings() {
        return Collections.unmodifiableMap(this.keysToIds);
    }

    protected void initConsumers(SortedMap<String, WSRPConsumer> consumers) {
        if (!ParameterValidation.existsAndIsNotEmpty(consumers)) {
            consumers = new TreeMap<String, WSRPConsumer>();
        }
        this.consumers = consumers;
        int size = consumers.size();
        this.keysToIds = size == 0 ? new HashMap<String, String>() : new HashMap(size);
    }

    private void clearConsumers() {
        this.consumers.clear();
        this.keysToIds.clear();
        this.consumers = null;
        this.keysToIds = null;
    }

    protected class ProducerInfoIterator
    implements Iterator<ProducerInfo> {
        private Iterator<WSRPConsumer> consumers;

        public ProducerInfoIterator(Iterator<WSRPConsumer> consumers) {
            this.consumers = consumers;
        }

        @Override
        public boolean hasNext() {
            return this.consumers.hasNext();
        }

        @Override
        public ProducerInfo next() {
            return this.consumers.next().getProducerInfo();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported on this iterator implementation");
        }
    }
}

