/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.api.session.SessionEvent;
import org.gatein.wsrp.api.session.SessionEventListener;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;
import org.gatein.wsrp.consumer.portlet.info.WSRPPortletInfo;
import org.gatein.wsrp.handler.RequestHeaderClientHandler;
import org.gatein.wsrp.servlet.UserAccess;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.SessionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHandler
implements SessionEventListener {
    protected WSRPConsumerImpl consumer;
    private static Logger log = LoggerFactory.getLogger(SessionHandler.class);
    private static final String SESSION_ID_PREFIX = "org.gatein.wsrp.session.";
    private Map<String, ProducerSessionInformation> sessionInfos = new ConcurrentHashMap<String, ProducerSessionInformation>();

    public SessionHandler(WSRPConsumerImpl consumer) {
        this.consumer = consumer;
    }

    public boolean isPerUserCookieInit() {
        return CookieProtocol.PER_USER.equals((Object)this.getRequiresInitCookie());
    }

    public boolean requiresInitCookie() {
        return this.getRequiresInitCookie() != null && !CookieProtocol.NONE.equals((Object)this.getRequiresInitCookie());
    }

    void initProducerSessionInformation(PortletInvocation invocation) throws PortletInvokerException {
        String groupId;
        if (this.requiresGroupInitCookie()) {
            WSRPPortletInfo info = this.consumer.getPortletInfo(invocation);
            groupId = info.getGroupId();
        } else {
            groupId = null;
        }
        RequestHeaderClientHandler.setCurrentInfo(groupId, this.getProducerSessionInformation(invocation, true));
    }

    private boolean requiresGroupInitCookie() {
        return this.requiresInitCookie() && CookieProtocol.PER_GROUP.equals((Object)this.getRequiresInitCookie());
    }

    public void resetCurrentlyHeldInformation() {
        RequestHeaderClientHandler.resetCurrentInfo();
    }

    public void initCookieIfNeeded(PortletInvocation invocation) throws PortletInvokerException {
        this.initCookieIfNeeded(invocation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCookieIfNeeded(PortletInvocation invocation, boolean retryIfFails) throws PortletInvokerException {
        if (!this.requiresInitCookie()) {
            log.debug("Doesn't require initCookie");
            return;
        }
        ProducerSessionInformation sessionInformation = this.getProducerSessionInformation(invocation);
        if (sessionInformation.isInitCookieDone()) {
            return;
        }
        RequestHeaderClientHandler.setCurrentInfo(null, sessionInformation);
        if (this.isPerUserCookieInit()) {
            log.debug("Cookie initialization per user requested.");
            sessionInformation.setPerGroupCookies(false);
            this.initCookie(invocation, retryIfFails);
        } else {
            log.debug("Cookie initialization per group requested.");
            sessionInformation.setPerGroupCookies(true);
            Map<String, Set<Portlet>> groups = this.consumer.getPortletGroupMap();
            try {
                for (String groupId : groups.keySet()) {
                    RequestHeaderClientHandler.setCurrentGroupId(groupId);
                    log.debug("Initializing cookie for group '" + groupId + "'.");
                    this.initCookie(invocation, retryIfFails);
                }
            }
            finally {
                this.resetCurrentlyHeldInformation();
            }
        }
        sessionInformation.setInitCookieDone(true);
    }

    private void initCookie(PortletInvocation invocation, boolean retryIfFails) throws PortletInvokerException {
        try {
            this.consumer.getMarkupService().initCookie(this.consumer.getRegistrationContext(), UserAccess.getUserContext());
        }
        catch (InvalidRegistration invalidRegistration) {
            this.consumer.handleInvalidRegistrationFault();
            if (retryIfFails) {
                this.initCookieIfNeeded(invocation, false);
            }
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't init cookies!", (Throwable)e);
        }
    }

    void setSessionIdIfNeeded(PortletInvocation invocation, RuntimeContext runtimeContext, String portletHandle) {
        ProducerSessionInformation producerSessionInfo = this.getProducerSessionInformation(invocation, false);
        if (producerSessionInfo != null) {
            String sessionId = producerSessionInfo.getSessionIdForPortlet(portletHandle);
            SessionParams sessionParams = runtimeContext.getSessionParams();
            if (sessionParams == null) {
                sessionParams = WSRPTypeFactory.createSessionParams((String)sessionId);
                runtimeContext.setSessionParams(sessionParams);
            } else {
                sessionParams.setSessionID(sessionId);
            }
        }
    }

    public void updateSessionIfNeeded(SessionContext sessionContext, PortletInvocation invocation, String portletHandle) {
        if (sessionContext != null) {
            log.debug("Portlet '" + portletHandle + "' created session with id '" + sessionContext.getSessionID() + "'");
            ProducerSessionInformation sessionInfo = this.getProducerSessionInformation(invocation);
            sessionInfo.addSessionForPortlet(portletHandle, sessionContext);
        }
    }

    void updateCookiesIfNeeded(PortletInvocation invocation) {
        ProducerSessionInformation currentSessionInfo;
        ProducerSessionInformation sessionInfo = this.getProducerSessionInformation(invocation, true);
        if (sessionInfo != (currentSessionInfo = RequestHeaderClientHandler.getCurrentProducerSessionInformation())) {
            sessionInfo.replaceUserCookiesWith(currentSessionInfo);
        }
    }

    public ProducerSessionInformation getProducerSessionInformation(PortletInvocation invocation) {
        return this.getProducerSessionInformation(invocation, true);
    }

    private ProducerSessionInformation getProducerSessionInformation(PortletInvocation invocation, boolean create) {
        HttpSession session = WSRPConsumerImpl.getHttpSession(invocation);
        return this.getProducerSessionInformation(session, create);
    }

    public ProducerSessionInformation getProducerSessionInformation(HttpSession session) {
        return this.getProducerSessionInformation(session, false);
    }

    private ProducerSessionInformation getProducerSessionInformation(HttpSession session, boolean create) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)session, (String)"Session");
        String producerSessionKey = this.getProducerSessionInformationKey();
        ProducerSessionInformation sessionInformation = (ProducerSessionInformation)session.getAttribute(producerSessionKey);
        if (sessionInformation != null) {
            sessionInformation.setParent(this);
            sessionInformation.setParentSessionId(session.getId());
        } else if (create) {
            sessionInformation = new ProducerSessionInformation();
            sessionInformation.setParentSessionId(session.getId());
            session.setAttribute(producerSessionKey, (Object)sessionInformation);
            sessionInformation.setParent(this);
        }
        return sessionInformation;
    }

    private String getProducerSessionInformationKey() {
        return SESSION_ID_PREFIX + this.consumer.getProducerId();
    }

    void handleInvalidSessionFault(PortletInvocation invocation, RuntimeContext runtimeContext) {
        log.info("Resending information after InvalidSessionFault");
        this.invalidateSession(invocation);
        if (runtimeContext != null) {
            runtimeContext.setSessionParams(null);
        }
    }

    private void invalidateSession(PortletInvocation invocation) {
        HttpSession session = WSRPConsumerImpl.getHttpSession(invocation);
        ProducerSessionInformation info = this.getProducerSessionInformation(session, false);
        if (info != null) {
            try {
                this.internalReleaseSessions(info.removeSessions());
            }
            catch (PortletInvokerException e) {
                // empty catch block
            }
        }
        session.removeAttribute(this.getProducerSessionInformationKey());
        RequestHeaderClientHandler.resetCurrentInfo();
    }

    public void releaseSessions() throws PortletInvokerException {
        ArrayList<String> idsToRelease = new ArrayList<String>();
        HashSet<ProducerSessionInformation> uniqueInfos = new HashSet<ProducerSessionInformation>(this.sessionInfos.values());
        for (ProducerSessionInformation info : uniqueInfos) {
            idsToRelease.addAll(info.removeSessions());
        }
        this.internalReleaseSessions(idsToRelease);
    }

    void releaseSessions(String[] sessionIds) throws PortletInvokerException {
        if (sessionIds != null) {
            ArrayList<String> idsToRelease = new ArrayList<String>();
            for (String sessionId : sessionIds) {
                ProducerSessionInformation info = this.sessionInfos.get(sessionId);
                if ((sessionId = info.removeSession(sessionId)) == null) continue;
                idsToRelease.add(sessionId);
            }
            this.internalReleaseSessions(idsToRelease);
        }
    }

    private void internalReleaseSessions(List<String> idsToRelease) throws PortletInvokerException {
        if (idsToRelease != null && !idsToRelease.isEmpty()) {
            try {
                this.consumer.getMarkupService().releaseSessions(this.consumer.getRegistrationContext(), idsToRelease, UserAccess.getUserContext());
            }
            catch (InvalidRegistration invalidRegistration) {
                log.debug("Invalid Registration");
                this.consumer.handleInvalidRegistrationFault();
            }
            catch (Exception e) {
                String message = "Couldn't release sessions " + idsToRelease;
                log.debug(message, (Throwable)e);
                throw new PortletInvokerException(message, (Throwable)e);
            }
        }
    }

    void removeSessionId(String id) {
        this.sessionInfos.remove(id);
    }

    void addSessionMapping(String sessionID, ProducerSessionInformation producerSessionInformation) {
        this.sessionInfos.put(sessionID, producerSessionInformation);
    }

    public void onSessionEvent(SessionEvent event) {
        if (SessionEvent.SessionEventType.SESSION_DESTROYED.equals((Object)event.getType())) {
            String id = event.getSession().getId();
            ProducerSessionInformation info = RequestHeaderClientHandler.getCurrentProducerSessionInformation();
            if (info != null && id != null && id.equals(info.getParentSessionId())) {
                try {
                    this.internalReleaseSessions(info.removeSessions());
                }
                catch (PortletInvokerException e) {
                    // empty catch block
                }
                log.debug("Released session '" + id + "' after session was destroyed by Portal.");
            }
        }
    }

    public void updateSessionInfoFor(String originalHandle, String newHandle, PortletInvocation invocation) {
        ProducerSessionInformation info = this.getProducerSessionInformation(invocation, false);
        if (info != null) {
            info.updateHandleAssociatedInfo(originalHandle, newHandle);
        }
    }

    private CookieProtocol getRequiresInitCookie() {
        return this.consumer.getProducerInfo().getRequiresInitCookie();
    }
}

