/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import org.oasis.wsrp.v2.ServiceDescription;

public class RefreshResult {
    private ServiceDescription serviceDescription;
    private Status status;
    private RefreshResult registrationResult;

    public RefreshResult() {
        this(Status.SUCCESS);
    }

    public RefreshResult(Status status) {
        this.status = status;
    }

    public RefreshResult getRegistrationResult() {
        return this.registrationResult;
    }

    public void setRegistrationResult(RefreshResult registrationResult) {
        if (registrationResult != null) {
            this.registrationResult = registrationResult;
            Status regStatus = registrationResult.getStatus();
            if (!Status.BYPASSED.equals((Object)regStatus)) {
                this.status = regStatus;
            }
        }
    }

    public boolean didRefreshHappen() {
        return !Status.BYPASSED.equals((Object)this.status);
    }

    public boolean hasIssues() {
        return !Status.SUCCESS.equals((Object)this.status) && !Status.BYPASSED.equals((Object)this.status);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setServiceDescription(ServiceDescription serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        UNAVAILABLE,
        BYPASSED,
        UNKNOWN,
        MODIFY_REGISTRATION_REQUIRED;

    }
}

