/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.util.ParameterValidation;
import org.gatein.common.util.Version;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.wsrp.UserContextConverter;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.api.session.SessionEvent;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RefreshResult;
import org.gatein.wsrp.consumer.handlers.InvocationDispatcher;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;
import org.gatein.wsrp.consumer.handlers.SessionHandler;
import org.gatein.wsrp.consumer.migration.ExportInfo;
import org.gatein.wsrp.consumer.migration.ImportInfo;
import org.gatein.wsrp.consumer.migration.InMemoryMigrationService;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.portlet.WSRPPortlet;
import org.gatein.wsrp.consumer.portlet.info.WSRPPortletInfo;
import org.gatein.wsrp.consumer.spi.WSRPConsumerSPI;
import org.gatein.wsrp.services.MarkupService;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.services.RegistrationService;
import org.gatein.wsrp.services.ServiceDescriptionService;
import org.gatein.wsrp.servlet.UserAccess;
import org.oasis.wsrp.v2.ExportedPortlet;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.FailedPortlets;
import org.oasis.wsrp.v2.ImportPortlet;
import org.oasis.wsrp.v2.ImportPortletsFailed;
import org.oasis.wsrp.v2.ImportedPortlet;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.PropertyList;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ResetProperty;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRPConsumerImpl
implements WSRPConsumerSPI {
    private final SessionHandler sessionHandler;
    private final InvocationDispatcher dispatcher;
    private ProducerInfo producerInfo;
    private transient MigrationService migrationService;
    private static final RegistrationData REGISTRATION_NOT_NEEDED = WSRPTypeFactory.createDefaultRegistrationData();
    private static final Logger log = LoggerFactory.getLogger(WSRPConsumer.class);
    private static final String PORTLET_INFO_KEY = "wsrp_portlet_info";
    private static final Set<String> WSRP_DEFAULT_USER_SCOPE;
    private Set supportedUserScopes = WSRP_DEFAULT_USER_SCOPE;
    private transient boolean started;

    public WSRPConsumerImpl() {
        this(new ProducerInfo(), new InMemoryMigrationService());
    }

    public WSRPConsumerImpl(ProducerInfo info, MigrationService migrationService) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)info, (String)"ProducerInfo");
        this.producerInfo = info;
        this.sessionHandler = new SessionHandler(this);
        this.dispatcher = new InvocationDispatcher(this);
        this.migrationService = migrationService;
    }

    @Override
    public ProducerInfo getProducerInfo() {
        return this.producerInfo;
    }

    public Set<Portlet> getPortlets() throws InvokerUnavailableException {
        try {
            Map<String, Portlet> portletMap = this.producerInfo.getPortletMap();
            return new LinkedHashSet<Portlet>(portletMap.values());
        }
        catch (Exception e) {
            throw new InvokerUnavailableException(e.getMessage(), e.getCause());
        }
    }

    public Portlet getPortlet(org.gatein.pc.api.PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        Portlet portlet = this.producerInfo.getPortlet(portletContext);
        if (portlet == null) {
            throw new NoSuchPortletException(portletContext.getId());
        }
        return portlet;
    }

    public PortletStatus getStatus(org.gatein.pc.api.PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        if (this.producerInfo.getPortlet(portletContext) != null) {
            return PortletStatus.OFFERED;
        }
        return null;
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        return this.dispatcher.dispatchAndHandle(invocation);
    }

    public org.gatein.pc.api.PortletContext createClone(PortletStateType stateType, org.gatein.pc.api.PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        if (!PortletStateType.OPAQUE.equals(stateType)) {
            throw new IllegalArgumentException("This PortletInvoker cannot deal with PortletStateTypes other than PortletStateType.OPAQUE. Given: " + stateType);
        }
        WSRPPortlet original = this.getWSRPPortlet(portletContext);
        if (original == null) {
            throw new PortletInvokerException("No portlet '" + portletContext.getId() + "' to clone!");
        }
        try {
            Holder handle = new Holder();
            Holder portletState = new Holder();
            this.getPortletManagementService().clonePortlet(this.getRegistrationContext(), WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)portletContext), UserAccess.getUserContext(), null, (Holder<String>)handle, (Holder<byte[]>)portletState, (Holder<Lifetime>)new Holder(), (Holder<List<Extension>>)new Holder());
            return WSRPUtils.convertToPortalPortletContext((String)((String)handle.value), (byte[])((byte[])portletState.value));
        }
        catch (Exception e) {
            throw new PortletInvokerException("Couldn't clone portlet '" + portletContext.getId() + "'", (Throwable)e);
        }
    }

    public List<DestroyCloneFailure> destroyClones(List<org.gatein.pc.api.PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull(portletContexts, (String)"Portlet identifiers");
        int numberOfClones = portletContexts.size();
        if (numberOfClones == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> handles = new ArrayList<String>(numberOfClones);
        Iterator<org.gatein.pc.api.PortletContext> i$ = portletContexts.iterator();
        while (i$.hasNext()) {
            org.gatein.pc.api.PortletContext portletContext;
            org.gatein.pc.api.PortletContext context = portletContext = i$.next();
            String id = context.getId();
            handles.add(id);
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempting to destroy clones: " + handles);
        }
        try {
            Holder failedPortlets = new Holder();
            this.getPortletManagementService().destroyPortlets(this.getRegistrationContext(), handles, UserAccess.getUserContext(), (Holder<List<FailedPortlets>>)failedPortlets, (Holder<List<Extension>>)new Holder());
            List failures = (List)failedPortlets.value;
            List<DestroyCloneFailure> result = Collections.emptyList();
            if (failures != null) {
                result = new ArrayList<DestroyCloneFailure>(failures.size());
                for (FailedPortlets failure : failures) {
                    List portletHandles = failure.getPortletHandles();
                    String reason = failure.getReason().getValue();
                    for (String portletHandle : portletHandles) {
                        result.add(new DestroyCloneFailure(portletHandle, reason));
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Couldn't destroy clone '" + portletHandles + "'");
                    }
                    handles.removeAll(portletHandles);
                }
            }
            if (!handles.isEmpty()) {
                for (String handle : handles) {
                    this.producerInfo.removeHandleFromCaches(handle);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PortletInvokerException("Couldn't destroy clones.", (Throwable)e);
        }
    }

    public PropertyMap getProperties(org.gatein.pc.api.PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull(keys, (String)"Portlet ids");
        return this.getProperties(portletContext, new ArrayList<String>(keys));
    }

    private PropertyMap getProperties(org.gatein.pc.api.PortletContext portletContext, List<String> keys) throws PortletInvokerException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        try {
            Holder properties = new Holder();
            Holder resetProperties = new Holder();
            this.getPortletManagementService().getPortletProperties(this.getRegistrationContext(), WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)portletContext), UserAccess.getUserContext(), keys, (Holder<List<Property>>)properties, (Holder<List<ResetProperty>>)resetProperties, (Holder<List<Extension>>)new Holder());
            List props = (List)properties.value;
            if (props != null) {
                SimplePropertyMap result = new SimplePropertyMap(props.size());
                for (Property prop : props) {
                    String name = prop.getName().toString();
                    String value = prop.getStringValue();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(value);
                    result.put((Object)name, list);
                }
                return result;
            }
            return new SimplePropertyMap();
        }
        catch (OperationNotSupported operationNotSupported) {
            throw new UnsupportedOperationException(operationNotSupported);
        }
        catch (InvalidHandle invalidHandle) {
            throw new InvalidPortletIdException((Throwable)invalidHandle, portletContext.getId());
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw new IllegalArgumentException(inconsistentParameters);
        }
        catch (Exception e) {
            throw new PortletInvokerException((Throwable)e);
        }
    }

    public PropertyMap getProperties(org.gatein.pc.api.PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        return this.getProperties(portletContext, Collections.<String>emptyList());
    }

    public org.gatein.pc.api.PortletContext setProperties(org.gatein.pc.api.PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((Object[])changes, (String)"Property changes");
        WSRPPortlet portlet = this.getWSRPPortlet(portletContext);
        if (portlet == null) {
            throw new PortletInvokerException("Cannot set properties on portlet '" + portletContext.getId() + "' because there is no such portlet.");
        }
        PropertyList propertyList = WSRPTypeFactory.createPropertyList();
        int changesNumber = changes.length;
        ArrayList<Property> updates = new ArrayList<Property>(changesNumber);
        ArrayList<ResetProperty> resets = new ArrayList<ResetProperty>(changesNumber);
        block6: for (int i = 0; i < changesNumber; ++i) {
            PropertyChange change = changes[i];
            switch (change.getType()) {
                case 1: {
                    resets.add(WSRPTypeFactory.createResetProperty((String)change.getKey()));
                    continue block6;
                }
                case 0: {
                    updates.add(WSRPTypeFactory.createProperty((String)change.getKey(), (String)WSRPConstants.DEFAULT_LOCALE, (String)((String)change.getValue().get(0))));
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected property change type: " + change.getType());
                }
            }
        }
        propertyList.getProperties().addAll(updates);
        propertyList.getResetProperties().addAll(resets);
        try {
            Holder handle = new Holder();
            Holder portletState = new Holder();
            this.getPortletManagementService().setPortletProperties(this.getRegistrationContext(), WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)portletContext), UserAccess.getUserContext(), propertyList, (Holder<String>)handle, (Holder<byte[]>)portletState, (Holder<Lifetime>)new Holder(), (Holder<List<Extension>>)new Holder());
            org.gatein.pc.api.PortletContext newPortletContext = org.gatein.pc.api.PortletContext.createPortletContext((String)((String)handle.value), (byte[])((byte[])portletState.value), (boolean)false);
            portlet.setPortletContext(newPortletContext);
            return newPortletContext;
        }
        catch (Exception e) {
            throw new PortletInvokerException("Unable to set properties for portlet '" + portletContext.getId() + "'", (Throwable)e);
        }
    }

    public org.gatein.pc.api.PortletContext exportPortlet(PortletStateType stateType, org.gatein.pc.api.PortletContext originalPortletContext) throws PortletInvokerException {
        throw new NotYetImplemented();
    }

    public org.gatein.pc.api.PortletContext importPortlet(PortletStateType stateType, org.gatein.pc.api.PortletContext originalPortletContext) throws PortletInvokerException {
        throw new NotYetImplemented();
    }

    @Override
    public String getProducerId() {
        return this.producerInfo.getId();
    }

    @Override
    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public Map<String, Set<Portlet>> getPortletGroupMap() throws PortletInvokerException {
        return this.producerInfo.getPortletGroupMap();
    }

    public static org.gatein.pc.api.PortletContext getPortletContext(PortletInvocation invocation) {
        return invocation.getTarget();
    }

    @Override
    public WSRPPortletInfo getPortletInfo(PortletInvocation invocation) throws PortletInvokerException {
        Object info = invocation.getAttribute(PORTLET_INFO_KEY);
        if (info == null) {
            info = this.getWSRPPortlet(WSRPConsumerImpl.getPortletContext(invocation)).getInfo();
            invocation.setAttribute(PORTLET_INFO_KEY, info);
        }
        return (WSRPPortletInfo)info;
    }

    WSRPPortlet getWSRPPortlet(org.gatein.pc.api.PortletContext portletContext) throws PortletInvokerException {
        return (WSRPPortlet)this.getPortlet(portletContext);
    }

    public Set getSupportedUserScopes() {
        return Collections.unmodifiableSet(this.supportedUserScopes);
    }

    @Override
    public boolean supportsUserScope(String userScope) {
        return this.supportedUserScopes.contains(userScope);
    }

    @Override
    public boolean isSupportsExport() {
        return this.isUsingWSRP2();
    }

    @Override
    public void handleInvalidRegistrationFault() throws PortletInvokerException {
        this.producerInfo.resetRegistration();
        this.refreshProducerInfo(true);
    }

    @Override
    public RegistrationContext getRegistrationContext() throws PortletInvokerException {
        return this.producerInfo.getRegistrationContext();
    }

    @Override
    public ProducerSessionInformation getProducerSessionInformationFrom(PortletInvocation invocation) {
        return this.sessionHandler.getProducerSessionInformation(invocation);
    }

    @Override
    public ProducerSessionInformation getProducerSessionInformationFrom(HttpSession session) {
        return this.sessionHandler.getProducerSessionInformation(session);
    }

    @Override
    public void activate() throws Exception {
        this.internalStart();
        this.producerInfo.setActiveAndSave(true);
        log.info("Consumer with id '" + this.getProducerId() + "' activated");
    }

    private void internalStart() throws Exception {
        if (!this.started) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.producerInfo.setActiveAndSave(false);
                throw e;
            }
        }
    }

    @Override
    public void deactivate() throws Exception {
        this.producerInfo.setActiveAndSave(false);
        if (this.started) {
            this.stop();
            log.info("Consumer with id '" + this.getProducerId() + "' deactivated");
        }
    }

    @Override
    public boolean isActive() {
        return this.producerInfo.isActive() && this.started;
    }

    @Override
    public boolean isRefreshNeeded() {
        return !this.started || this.producerInfo.isRefreshNeeded(false);
    }

    @Override
    public RefreshResult refresh(boolean forceRefresh) throws PortletInvokerException {
        try {
            this.internalStart();
        }
        catch (Exception e) {
            throw new PortletInvokerException((Throwable)e);
        }
        return this.refreshProducerInfo(forceRefresh);
    }

    @Override
    public void start() throws Exception {
        this.getEndpointConfigurationInfo().start();
        this.started = true;
        log.info("Consumer with id '" + this.getProducerId() + "' started");
    }

    @Override
    public void stop() throws Exception {
        this.getEndpointConfigurationInfo().stop();
        this.started = false;
        log.info("Consumer with id '" + this.getProducerId() + "' stopped");
    }

    private EndpointConfigurationInfo getEndpointConfigurationInfo() {
        return this.producerInfo.getEndpointConfigurationInfo();
    }

    private ServiceDescriptionService getServiceDescriptionService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getServiceDescriptionService();
    }

    @Override
    public MarkupService getMarkupService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getMarkupService();
    }

    private PortletManagementService getPortletManagementService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getPortletManagementService();
    }

    private RegistrationService getRegistrationService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getRegistrationService();
    }

    @Override
    public void refreshProducerInfo() throws PortletInvokerException {
        this.refreshProducerInfo(true);
    }

    private RefreshResult refreshProducerInfo(boolean forceRefresh) throws PortletInvokerException {
        return this.producerInfo.detailedRefresh(forceRefresh);
    }

    @Override
    public void releaseSessions() throws PortletInvokerException {
        this.sessionHandler.releaseSessions();
    }

    private String getUserContextKeyFor(UserContext userContext) {
        String userId = userContext.getId();
        if (userId != null) {
            return userId;
        }
        return null;
    }

    @Override
    public org.oasis.wsrp.v2.UserContext getUserContextFrom(WSRPPortletInfo info, PortletInvocation invocation, RuntimeContext runtimeContext) throws PortletInvokerException {
        SessionParams sessionParams = runtimeContext.getSessionParams();
        if (info != null && info.isUserContextStoredInSession() && sessionParams != null && sessionParams.getSessionID() != null) {
            return null;
        }
        UserContext userContext = invocation.getUserContext();
        if (userContext != null) {
            String userContextKey = this.getUserContextKeyFor(userContext);
            if (userContextKey == null) {
                return null;
            }
            return UserContextConverter.createWSRPUserContextFrom((UserContext)userContext, (String)userContextKey, null);
        }
        return null;
    }

    @Override
    public void setTemplatesIfNeeded(WSRPPortletInfo info, PortletInvocation invocation, RuntimeContext runtimeContext) throws PortletInvokerException {
        SessionParams sessionParams = runtimeContext.getSessionParams();
        if (info != null && info.isDoesUrlTemplateProcessing() && (!info.isTemplatesStoredInSession() || sessionParams == null || sessionParams.getSessionID() == null)) {
            runtimeContext.setTemplates(WSRPTypeFactory.createTemplates((PortletInvocationContext)invocation.getContext()));
        }
    }

    public static HttpServletRequest getHttpRequest(PortletInvocation invocation) {
        AbstractPortletInvocationContext invocationContext = (AbstractPortletInvocationContext)invocation.getContext();
        return invocationContext.getClientRequest();
    }

    public static HttpSession getHttpSession(PortletInvocation invocation) {
        return WSRPConsumerImpl.getHttpRequest(invocation).getSession();
    }

    public void onSessionEvent(SessionEvent event) {
        this.sessionHandler.onSessionEvent(event);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSRPConsumerImpl that = (WSRPConsumerImpl)o;
        return this.producerInfo.equals(that.producerInfo);
    }

    public int hashCode() {
        return this.producerInfo.hashCode();
    }

    @Override
    public ExportInfo exportPortlets(List<String> portletHandles) throws PortletInvokerException {
        if (ParameterValidation.existsAndIsNotEmpty(portletHandles)) {
            ArrayList<PortletContext> portletContexts = new ArrayList<PortletContext>(portletHandles.size());
            for (String handle : portletHandles) {
                portletContexts.add(WSRPTypeFactory.createPortletContext((String)handle));
            }
            try {
                Lifetime lifetime;
                Holder exportContextHolder = new Holder();
                Holder exportedPortletsHolder = new Holder();
                Holder failedPortletsHolder = new Holder();
                Holder lifetimeHolder = new Holder();
                this.getPortletManagementService().exportPortlets(this.getRegistrationContext(), portletContexts, UserAccess.getUserContext(), (Holder<Lifetime>)lifetimeHolder, true, (Holder<byte[]>)exportContextHolder, (Holder<List<ExportedPortlet>>)exportedPortletsHolder, (Holder<List<FailedPortlets>>)failedPortletsHolder, (Holder<ResourceList>)new Holder(), (Holder<List<Extension>>)new Holder());
                TreeMap<String, byte[]> handleToState = null;
                List exportedPortlets = (List)exportedPortletsHolder.value;
                if (ParameterValidation.existsAndIsNotEmpty((Collection)exportedPortlets)) {
                    handleToState = new TreeMap<String, byte[]>();
                    for (ExportedPortlet exportedPortlet : exportedPortlets) {
                        handleToState.put(exportedPortlet.getPortletHandle(), exportedPortlet.getExportData());
                    }
                }
                TreeMap<QName, List<String>> errorCodeToHandle = null;
                List failedPortlets = (List)failedPortletsHolder.value;
                if (ParameterValidation.existsAndIsNotEmpty((Collection)failedPortlets)) {
                    errorCodeToHandle = new TreeMap<QName, List<String>>();
                    for (FailedPortlets failedPortletsForReason : failedPortlets) {
                        errorCodeToHandle.put(failedPortletsForReason.getErrorCode(), failedPortletsForReason.getPortletHandles());
                    }
                }
                if ((lifetime = (Lifetime)lifetimeHolder.value) != null) {
                    XMLGregorianCalendar currentTime = lifetime.getCurrentTime();
                    Duration refreshDuration = lifetime.getRefreshDuration();
                    XMLGregorianCalendar terminationTime = lifetime.getTerminationTime();
                }
                ExportInfo exportInfo = new ExportInfo(System.currentTimeMillis(), errorCodeToHandle, handleToState, (byte[])exportContextHolder.value);
                this.migrationService.add(exportInfo);
                return exportInfo;
            }
            catch (OperationNotSupported operationNotSupported) {
                throw new UnsupportedOperationException(operationNotSupported);
            }
            catch (InconsistentParameters inconsistentParameters) {
                throw new IllegalArgumentException(inconsistentParameters);
            }
            catch (Exception e) {
                throw new PortletInvokerException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Must provide a non-null, non-empty list of portlet handles.");
    }

    @Override
    public void releaseExport(ExportInfo exportInfo) throws PortletInvokerException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)exportInfo, (String)"ExportInfo to release");
        this.getPortletManagementService().releaseExport(this.getRegistrationContext(), exportInfo.getExportContext(), UserAccess.getUserContext());
    }

    @Override
    public ImportInfo importPortlets(ExportInfo exportInfo, List<String> portlets) throws PortletInvokerException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)exportInfo, (String)"ExportInfo to import from");
        if (ParameterValidation.existsAndIsNotEmpty(portlets)) {
            try {
                ArrayList<ImportPortlet> importPortlets = new ArrayList<ImportPortlet>(portlets.size());
                for (String portlet : portlets) {
                    importPortlets.add(WSRPTypeFactory.createImportPortlet((String)portlet, (byte[])exportInfo.getPortletStateFor(portlet)));
                }
                Holder importedPortletsHolder = new Holder();
                Holder failedPortletsHolder = new Holder();
                Holder resourceListHolder = new Holder();
                this.getPortletManagementService().importPortlets(this.getRegistrationContext(), exportInfo.getExportContext(), importPortlets, UserAccess.getUserContext(), null, (Holder<List<ImportedPortlet>>)importedPortletsHolder, (Holder<List<ImportPortletsFailed>>)failedPortletsHolder, (Holder<ResourceList>)resourceListHolder, (Holder<List<Extension>>)new Holder());
                List importedPortlets = (List)importedPortletsHolder.value;
                TreeMap<String, org.gatein.pc.api.PortletContext> importIdToPortletContext = new TreeMap<String, org.gatein.pc.api.PortletContext>();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)importedPortlets)) {
                    for (ImportedPortlet importedPortlet : importedPortlets) {
                        PortletContext portletContext = importedPortlet.getNewPortletContext();
                        org.gatein.pc.api.PortletContext apiPC = org.gatein.pc.api.PortletContext.createPortletContext((String)portletContext.getPortletHandle(), (byte[])portletContext.getPortletState(), (boolean)false);
                        importIdToPortletContext.put(importedPortlet.getImportID(), org.gatein.pc.api.PortletContext.reference((String)this.getProducerId(), (org.gatein.pc.api.PortletContext)apiPC));
                    }
                }
                TreeMap<QName, List<String>> errorCodeToHandle = null;
                List failedPortlets = (List)failedPortletsHolder.value;
                if (ParameterValidation.existsAndIsNotEmpty((Collection)failedPortlets)) {
                    errorCodeToHandle = new TreeMap<QName, List<String>>();
                    for (ImportPortletsFailed failedPortletsForReason : failedPortlets) {
                        errorCodeToHandle.put(failedPortletsForReason.getErrorCode(), failedPortletsForReason.getImportID());
                    }
                }
                return new ImportInfo(System.currentTimeMillis(), errorCodeToHandle, importIdToPortletContext);
            }
            catch (OperationNotSupported operationNotSupported) {
                throw new UnsupportedOperationException(operationNotSupported);
            }
            catch (InconsistentParameters inconsistentParameters) {
                throw new IllegalArgumentException(inconsistentParameters);
            }
            catch (Exception e) {
                throw new PortletInvokerException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Must provide a non-null, non-empty list of portlet handles.");
    }

    @Override
    public boolean isUsingWSRP2() {
        Version wsrpVersion = this.getWSRPVersion();
        if (wsrpVersion != null) {
            return wsrpVersion.getMajor() >= 2;
        }
        return false;
    }

    @Override
    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public Version getWSRPVersion() {
        return this.producerInfo.getEndpointConfigurationInfo().getWSRPVersion();
    }

    static {
        REGISTRATION_NOT_NEEDED.setConsumerAgent("INVALID AGENT");
        REGISTRATION_NOT_NEEDED.setConsumerName("INVALID NAME");
        WSRP_DEFAULT_USER_SCOPE = new HashSet<String>(2);
        WSRP_DEFAULT_USER_SCOPE.add("wsrp:forAll");
        WSRP_DEFAULT_USER_SCOPE.add("wsrp:perUser");
    }
}

