/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.StateEvent;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.gatein.wsrp.consumer.handlers.SessionHandler;
import org.gatein.wsrp.payload.PayloadUtils;
import org.oasis.wsrp.v2.Event;
import org.oasis.wsrp.v2.NavigationalContext;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.UpdateResponse;

public abstract class NavigationalStateUpdatingHandler<Invocation extends PortletInvocation, Request, Response>
extends InvocationHandler<Invocation, Request, Response> {
    public NavigationalStateUpdatingHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    protected UpdateNavigationalStateResponse processUpdateResponse(Invocation invocation, InvocationHandler.RequestPrecursor<Invocation> requestPrecursor, UpdateResponse updateResponse) {
        List events;
        NavigationalContext navigationalContext;
        String newWindowState;
        UpdateNavigationalStateResponse result = new UpdateNavigationalStateResponse();
        String newMode = updateResponse.getNewMode();
        if (newMode != null) {
            result.setMode(WSRPUtils.getJSR168PortletModeFromWSRPName((String)newMode));
        }
        if ((newWindowState = updateResponse.getNewWindowState()) != null) {
            result.setWindowState(WSRPUtils.getJSR168WindowStateFromWSRPName((String)newWindowState));
        }
        if ((navigationalContext = updateResponse.getNavigationalContext()) != null) {
            List publicParams;
            String navigationalState = navigationalContext.getOpaqueValue();
            if (navigationalState != null) {
                result.setNavigationalState((StateString)new OpaqueStateString(navigationalState));
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)(publicParams = navigationalContext.getPublicValues()))) {
                Map publicNS = WSRPUtils.createPublicNSFrom((List)publicParams);
                result.setPublicNavigationalStateUpdates(publicNS);
            }
        }
        if (ParameterValidation.existsAndIsNotEmpty((Collection)(events = updateResponse.getEvents()))) {
            for (Event event : events) {
                Serializable payloadAsSerializable = null;
                boolean failedPayload = false;
                try {
                    payloadAsSerializable = PayloadUtils.getPayloadAsSerializable((Event)event);
                }
                catch (Exception e) {
                    failedPayload = true;
                    log.info("Couldn't handle payload for event " + event.getName() + ". Will ignore it.", (Throwable)e);
                }
                if (failedPayload) continue;
                result.queueEvent(new UpdateNavigationalStateResponse.Event(event.getName(), payloadAsSerializable));
            }
        }
        PortletContext portletContext = updateResponse.getPortletContext();
        SessionHandler sessionHandler = this.consumer.getSessionHandler();
        if (portletContext != null) {
            PortletContext originalContext = requestPrecursor.getPortletContext();
            InstanceContext context = invocation.getInstanceContext();
            String handle = portletContext.getPortletHandle();
            if (!originalContext.getPortletHandle().equals(handle)) {
                if (debug) {
                    log.debug("Portlet '" + requestPrecursor.getPortletHandle() + "' was implicitely cloned. New handle is '" + handle + "'");
                }
                StateEvent event = new StateEvent(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext), StateEvent.Type.PORTLET_CLONED_EVENT);
                context.onStateEvent(event);
            } else {
                byte[] newState;
                byte[] originalState = originalContext.getPortletState();
                if (!Arrays.equals(originalState, newState = portletContext.getPortletState())) {
                    StateEvent event = new StateEvent(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext), StateEvent.Type.PORTLET_MODIFIED_EVENT);
                    context.onStateEvent(event);
                }
            }
            sessionHandler.updateSessionInfoFor(originalContext.getPortletHandle(), handle, (PortletInvocation)invocation);
        } else {
            portletContext = requestPrecursor.getPortletContext();
        }
        sessionHandler.updateSessionIfNeeded(updateResponse.getSessionContext(), (PortletInvocation)invocation, portletContext.getPortletHandle());
        return result;
    }
}

