/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.api.session.SessionEventBroadcaster;
import org.gatein.wsrp.api.session.SessionEventListener;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.session.InMemorySessionRegistry;
import org.gatein.wsrp.consumer.handlers.session.SessionRegistry;
import org.gatein.wsrp.consumer.migration.InMemoryMigrationService;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.registry.ConsumerCache;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumerRegistry
implements ConsumerRegistrySPI {
    private FederatingPortletInvoker federatingPortletInvoker;
    private SessionEventBroadcaster sessionEventBroadcaster = SessionEventBroadcaster.NO_OP_BROADCASTER;
    private MigrationService migrationService = new InMemoryMigrationService();
    private SessionRegistry sessionRegistry = new InMemorySessionRegistry();
    private static final String CONSUMER_WITH_ID = "Consumer with id '";
    private static final String RELEASE_SESSIONS_LISTENER = "release_sessions_listener_";
    private static final Logger log = LoggerFactory.getLogger(AbstractConsumerRegistry.class);
    protected ConsumerCache consumers = new InMemoryConsumerCache();

    public synchronized void setConsumerCache(ConsumerCache consumers) {
        if (consumers == null) {
            consumers = new InMemoryConsumerCache();
        }
        this.consumers = consumers;
    }

    @Override
    public synchronized void setSessionRegistry(SessionRegistry sessionRegistry) {
        if (sessionRegistry == null) {
            sessionRegistry = new InMemorySessionRegistry();
        }
        this.sessionRegistry = sessionRegistry;
    }

    @Override
    public SessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    @Override
    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    @Override
    public synchronized void setSessionEventBroadcaster(SessionEventBroadcaster sessionEventBroadcaster) {
        if (sessionEventBroadcaster == null) {
            sessionEventBroadcaster = SessionEventBroadcaster.NO_OP_BROADCASTER;
        }
        this.sessionEventBroadcaster = sessionEventBroadcaster;
    }

    @Override
    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    @Override
    public synchronized void setMigrationService(MigrationService migrationService) {
        if (migrationService == null) {
            migrationService = new InMemoryMigrationService();
        }
        this.migrationService = migrationService;
    }

    @Override
    public WSRPConsumer createConsumer(String id, Integer expirationCacheSeconds, String wsdlURL) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Creating a Consumer");
        if (this.getConsumer(id) != null) {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' already exists!");
        }
        ProducerInfo info = new ProducerInfo(this);
        info.setId(id);
        info.setExpirationCacheSeconds(expirationCacheSeconds);
        info.getEndpointConfigurationInfo().setWsdlDefinitionURL(wsdlURL);
        this.save(info, "Couldn't create Consumer '" + id + "'");
        log.debug(CONSUMER_WITH_ID + id + "' created");
        return this.createConsumerFrom(info);
    }

    @Override
    public void destroyConsumer(String id) {
        ProducerInfo info;
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Destroying a Consumer");
        WSRPConsumer consumer = this.getConsumer(id);
        if (consumer != null) {
            info = consumer.getProducerInfo();
            try {
                consumer.releaseSessions();
            }
            catch (PortletInvokerException e) {
                log.debug("releaseSessions failed when attempting to destroy Consumer with id '" + id + "'");
            }
            if (info.isRegistered()) {
                this.registerOrDeregisterConsumerWith(id, false);
            }
        } else {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' doesn't exist!");
        }
        this.deactivateConsumer(consumer);
        this.delete(info);
        this.consumers.removeConsumer(id);
        log.debug(CONSUMER_WITH_ID + id + "' destroyed");
    }

    @Override
    public void persistConsumer(WSRPConsumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        ProducerInfo info = consumer.getProducerInfo();
        this.save(info, CONSUMER_WITH_ID + info.getId() + "' couldn't be persisted!");
        this.createConsumerFrom(info);
    }

    @Override
    public synchronized void setFederatingPortletInvoker(FederatingPortletInvoker federatingPortletInvoker) {
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    @Override
    public WSRPConsumer createConsumerFrom(ProducerInfo producerInfo) {
        WSRPConsumerImpl consumer = this.createAndActivateIfNeeded(producerInfo);
        this.consumers.putConsumer(producerInfo.getId(), consumer);
        return consumer;
    }

    private WSRPConsumerImpl createAndActivateIfNeeded(ProducerInfo producerInfo) {
        WSRPConsumerImpl consumer = new WSRPConsumerImpl(producerInfo);
        if (producerInfo.isActive() && !consumer.isActive()) {
            this.activateConsumer(consumer);
        }
        return consumer;
    }

    @Override
    public void activateConsumerWith(String id) throws ConsumerException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Activating a Consumer");
        this.activateConsumer(this.getConsumer(id));
    }

    protected void activateConsumer(WSRPConsumer consumer) {
        this.startOrStopConsumer(consumer, true, false);
    }

    @Override
    public void deactivateConsumerWith(String id) throws ConsumerException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Deactivating a Consumer");
        this.deactivateConsumer(this.getConsumer(id));
    }

    protected void deactivateConsumer(WSRPConsumer consumer) {
        this.startOrStopConsumer(consumer, false, false);
    }

    @Override
    public void registerWithFederatingPortletInvoker(WSRPConsumer consumer) {
        this.startOrStopConsumer(consumer, true, true);
    }

    @Override
    public void deregisterWithFederatingPortletInvoker(WSRPConsumer consumer) {
        this.startOrStopConsumer(consumer, false, true);
    }

    @Override
    public long getPersistedLastModifiedForProducerInfoWith(String id) {
        return this.loadProducerInfo(id).getLastModified();
    }

    @Override
    public synchronized String updateProducerInfo(ProducerInfo producerInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)producerInfo, (String)"ProducerInfo");
        String oldId = this.update(producerInfo);
        if (oldId != null) {
            WSRPConsumer consumer = this.createConsumerFrom(producerInfo);
            if (this.federatingPortletInvoker.isResolved(oldId)) {
                this.federatingPortletInvoker.unregisterInvoker(oldId);
                this.federatingPortletInvoker.registerInvoker(producerInfo.getId(), (PortletInvoker)consumer);
            }
            this.consumers.removeConsumer(oldId);
            this.consumers.putConsumer(producerInfo.getId(), consumer);
        }
        this.consumers.markAsModifiedNow();
        return oldId;
    }

    @Override
    public void start() throws Exception {
        this.reloadConsumers();
    }

    @Override
    public void reloadConsumers() {
        this.consumers.initFromStorage();
    }

    @Override
    public void stop() throws Exception {
        for (WSRPConsumer consumer : this.getConsumers(false)) {
            String producerId = consumer.getProducerId();
            if (consumer.getProducerInfo().isActive() && this.federatingPortletInvoker.isResolved(producerId)) {
                this.federatingPortletInvoker.unregisterInvoker(producerId);
            }
            try {
                consumer.stop();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<WSRPConsumer> getConfiguredConsumers() {
        return this.getConsumers(true);
    }

    @Override
    public WSRPConsumer getConsumer(String id) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"consumer id", null);
        return this.consumers.getConsumer(id);
    }

    @Override
    public boolean containsConsumer(String id) {
        return this.getConsumer(id) != null;
    }

    @Override
    public Collection<String> getConfiguredConsumersIds() {
        return new AbstractCollection<String>(){
            private final List<WSRPConsumer> consumers;
            {
                this.consumers = AbstractConsumerRegistry.this.getConsumers(false);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private Iterator<WSRPConsumer> consumerIterator;
                    {
                        this.consumerIterator = consumers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.consumerIterator.hasNext();
                    }

                    @Override
                    public String next() {
                        return this.consumerIterator.next().getProducerId();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return this.consumers.size();
            }
        };
    }

    @Override
    public int getConfiguredConsumerNumber() {
        return this.getConfiguredConsumersIds().size();
    }

    @Override
    public void registerOrDeregisterConsumerWith(String id, boolean register) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Registering or deregistering a Consumer");
        WSRPConsumer consumer = this.getConsumer(id);
        if (consumer == null) {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' doesn't exist!");
        }
        try {
            if (register) {
                consumer.getProducerInfo().register();
            } else {
                consumer.getProducerInfo().deregister();
            }
        }
        catch (Exception e) {
            this.deactivateConsumer(consumer);
            Throwable cause = e.getCause();
            throw new ConsumerException("Couldn't " + (register ? "register" : "deregister") + CONSUMER_WITH_ID + id + "'", cause != null ? cause : e);
        }
    }

    private void startOrStopConsumer(WSRPConsumer consumer, boolean start, boolean registerOrDeregisterOnly) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"WSRPConsumer");
        try {
            String id = consumer.getProducerId();
            if (start) {
                if (!registerOrDeregisterOnly) {
                    consumer.activate();
                }
                if (!this.federatingPortletInvoker.isResolved(id)) {
                    this.federatingPortletInvoker.registerInvoker(id, (PortletInvoker)consumer);
                }
                this.sessionEventBroadcaster.registerListener(this.getListenerIdFrom(id), (SessionEventListener)consumer);
            } else {
                if (!registerOrDeregisterOnly) {
                    consumer.deactivate();
                }
                if (this.federatingPortletInvoker.isResolved(id)) {
                    this.federatingPortletInvoker.unregisterInvoker(id);
                }
                this.sessionEventBroadcaster.unregisterListener(this.getListenerIdFrom(id));
            }
        }
        catch (Exception e) {
            throw new ConsumerException("Couldn't " + (start ? "start" : "stop") + " Consumer service '" + consumer.getProducerId() + "'", e);
        }
        this.updateProducerInfo(consumer.getProducerInfo());
    }

    private String getListenerIdFrom(String id) {
        return RELEASE_SESSIONS_LISTENER + id;
    }

    protected List<WSRPConsumer> getConsumers(boolean startConsumers) {
        Collection<WSRPConsumer> consumerz = this.consumers.getConsumers();
        for (WSRPConsumer consumer : consumerz) {
            ProducerInfo info;
            if (!startConsumers || !(info = consumer.getProducerInfo()).isActive() || consumer.isActive()) continue;
            try {
                consumer.refresh(false);
            }
            catch (Exception e) {
                log.info("Couldn't activate consumer " + consumer.getProducerId());
                info.setActiveAndSave(false);
            }
        }
        return new ArrayList<WSRPConsumer>(consumerz);
    }

    protected abstract ProducerInfo getUpdatedProducerInfoIfModifiedSinceOrNull(String var1, long var2);

    protected abstract boolean producerInfosGotModifiedSince(long var1);

    protected class InMemoryConsumerCache
    implements ConsumerCache {
        private Map<String, WSRPConsumer> consumers = new ConcurrentHashMap<String, WSRPConsumer>(11);
        private boolean invalidated;
        private long lastModified;

        protected InMemoryConsumerCache() {
        }

        @Override
        public void initFromStorage() {
            this.clear();
            Iterator<ProducerInfo> infosFromStorage = AbstractConsumerRegistry.this.getProducerInfosFromStorage();
            while (infosFromStorage.hasNext()) {
                ProducerInfo info = infosFromStorage.next();
                this.consumers.put(info.getId(), AbstractConsumerRegistry.this.createAndActivateIfNeeded(info));
            }
            this.markAsModifiedNow();
            this.setInvalidated(false);
        }

        @Override
        public void markAsModifiedNow() {
            this.lastModified = System.currentTimeMillis();
        }

        @Override
        public Collection<WSRPConsumer> getConsumers() {
            this.refreshIfNeeded();
            return this.consumers.values();
        }

        @Override
        public WSRPConsumer getConsumer(String id) {
            ProducerInfo info;
            WSRPConsumer consumer = this.consumers.get(id);
            if ((consumer == null || this.lastModified < AbstractConsumerRegistry.this.getPersistedLastModifiedForProducerInfoWith(id)) && (info = AbstractConsumerRegistry.this.loadProducerInfo(id)) != null) {
                consumer = AbstractConsumerRegistry.this.createAndActivateIfNeeded(info);
            }
            return consumer;
        }

        @Override
        public WSRPConsumer removeConsumer(String id) {
            this.markAsModifiedNow();
            return this.consumers.remove(id);
        }

        @Override
        public void putConsumer(String id, WSRPConsumer consumer) {
            this.consumers.put(id, consumer);
            this.markAsModifiedNow();
        }

        @Override
        public void clear() {
            this.consumers.clear();
            this.invalidated = true;
            this.markAsModifiedNow();
        }

        @Override
        public boolean isInvalidated() {
            return this.invalidated;
        }

        @Override
        public void setInvalidated(boolean invalidated) {
            this.invalidated = invalidated;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        protected void refreshIfNeeded() {
            AbstractConsumerRegistry registry = AbstractConsumerRegistry.this;
            if (this.isInvalidated() || registry.producerInfosGotModifiedSince(this.lastModified)) {
                for (String id : registry.getConfiguredConsumersIds()) {
                    ProducerInfo info = registry.getUpdatedProducerInfoIfModifiedSinceOrNull(id, this.lastModified);
                    if (this.consumers.get(id) != null) continue;
                    if (info == null) {
                        info = AbstractConsumerRegistry.this.loadProducerInfo(id);
                    }
                    this.consumers.put(id, AbstractConsumerRegistry.this.createAndActivateIfNeeded(info));
                }
                this.markAsModifiedNow();
                this.setInvalidated(false);
            }
        }
    }

    protected class ProducerInfoIterator
    implements Iterator<ProducerInfo> {
        private Iterator<WSRPConsumer> consumers;

        public ProducerInfoIterator(Iterator<WSRPConsumer> consumers) {
            this.consumers = consumers;
        }

        @Override
        public boolean hasNext() {
            return this.consumers.hasNext();
        }

        @Override
        public ProducerInfo next() {
            return this.consumers.next().getProducerInfo();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported on this iterator implementation");
        }
    }
}

