/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.httpclient.Cookie;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;
import org.gatein.wsrp.handler.CookieUtil;

public class RequestHeaderClientHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final ThreadLocal<CurrentInfo> local = new ThreadLocal();
    private static final String EMPTY = "";

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        if (Boolean.TRUE.equals(soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound"))) {
            return this.handleRequest(soapMessageContext);
        }
        return this.handleResponse((MessageContext)soapMessageContext);
    }

    public boolean handleFault(SOAPMessageContext soapMessageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public boolean handleRequest(SOAPMessageContext msgContext) {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info == null) {
            return true;
        }
        ProducerSessionInformation sessionInfo = info.sessionInfo;
        if (sessionInfo == null) {
            return true;
        }
        SOAPMessage message = msgContext.getMessage();
        String cookie = RequestHeaderClientHandler.createCookie(info, sessionInfo);
        if (cookie.length() != 0) {
            MimeHeaders mimeHeaders = message.getMimeHeaders();
            mimeHeaders.setHeader("Cookie", cookie);
            HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
            httpHeaders.put("Cookie", Collections.singletonList(cookie));
            msgContext.put((Object)"javax.xml.ws.http.request.headers", httpHeaders);
        }
        return true;
    }

    public static String createCookie(ProducerSessionInformation sessionInformation) {
        CurrentInfo currentInfo = RequestHeaderClientHandler.getCurrentInfo(false);
        if (currentInfo != null) {
            return RequestHeaderClientHandler.createCookie(currentInfo, sessionInformation);
        }
        return EMPTY;
    }

    private static String createCookie(CurrentInfo info, ProducerSessionInformation sessionInfo) {
        String userCookie;
        StringBuilder cookie = new StringBuilder(128);
        if (sessionInfo.isPerGroupCookies()) {
            if (info.groupId == null) {
                throw new IllegalStateException("Was expecting a current group Id...");
            }
            String groupCookie = sessionInfo.getGroupCookieFor(info.groupId);
            if (groupCookie != null) {
                cookie.append(groupCookie);
            }
        }
        if ((userCookie = sessionInfo.getUserCookie()) != null) {
            if (cookie.length() != 0) {
                cookie.append(',');
            }
            cookie.append(userCookie);
        }
        return cookie.toString();
    }

    public boolean handleResponse(MessageContext msgContext) {
        Map httpHeaders;
        List l;
        SOAPMessageContext smc = (SOAPMessageContext)msgContext;
        SOAPMessage message = smc.getMessage();
        MimeHeaders mimeHeaders = message.getMimeHeaders();
        String[] cookieValues = mimeHeaders.getHeader("Set-Cookie");
        if (cookieValues == null && (l = (List)(httpHeaders = (Map)smc.get((Object)"javax.xml.ws.http.response.headers")).get("Set-Cookie")) != null && !l.isEmpty()) {
            cookieValues = l.toArray(new String[l.size()]);
        }
        String endpointAddress = (String)msgContext.get((Object)"javax.xml.ws.service.endpoint.address");
        if (cookieValues != null) {
            URL hostURL;
            if (endpointAddress == null) {
                throw new NullPointerException("Was expecting an endpoint address but none was provided in the MessageContext");
            }
            try {
                hostURL = new URL(endpointAddress);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(endpointAddress + " is not a valid URL for the endpoint address.");
            }
            Cookie[] cookies = CookieUtil.extractCookiesFrom(hostURL, cookieValues);
            CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(true);
            ProducerSessionInformation sessionInfo = info.sessionInfo;
            if (sessionInfo.isPerGroupCookies()) {
                if (info.groupId == null) {
                    throw new IllegalStateException("Was expecting a current group Id...");
                }
                sessionInfo.setGroupCookieFor(info.groupId, cookies);
            } else {
                sessionInfo.setUserCookie(cookies);
            }
        }
        return true;
    }

    public static void setCurrentInfo(String groupId, ProducerSessionInformation sessionInformation) {
        local.set(new CurrentInfo(groupId, sessionInformation));
    }

    public static void resetCurrentInfo() {
        local.set(null);
    }

    public static ProducerSessionInformation getCurrentProducerSessionInformation() {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info != null) {
            return info.sessionInfo;
        }
        return null;
    }

    public static String getCurrentGroupId() {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info != null) {
            return info.groupId;
        }
        return null;
    }

    public static void setCurrentGroupId(String groupId) {
        CurrentInfo currentInfo = local.get();
        if (currentInfo == null) {
            throw new IllegalStateException("Cannot set current group id when the current info hasn't been initialized.");
        }
        currentInfo.groupId = groupId;
    }

    private static CurrentInfo getCurrentInfo(boolean createIfNeeded) {
        CurrentInfo info = local.get();
        if (info == null && createIfNeeded) {
            info = new CurrentInfo(null, new ProducerSessionInformation());
            local.set(info);
        }
        return info;
    }

    static class CurrentInfo {
        String groupId;
        ProducerSessionInformation sessionInfo;

        public CurrentInfo(String groupId, ProducerSessionInformation sessionInfo) {
            this.groupId = groupId;
            this.sessionInfo = sessionInfo;
        }
    }
}

