/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.gatein.common.util.ParameterValidation;
import org.gatein.common.util.Version;
import org.gatein.wsrp.handler.RequestHeaderClientHandler;
import org.gatein.wsrp.services.ManageableServiceFactory;
import org.gatein.wsrp.services.MarkupService;
import org.gatein.wsrp.services.PortCustomizer;
import org.gatein.wsrp.services.PortCustomizerRegistry;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.services.RegistrationService;
import org.gatein.wsrp.services.ServiceDescriptionService;
import org.gatein.wsrp.services.v1.V1MarkupService;
import org.gatein.wsrp.services.v1.V1PortletManagementService;
import org.gatein.wsrp.services.v1.V1RegistrationService;
import org.gatein.wsrp.services.v1.V1ServiceDescriptionService;
import org.gatein.wsrp.services.v2.V2MarkupService;
import org.gatein.wsrp.services.v2.V2PortletManagementService;
import org.gatein.wsrp.services.v2.V2RegistrationService;
import org.gatein.wsrp.services.v2.V2ServiceDescriptionService;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.oasis.wsrp.v2.WSRPV2MarkupPortType;
import org.oasis.wsrp.v2.WSRPV2PortletManagementPortType;
import org.oasis.wsrp.v2.WSRPV2RegistrationPortType;
import org.oasis.wsrp.v2.WSRPV2ServiceDescriptionPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPServiceFactory
implements ManageableServiceFactory {
    static final String JBOSS_WS_TIMEOUT = "org.jboss.ws.timeout";
    static final String SUN_WS_TIMEOUT = "com.sun.xml.ws.request.timeout";
    static final String IBM_WS_TIMEOUT = "com.ibm.SOAP.requestTimeout";
    static final RequestHeaderClientHandler REQUEST_HEADER_CLIENT_HANDLER = new RequestHeaderClientHandler();
    static final String JBOSS_WS_STUBEXT_PROPERTY_CHUNKED_ENCODING_SIZE = "http://org.jboss.ws/http#chunksize";
    private static final Logger log = LoggerFactory.getLogger(SOAPServiceFactory.class);
    private String wsdlDefinitionURL;
    private boolean isV2 = false;
    private Service wsService;
    private static final String WSRP_V1_BINDING = "urn:oasis:names:tc:wsrp:v1:bind";
    private static final String WSRP_V2_BINDING = "urn:oasis:names:tc:wsrp:v2:bind";
    private String markupURL;
    private String serviceDescriptionURL;
    private String portletManagementURL;
    private String registrationURL;
    private boolean failed;
    private boolean available;
    private int msBeforeTimeOut = 10000;
    private boolean wssEnabled;

    private void setTimeout(Map<String, Object> requestContext) {
        int timeout = this.getWSOperationTimeOut();
        requestContext.put(JBOSS_WS_TIMEOUT, timeout);
        requestContext.put(SUN_WS_TIMEOUT, timeout);
        requestContext.put(IBM_WS_TIMEOUT, timeout);
    }

    private <T> T customizePort(Class<T> expectedServiceInterface, Object service, String portAddress) {
        PortCustomizerRegistry registry = PortCustomizerRegistry.getInstance();
        Iterable<PortCustomizer> customizers = registry.getPortCustomizers();
        for (PortCustomizer customizer : customizers) {
            if (this.wssEnabled && customizer.isWSSFocused()) {
                customizer.customizePort(service);
                continue;
            }
            customizer.customizePort(service);
        }
        BindingProvider bindingProvider = (BindingProvider)service;
        Map requestContext = bindingProvider.getRequestContext();
        this.setTimeout(requestContext);
        requestContext.put("javax.xml.ws.service.endpoint.address", portAddress);
        requestContext.put(JBOSS_WS_STUBEXT_PROPERTY_CHUNKED_ENCODING_SIZE, "0");
        Binding binding = bindingProvider.getBinding();
        ArrayList<RequestHeaderClientHandler> handlerChain = binding.getHandlerChain();
        if (handlerChain != null) {
            if (!handlerChain.contains(REQUEST_HEADER_CLIENT_HANDLER)) {
                handlerChain.add(REQUEST_HEADER_CLIENT_HANDLER);
            }
        } else {
            handlerChain = new ArrayList<RequestHeaderClientHandler>(1);
            handlerChain.add(REQUEST_HEADER_CLIENT_HANDLER);
        }
        binding.setHandlerChain(handlerChain);
        return expectedServiceInterface.cast(service);
    }

    @Override
    public <T> T getService(Class<T> clazz) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Getting service for class " + clazz);
        }
        this.refresh(false);
        Object service = null;
        try {
            service = this.wsService.getPort(clazz);
        }
        catch (Exception e) {
            log.debug("No port available for " + clazz, (Throwable)e);
        }
        String portAddress = null;
        boolean isMandatoryInterface = false;
        if (WSRPV2ServiceDescriptionPortType.class.isAssignableFrom(clazz) || WSRPV1ServiceDescriptionPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.serviceDescriptionURL;
            isMandatoryInterface = true;
        } else if (WSRPV2MarkupPortType.class.isAssignableFrom(clazz) || WSRPV1MarkupPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.markupURL;
            isMandatoryInterface = true;
        } else if (WSRPV2RegistrationPortType.class.isAssignableFrom(clazz) || WSRPV1RegistrationPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.registrationURL;
        } else if (WSRPV2PortletManagementPortType.class.isAssignableFrom(clazz) || WSRPV1PortletManagementPortType.class.isAssignableFrom(clazz)) {
            portAddress = this.portletManagementURL;
        }
        if (service != null) {
            if (portAddress != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting the end point to: " + portAddress);
                }
                T result = this.customizePort(clazz, service, portAddress);
                this.setFailed(false);
                this.setAvailable(true);
                return result;
            }
            if (isMandatoryInterface) {
                this.setFailed(true);
                throw new IllegalStateException("Mandatory interface URLs were not properly initialized: no proper service URL for " + clazz.getName());
            }
            throw new IllegalStateException("No URL was provided for optional interface " + clazz.getName());
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public void stop() {
    }

    @Override
    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public void setWSOperationTimeOut(int msBeforeTimeOut) {
        if (msBeforeTimeOut < 0) {
            msBeforeTimeOut = 10000;
        }
        this.msBeforeTimeOut = msBeforeTimeOut;
    }

    @Override
    public int getWSOperationTimeOut() {
        return this.msBeforeTimeOut;
    }

    @Override
    public String getWsdlDefinitionURL() {
        return this.wsdlDefinitionURL;
    }

    @Override
    public void setWsdlDefinitionURL(String wsdlDefinitionURL) {
        this.wsdlDefinitionURL = wsdlDefinitionURL;
        this.setAvailable(false);
        this.setFailed(false);
    }

    @Override
    public void start() throws Exception {
        block17: {
            try {
                ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)this.wsdlDefinitionURL, (String)"WSDL URL", (String)"SOAPServiceFactory");
                URL wsdlURL = new URI(this.wsdlDefinitionURL).toURL();
                WSDLInfo wsdlInfo = new WSDLInfo(this.wsdlDefinitionURL);
                QName wsrp2 = wsdlInfo.getWSRP2ServiceQName();
                QName wsrp1 = wsdlInfo.getWSRP1ServiceQName();
                if (wsrp2 != null) {
                    this.wsService = Service.create((URL)wsdlURL, (QName)wsrp2);
                    Class<WSRPV2MarkupPortType> portTypeClass = null;
                    try {
                        portTypeClass = WSRPV2MarkupPortType.class;
                        WSRPV2MarkupPortType markupPortType = (WSRPV2MarkupPortType)this.wsService.getPort(WSRPV2MarkupPortType.class);
                        this.markupURL = (String)((BindingProvider)markupPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                        portTypeClass = WSRPV2ServiceDescriptionPortType.class;
                        WSRPV2ServiceDescriptionPortType sdPort = (WSRPV2ServiceDescriptionPortType)this.wsService.getPort(WSRPV2ServiceDescriptionPortType.class);
                        this.serviceDescriptionURL = (String)((BindingProvider)sdPort).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    }
                    catch (Exception e) {
                        this.setFailed(true);
                        throw new IllegalArgumentException("Mandatory WSRP 2 port " + portTypeClass.getName() + " was not found for WSDL at " + this.wsdlDefinitionURL, e);
                    }
                    try {
                        WSRPV2PortletManagementPortType managementPortType = (WSRPV2PortletManagementPortType)this.wsService.getPort(WSRPV2PortletManagementPortType.class);
                        this.portletManagementURL = (String)((BindingProvider)managementPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    }
                    catch (Exception e) {
                        log.debug("PortletManagement port was not available for WSDL at " + this.wsdlDefinitionURL, (Throwable)e);
                        this.portletManagementURL = null;
                    }
                    try {
                        WSRPV2RegistrationPortType registrationPortType = (WSRPV2RegistrationPortType)this.wsService.getPort(WSRPV2RegistrationPortType.class);
                        this.registrationURL = (String)((BindingProvider)registrationPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    }
                    catch (Exception e) {
                        log.debug("Registration port was not available for WSDL at " + this.wsdlDefinitionURL, (Throwable)e);
                        this.registrationURL = null;
                    }
                    this.setFailed(false);
                    this.setAvailable(true);
                    this.isV2 = true;
                    break block17;
                }
                if (wsrp1 != null) {
                    this.wsService = Service.create((URL)wsdlURL, (QName)wsrp1);
                    Class<WSRPV1MarkupPortType> portTypeClass = null;
                    try {
                        portTypeClass = WSRPV1MarkupPortType.class;
                        WSRPV1MarkupPortType markupPortType = (WSRPV1MarkupPortType)this.wsService.getPort(WSRPV1MarkupPortType.class);
                        this.markupURL = (String)((BindingProvider)markupPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                        portTypeClass = WSRPV1ServiceDescriptionPortType.class;
                        WSRPV1ServiceDescriptionPortType sdPort = (WSRPV1ServiceDescriptionPortType)this.wsService.getPort(WSRPV1ServiceDescriptionPortType.class);
                        this.serviceDescriptionURL = (String)((BindingProvider)sdPort).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    }
                    catch (Exception e) {
                        this.setFailed(true);
                        throw new IllegalArgumentException("Mandatory WSRP 1 port " + portTypeClass.getName() + " was not found for WSDL at " + this.wsdlDefinitionURL, e);
                    }
                    try {
                        WSRPV1PortletManagementPortType managementPortType = (WSRPV1PortletManagementPortType)this.wsService.getPort(WSRPV1PortletManagementPortType.class);
                        this.portletManagementURL = (String)((BindingProvider)managementPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    }
                    catch (Exception e) {
                        log.debug("PortletManagement port was not available for WSDL at " + this.wsdlDefinitionURL, (Throwable)e);
                        this.portletManagementURL = null;
                    }
                    try {
                        WSRPV1RegistrationPortType registrationPortType = (WSRPV1RegistrationPortType)this.wsService.getPort(WSRPV1RegistrationPortType.class);
                        this.registrationURL = (String)((BindingProvider)registrationPortType).getRequestContext().get("javax.xml.ws.service.endpoint.address");
                    }
                    catch (Exception e) {
                        log.debug("Registration port was not available for WSDL at " + this.wsdlDefinitionURL, (Throwable)e);
                        this.registrationURL = null;
                    }
                    this.setFailed(false);
                    this.setAvailable(true);
                    this.isV2 = false;
                    break block17;
                }
                throw new IllegalArgumentException("Couldn't find any WSRP service in specified WSDL: " + this.wsdlDefinitionURL);
            }
            catch (MalformedURLException e) {
                this.setFailed(true);
                throw new IllegalArgumentException(this.wsdlDefinitionURL + " is not a well-formed URL specifying where to find the WSRP services definition.", e);
            }
            catch (Exception e) {
                log.info("Couldn't access WSDL information at " + this.wsdlDefinitionURL + ". Service won't be available", (Throwable)e);
                this.setAvailable(false);
                this.setFailed(true);
                throw e;
            }
        }
    }

    @Override
    public ServiceDescriptionService getServiceDescriptionService() throws Exception {
        if (this.isV2) {
            WSRPV2ServiceDescriptionPortType port = this.getService(WSRPV2ServiceDescriptionPortType.class);
            return new V2ServiceDescriptionService(port);
        }
        WSRPV1ServiceDescriptionPortType port = this.getService(WSRPV1ServiceDescriptionPortType.class);
        return new V1ServiceDescriptionService(port);
    }

    @Override
    public MarkupService getMarkupService() throws Exception {
        if (this.isV2) {
            WSRPV2MarkupPortType port = this.getService(WSRPV2MarkupPortType.class);
            return new V2MarkupService(port);
        }
        WSRPV1MarkupPortType port = this.getService(WSRPV1MarkupPortType.class);
        return new V1MarkupService(port);
    }

    @Override
    public PortletManagementService getPortletManagementService() throws Exception {
        if (this.isV2) {
            WSRPV2PortletManagementPortType port = this.getService(WSRPV2PortletManagementPortType.class);
            return new V2PortletManagementService(port);
        }
        WSRPV1PortletManagementPortType port = this.getService(WSRPV1PortletManagementPortType.class);
        return new V1PortletManagementService(port);
    }

    @Override
    public RegistrationService getRegistrationService() throws Exception {
        if (this.isV2) {
            WSRPV2RegistrationPortType port = this.getService(WSRPV2RegistrationPortType.class);
            return new V2RegistrationService(port);
        }
        WSRPV1RegistrationPortType port = this.getService(WSRPV1RegistrationPortType.class);
        return new V1RegistrationService(port);
    }

    @Override
    public Version getWSRPVersion() {
        if (this.isAvailable()) {
            if (this.isV2) {
                return WSRP2;
            }
            return WSRP1;
        }
        return null;
    }

    @Override
    public boolean refresh(boolean force) throws Exception {
        if (force || !this.isAvailable() && !this.isFailed()) {
            this.start();
            return true;
        }
        return false;
    }

    @Override
    public void enableWSS(boolean enable) {
        this.wssEnabled = enable;
    }

    @Override
    public boolean isWSSEnabled() {
        return this.wssEnabled;
    }

    @Override
    public boolean isWSSAvailable() {
        PortCustomizerRegistry registry = PortCustomizerRegistry.getInstance();
        return registry != null && registry.hasWSSFocusedCustomizers();
    }

    protected static class WSDLInfo {
        private final QName wsrp2ServiceQName;
        private final QName wsrp1ServiceQName;
        private static final WSDLFactory wsdlFactory;

        public WSDLInfo(String wsdlURL) throws WSDLException {
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", false);
            Definition definition = wsdlReader.readWSDL(wsdlURL);
            Map services = definition.getServices();
            int serviceNb = services.size();
            if (serviceNb > 2) {
                throw new WSDLException("OTHER_ERROR", "The specified WSDL contains more than 2 services definitions when we expected at most 2: one for WSRP 1 and one for WSRP 2.");
            }
            QName wsrp1 = null;
            QName wsrp2 = null;
            String ns = definition.getTargetNamespace();
            for (QName name : services.keySet()) {
                javax.wsdl.Service service = (javax.wsdl.Service)services.get(name);
                Map ports = service.getPorts();
                String bindingNSURI = null;
                for (Port port : ports.values()) {
                    QName bindingName = port.getBinding().getQName();
                    String newBindingNS = bindingName.getNamespaceURI();
                    if (SOAPServiceFactory.WSRP_V1_BINDING.equals(newBindingNS) || SOAPServiceFactory.WSRP_V2_BINDING.equals(newBindingNS)) {
                        if (bindingNSURI != null && !bindingNSURI.equals(newBindingNS)) {
                            throw new WSDLException("OTHER_ERROR", "Inconsistent NS in port bindings. Aborting.");
                        }
                        bindingNSURI = newBindingNS;
                        continue;
                    }
                    log.debug("Unknown binding namespace: " + newBindingNS + ". Ignoring binding: " + bindingName);
                }
                if (SOAPServiceFactory.WSRP_V1_BINDING.equals(bindingNSURI)) {
                    wsrp1 = this.checkPotentialServiceName(wsrp1, name, ns);
                    continue;
                }
                if (!SOAPServiceFactory.WSRP_V2_BINDING.equals(bindingNSURI)) continue;
                wsrp2 = this.checkPotentialServiceName(wsrp2, name, ns);
            }
            this.wsrp2ServiceQName = wsrp2;
            this.wsrp1ServiceQName = wsrp1;
            if (wsrp1 == null && wsrp2 == null) {
                throw new WSDLException("INVALID_WSDL", "Found no service definition with WSRP specification namespaces.");
            }
        }

        public QName getWSRP2ServiceQName() {
            return this.wsrp2ServiceQName;
        }

        public QName getWSRP1ServiceQName() {
            return this.wsrp1ServiceQName;
        }

        private QName checkPotentialServiceName(QName potentiallyExisting, QName candidate, String namespace) throws WSDLException {
            if (potentiallyExisting != null) {
                throw new WSDLException("OTHER_ERROR", "Found 2 different services using the " + namespace + " namespace. Cannot decide which one to use for service so aborting.");
            }
            return candidate;
        }

        static {
            try {
                wsdlFactory = WSDLFactory.newInstance();
            }
            catch (WSDLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

