/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.gatein.common.text.TextTools;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.cache.CacheScope;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.wsrp.MIMEUtils;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.gatein.wsrp.consumer.spi.WSRPConsumerSPI;
import org.oasis.wsrp.v2.CacheControl;
import org.oasis.wsrp.v2.MimeResponse;
import org.oasis.wsrp.v2.SessionContext;

public abstract class MimeResponseHandler<Invocation extends PortletInvocation, Request, Response, LocalMimeResponse extends MimeResponse>
extends InvocationHandler<Invocation, Request, Response> {
    private static final org.gatein.pc.api.cache.CacheControl DEFAULT_CACHE_CONTROL = new org.gatein.pc.api.cache.CacheControl(0, CacheScope.PRIVATE, null);

    protected MimeResponseHandler(WSRPConsumerSPI consumer) {
        super(consumer);
    }

    protected abstract SessionContext getSessionContextFrom(Response var1);

    protected abstract LocalMimeResponse getMimeResponseFrom(Response var1);

    @Override
    protected PortletInvocationResponse processResponse(Response response, Invocation invocation, InvocationHandler.RequestPrecursor<Invocation> requestPrecursor) throws PortletInvokerException {
        this.consumer.getSessionHandler().updateSessionIfNeeded(this.getSessionContextFrom(response), (PortletInvocation)invocation, requestPrecursor.getPortletHandle());
        LocalMimeResponse mimeResponse = this.getMimeResponseFrom(response);
        this.processExtensions(response);
        return this.rewriteResponseIfNeeded(mimeResponse, invocation);
    }

    PortletInvocationResponse rewriteResponseIfNeeded(LocalMimeResponse mimeResponse, Invocation invocation) throws PortletInvokerException {
        String mimeType;
        String markup = mimeResponse.getItemString();
        byte[] binary = mimeResponse.getItemBinary();
        if (markup != null && binary != null) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Markup response cannot contain both string and binary markup. Per Section 6.1.10 of the WSRP 1.0 specification, this is a Producer error."));
        }
        if (markup == null && binary == null) {
            if (mimeResponse.isUseCachedItem() != null && mimeResponse.isUseCachedItem().booleanValue()) {
                log.debug("Consumer " + this.consumer.getProducerId() + " requested cached data. Not implemented yet!");
            } else {
                return new ErrorResponse((Throwable)new IllegalArgumentException("Markup response must contain at least string or binary markup. Per Section 6.1.10 of the WSRP 1.0 specification, this is a Producer error."));
            }
        }
        if (ParameterValidation.isNullOrEmpty((String)(mimeType = mimeResponse.getMimeType()))) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("No MIME type was provided for portlet content."));
        }
        if (Boolean.TRUE.equals(mimeResponse.isRequiresRewriting())) {
            if (!ParameterValidation.isNullOrEmpty((String)markup)) {
                markup = this.processMarkup(markup, invocation);
            }
            if (binary != null && binary.length > 0 && MIMEUtils.isInterpretableAsText((String)mimeType)) {
                try {
                    String charset = MIMEUtils.getCharsetFrom((String)mimeType);
                    String binaryAsString = new String(binary, charset);
                    binaryAsString = this.processMarkup(binaryAsString, invocation);
                    binary = binaryAsString.getBytes(charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PortletInvokerException("Couldn't convert binary as String.", (Throwable)e);
                }
            }
        }
        return this.createContentResponse(mimeResponse, invocation, mimeType, binary, markup, this.createCacheControl(mimeResponse));
    }

    private String processMarkup(String markup, Invocation invocation) {
        SecurityContext securityContext = invocation.getSecurityContext();
        markup = MimeResponseHandler.processMarkup(markup, WSRPTypeFactory.getNamespaceFrom((WindowContext)invocation.getWindowContext()), invocation.getContext(), invocation.getTarget(), new URLFormat(Boolean.valueOf(securityContext.isSecure()), Boolean.valueOf(securityContext.isAuthenticated()), Boolean.valueOf(true), Boolean.valueOf(true)), this.consumer);
        return markup;
    }

    protected PortletInvocationResponse createContentResponse(LocalMimeResponse mimeResponse, Invocation invocation, String mimeType, byte[] bytes, String markup, org.gatein.pc.api.cache.CacheControl cacheControl) {
        if (markup != null) {
            return new ContentResponse(null, null, mimeType, null, markup, cacheControl);
        }
        return new ContentResponse(null, null, mimeType, "UTF-8", bytes, cacheControl);
    }

    static String processMarkup(String markup, String namespace, PortletInvocationContext context, PortletContext target, URLFormat format, WSRPConsumer consumer) {
        markup = TextTools.replaceBoundedString((String)markup, (String)"wsrp_rewrite?", (String)"/wsrp_rewrite", (TextTools.StringReplacementGenerator)new MarkupProcessor(namespace, context, target, format, consumer.getProducerInfo()), (boolean)true, (boolean)false);
        markup = markup.replaceAll("wsrp_rewrite_", namespace);
        return markup;
    }

    protected org.gatein.pc.api.cache.CacheControl createCacheControl(LocalMimeResponse mimeResponse) {
        CacheControl cacheControl = mimeResponse.getCacheControl();
        org.gatein.pc.api.cache.CacheControl result = DEFAULT_CACHE_CONTROL;
        if (cacheControl != null) {
            int expires = cacheControl.getExpires();
            String userScope = cacheControl.getUserScope();
            if (this.consumer.supportsUserScope(userScope)) {
                CacheScope scope;
                if (debug) {
                    log.debug("Trying to cache markup " + userScope + " for " + expires + " seconds.");
                }
                if ("wsrp:forAll".equals(userScope)) {
                    scope = CacheScope.PUBLIC;
                } else if ("wsrp:perUser".equals(userScope)) {
                    scope = CacheScope.PRIVATE;
                } else {
                    throw new IllegalArgumentException("Unknown CacheControl user scope: " + userScope);
                }
                result = new org.gatein.pc.api.cache.CacheControl(expires, scope, cacheControl.getValidateTag());
            }
        }
        return result;
    }

    private static class MarkupProcessor
    implements TextTools.StringReplacementGenerator {
        private final PortletInvocationContext context;
        private final URLFormat format;
        private final Set<String> supportedCustomModes;
        private final Set<String> supportedCustomWindowStates;
        private final String namespace;

        protected MarkupProcessor(String namespace, PortletInvocationContext context, PortletContext target, URLFormat format, ProducerInfo info) {
            this.namespace = namespace;
            this.context = context;
            this.format = format;
            this.supportedCustomModes = info.getSupportedCustomModes();
            this.supportedCustomWindowStates = info.getSupportedCustomWindowStates();
        }

        public String getReplacementFor(String match, String prefix, String suffix, boolean matchedPrefixOnly) {
            if (match.endsWith("\\")) {
                match = match.substring(0, match.length() - 1);
            }
            boolean useJavaScriptEscaping = false;
            boolean useISO_8859_1Encoding = false;
            if (match.contains("\\x2D") || match.contains("\\x26")) {
                useJavaScriptEscaping = true;
                match = match.replaceAll("\\\\x2D", "-").replaceAll("\\\\x26", "&amp;");
            } else if (match.contains("\\u002D") || match.contains("\\u0026")) {
                useISO_8859_1Encoding = true;
                match = match.replaceAll("\\\\u002D", "-").replaceAll("\\\\u0026", "&amp;");
            }
            WSRPPortletURL portletURL = WSRPPortletURL.create((String)match, this.supportedCustomModes, this.supportedCustomWindowStates, (boolean)true);
            URLFormat urlFormat = match.contains("&amp;") ? new URLFormat(this.format.getWantSecure(), this.format.getWantAuthenticated(), this.format.getWantRelative(), Boolean.valueOf(true)) : new URLFormat(this.format.getWantSecure(), this.format.getWantAuthenticated(), this.format.getWantRelative(), Boolean.valueOf(false));
            String value = this.context.renderURL((ContainerURL)portletURL, urlFormat);
            if (useJavaScriptEscaping) {
                value = value.replaceAll("-", "\\\\x2D").replaceAll("&amp;", "\\\\x26");
            } else if (useISO_8859_1Encoding) {
                value = value.replaceAll("-", "\\\\u002D").replaceAll("&amp;", "\\\\u0026");
            }
            return value;
        }
    }
}

