/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.util.Streams;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.handlers.ActionHandler;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.UploadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartUtil {
    protected static Logger log = LoggerFactory.getLogger(MultiPartUtil.class);

    protected static MultiPartResult createMultiPartResult() {
        MultiPartUtil multiPartUtil = new MultiPartUtil();
        return multiPartUtil.new MultiPartResult();
    }

    public static MultiPartResult getMultiPartContent(org.gatein.pc.api.spi.RequestContext requestContext) {
        ActionHandler.RequestContextWrapper requestContextWrapper = new ActionHandler.RequestContextWrapper(requestContext);
        MultiPartResult result = null;
        try {
            if (FileUpload.isMultipartContent((RequestContext)requestContextWrapper)) {
                result = MultiPartUtil.createMultiPartResult();
                FileUpload upload = new FileUpload();
                FileItemIterator iter = upload.getItemIterator((RequestContext)requestContextWrapper);
                ArrayList<UploadContext> uploadContexts = new ArrayList<UploadContext>(7);
                ArrayList<NamedString> formParameters = new ArrayList<NamedString>(7);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    InputStream stream = item.openStream();
                    if (!item.isFormField()) {
                        String contentType = item.getContentType();
                        if (log.isDebugEnabled()) {
                            log.debug("File field " + item.getFieldName() + " with file name " + item.getName() + " and content type " + contentType + " detected.");
                        }
                        BufferedInputStream bufIn = new BufferedInputStream(stream);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        BufferedOutputStream bos = new BufferedOutputStream(baos);
                        int c = bufIn.read();
                        while (c != -1) {
                            bos.write(c);
                            c = bufIn.read();
                        }
                        bos.flush();
                        baos.flush();
                        bufIn.close();
                        bos.close();
                        UploadContext uploadContext = WSRPTypeFactory.createUploadContext((String)contentType, (byte[])baos.toByteArray());
                        ArrayList<NamedString> mimeAttributes = new ArrayList<NamedString>(2);
                        String value = "form-data; name=\"" + item.getFieldName() + "\";" + " filename=\"" + item.getName() + "\"";
                        NamedString mimeAttribute = WSRPTypeFactory.createNamedString((String)"Content-disposition", (String)value);
                        mimeAttributes.add(mimeAttribute);
                        mimeAttribute = WSRPTypeFactory.createNamedString((String)"Content-type", (String)item.getContentType());
                        mimeAttributes.add(mimeAttribute);
                        uploadContext.getMimeAttributes().addAll(mimeAttributes);
                        uploadContexts.add(uploadContext);
                        continue;
                    }
                    NamedString formParameter = WSRPTypeFactory.createNamedString((String)item.getFieldName(), (String)Streams.asString((InputStream)stream));
                    formParameters.add(formParameter);
                }
                result.getUploadContexts().addAll(uploadContexts);
                result.getFormParameters().addAll(formParameters);
            }
        }
        catch (Exception e) {
            log.debug("Couldn't create UploadContext", (Throwable)e);
        }
        return result;
    }

    public class MultiPartResult {
        protected List<NamedString> formParameters;
        protected List<UploadContext> uploadContexts;

        public List<NamedString> getFormParameters() {
            if (this.formParameters != null) {
                this.formParameters = new ArrayList<NamedString>();
            }
            return this.formParameters;
        }

        public List<UploadContext> getUploadContexts() {
            if (this.uploadContexts != null) {
                this.uploadContexts = new ArrayList<UploadContext>();
            }
            return this.uploadContexts;
        }
    }
}

