/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import com.google.common.base.Function;
import java.net.HttpCookie;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final Logger log = LoggerFactory.getLogger(CookieUtil.class);
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE = "Cookie";
    private static final String EMPTY = "";
    public static final Function<HttpCookie, String> COOKIE_STRING_FUNCTION = new Function<HttpCookie, String>(){

        public String apply(@Nullable HttpCookie input) {
            return input != null ? input.toString() : CookieUtil.EMPTY;
        }
    };

    public static List<HttpCookie> extractCookiesFrom(URL remoteAddress, List<String> cookieValues) {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>(cookieValues.size());
        for (String cookieValue : cookieValues) {
            cookies.addAll(CookieUtil.extractCookies(remoteAddress, cookieValue));
        }
        return cookies;
    }

    public static String coalesceAndExternalizeCookies(List<HttpCookie> cookies) {
        if (ParameterValidation.existsAndIsNotEmpty(cookies)) {
            return CookieUtil.coalesceCookies(CookieUtil.asExternalFormList(cookies));
        }
        return EMPTY;
    }

    public static List<String> asExternalFormList(List<HttpCookie> cookies) {
        if (ParameterValidation.existsAndIsNotEmpty(cookies)) {
            return WSRPUtils.transform(cookies, COOKIE_STRING_FUNCTION);
        }
        return Collections.emptyList();
    }

    public static String coalesceCookies(List<String> cookies) {
        if (ParameterValidation.existsAndIsNotEmpty(cookies)) {
            int cookieNumber = cookies.size();
            int i = 0;
            StringBuffer logBuffer = null;
            if (log.isDebugEnabled()) {
                logBuffer = new StringBuffer(128);
                logBuffer.append("Cookie headers:\n");
            }
            StringBuffer cookieBuffer = new StringBuffer(128 * cookieNumber);
            for (String cookie : cookies) {
                cookieBuffer.append(cookie);
                if (i++ != cookieNumber - 1) {
                    cookieBuffer.append(",");
                }
                if (!log.isDebugEnabled()) continue;
                logBuffer.append("\t").append(i).append(":\t").append(cookie).append("\n");
            }
            if (log.isDebugEnabled()) {
                log.debug(logBuffer.toString());
            }
            return cookieBuffer.toString();
        }
        return EMPTY;
    }

    private static List<HttpCookie> extractCookies(URL hostURL, String cookieValue) {
        String host = hostURL.getHost();
        List<HttpCookie> cookies = HttpCookie.parse(cookieValue);
        for (HttpCookie cookie : cookies) {
            String domain = cookie.getDomain();
            if (domain == null || HttpCookie.domainMatches(domain, host)) continue;
            throw new IllegalArgumentException("Cookie '" + cookie + "' doesn't match host '" + host + "'");
        }
        return cookies;
    }

    public static Cookie convertFrom(HttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        Cookie result = new Cookie(cookie.getName(), cookie.getValue());
        result.setComment(cookie.getComment());
        result.setDomain(cookie.getDomain());
        long maxAgeLong = cookie.getMaxAge();
        int maxAge = maxAgeLong >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxAgeLong;
        result.setMaxAge(maxAge);
        result.setPath(cookie.getPath());
        result.setSecure(cookie.getSecure());
        result.setVersion(cookie.getVersion());
        return result;
    }

    public static List<HttpCookie> purgeExpiredCookies(List<HttpCookie> cookies) {
        if (!ParameterValidation.existsAndIsNotEmpty(cookies)) {
            return Collections.emptyList();
        }
        ArrayList<HttpCookie> cleanCookies = new ArrayList<HttpCookie>(cookies);
        for (HttpCookie cookie : cookies) {
            if (!cookie.hasExpired()) continue;
            cleanCookies.remove(cookie);
        }
        return cleanCookies;
    }
}

