/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;
import org.gatein.wsrp.handler.CookieUtil;

public class RequestHeaderClientHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final ThreadLocal<CurrentInfo> local = new ThreadLocal();
    private static final String EMPTY = "";

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        if (Boolean.TRUE.equals(soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound"))) {
            return this.handleRequest(soapMessageContext);
        }
        return this.handleResponse((MessageContext)soapMessageContext);
    }

    public boolean handleFault(SOAPMessageContext soapMessageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public boolean handleRequest(SOAPMessageContext msgContext) {
        List<String> cookies = CookieUtil.asExternalFormList(RequestHeaderClientHandler.getCookiesFromCurrentInfo());
        if (cookies.isEmpty()) {
            return true;
        }
        SOAPMessage message = msgContext.getMessage();
        MimeHeaders mimeHeaders = message.getMimeHeaders();
        List<String> cookieHeaders = this.getCookieHeaders(msgContext);
        for (String cookie : cookies) {
            mimeHeaders.addHeader("Cookie", cookie);
            cookieHeaders.add(cookie);
        }
        return true;
    }

    private List<String> getCookieHeaders(SOAPMessageContext msgContext) {
        LinkedList cookieHeaders;
        HashMap httpHeaders = (HashMap)msgContext.get((Object)"javax.xml.ws.http.request.headers");
        if (httpHeaders == null) {
            httpHeaders = new HashMap();
            msgContext.put((Object)"javax.xml.ws.http.request.headers", httpHeaders);
        }
        if ((cookieHeaders = (LinkedList)httpHeaders.get("Cookie")) == null) {
            cookieHeaders = new LinkedList();
            httpHeaders.put("Cookie", cookieHeaders);
        }
        return cookieHeaders;
    }

    public static String createCoalescedCookieFromCurrentInfo() {
        return CookieUtil.coalesceAndExternalizeCookies(RequestHeaderClientHandler.getCookiesFromCurrentInfo());
    }

    private static List<HttpCookie> getCookiesFromCurrentInfo() {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info != null) {
            ProducerSessionInformation sessionInfo = info.sessionInfo;
            if (sessionInfo == null) {
                return Collections.emptyList();
            }
            ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>(7);
            if (sessionInfo.isPerGroupCookies()) {
                if (info.groupId == null) {
                    throw new IllegalStateException("Was expecting a current group Id...");
                }
                cookies.addAll(sessionInfo.getGroupCookiesFor(info.groupId));
            }
            cookies.addAll(sessionInfo.getUserCookies());
            return cookies;
        }
        return Collections.emptyList();
    }

    public boolean handleResponse(MessageContext msgContext) {
        MimeHeaders mimeHeaders;
        String[] cookieHeaders;
        SOAPMessageContext smc = (SOAPMessageContext)msgContext;
        SOAPMessage message = smc.getMessage();
        Map httpHeaders = (Map)smc.get((Object)"javax.xml.ws.http.response.headers");
        List<String> cookieValues = (List<String>)httpHeaders.get("Set-Cookie");
        if (cookieValues == null && (cookieHeaders = (mimeHeaders = message.getMimeHeaders()).getHeader("Set-Cookie")) != null) {
            cookieValues = Arrays.asList(cookieHeaders);
        }
        if (cookieValues != null) {
            URL hostURL;
            String endpointAddress = (String)msgContext.get((Object)"javax.xml.ws.service.endpoint.address");
            if (endpointAddress == null) {
                throw new NullPointerException("Was expecting an endpoint address but none was provided in the MessageContext");
            }
            try {
                hostURL = new URL(endpointAddress);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("'" + endpointAddress + "' is not a valid URL for the endpoint address.");
            }
            List<HttpCookie> cookies = CookieUtil.extractCookiesFrom(hostURL, cookieValues);
            CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(true);
            ProducerSessionInformation sessionInfo = info.sessionInfo;
            if (sessionInfo.isPerGroupCookies()) {
                if (info.groupId == null) {
                    throw new IllegalStateException("Was expecting a current group Id...");
                }
                sessionInfo.setGroupCookiesFor(info.groupId, cookies);
            } else {
                sessionInfo.setUserCookies(cookies);
            }
        }
        return true;
    }

    public static void setCurrentInfo(String groupId, ProducerSessionInformation sessionInformation) {
        local.set(new CurrentInfo(groupId, sessionInformation));
    }

    public static void resetCurrentInfo() {
        local.set(null);
    }

    public static ProducerSessionInformation getCurrentProducerSessionInformation() {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info != null) {
            return info.sessionInfo;
        }
        return null;
    }

    public static String getCurrentGroupId() {
        CurrentInfo info = RequestHeaderClientHandler.getCurrentInfo(false);
        if (info != null) {
            return info.groupId;
        }
        return null;
    }

    public static void setCurrentGroupId(String groupId) {
        CurrentInfo currentInfo = local.get();
        if (currentInfo == null) {
            throw new IllegalStateException("Cannot set current group id when the current info hasn't been initialized.");
        }
        currentInfo.groupId = groupId;
    }

    private static CurrentInfo getCurrentInfo(boolean createIfNeeded) {
        CurrentInfo info = local.get();
        if (info == null && createIfNeeded) {
            info = new CurrentInfo(null, new ProducerSessionInformation());
            local.set(info);
        }
        return info;
    }

    static class CurrentInfo {
        String groupId;
        ProducerSessionInformation sessionInfo;

        public CurrentInfo(String groupId, ProducerSessionInformation sessionInfo) {
            this.groupId = groupId;
            this.sessionInfo = sessionInfo;
        }
    }
}

