/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.gatein.common.io.IOTools;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.wsrp.MIMEUtils;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.handlers.ResourceHandler;
import org.gatein.wsrp.consumer.spi.WSRPConsumerSPI;
import org.gatein.wsrp.handler.CookieUtil;
import org.gatein.wsrp.handler.RequestHeaderClientHandler;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.ResourceContext;
import org.oasis.wsrp.v2.ResourceResponse;

public class DirectResourceServingHandler
extends ResourceHandler {
    protected DirectResourceServingHandler(WSRPConsumerSPI consumer) {
        super(consumer);
    }

    @Override
    protected ResourceResponse performRequest(GetResource getResource) throws Exception {
        ResourceContext resourceContext;
        String resourceURL = getResource.getResourceParams().getResourceID();
        URL url = new URL(resourceURL);
        URLConnection urlConnection = url.openConnection();
        String cookieValue = RequestHeaderClientHandler.createCoalescedCookieFromCurrentInfo();
        if (cookieValue.length() != 0) {
            urlConnection.addRequestProperty("Cookie", cookieValue);
        }
        String contentType = urlConnection.getContentType();
        Map<String, List<String>> headers = urlConnection.getHeaderFields();
        ResponseProperties props = new ResponseProperties();
        MultiValuedPropertyMap transportHeaders = props.getTransportHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            List<String> values;
            String key = entry.getKey();
            if (key == null || (values = entry.getValue()) == null) continue;
            if ("Set-Cookie".equals(key)) {
                List<CookieUtil.Cookie> cookies = CookieUtil.extractCookiesFrom(url, values);
                List propCookies = props.getCookies();
                for (CookieUtil.Cookie cookie : cookies) {
                    propCookies.add(CookieUtil.convertFrom(cookie));
                }
                continue;
            }
            for (String value : values) {
                transportHeaders.addValue(key, (Object)value);
            }
        }
        int length = urlConnection.getContentLength();
        length = length > 0 ? length : 4096;
        byte[] bytes = IOTools.getBytes((InputStream)urlConnection.getInputStream(), (int)length);
        if (MIMEUtils.isInterpretableAsText((String)contentType)) {
            String charset = MIMEUtils.getCharsetFrom((String)contentType);
            String markup = new String(bytes, charset);
            resourceContext = WSRPTypeFactory.createResourceContext((String)contentType, (String)markup, null);
            if (MIMEUtils.needsRewriting((String)contentType)) {
                resourceContext.setRequiresRewriting(Boolean.valueOf(true));
            }
        } else {
            resourceContext = WSRPTypeFactory.createResourceContext((String)contentType, null, (byte[])bytes);
            resourceContext.setRequiresRewriting(Boolean.valueOf(false));
        }
        return WSRPTypeFactory.createResourceResponse((ResourceContext)resourceContext);
    }
}

