/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.consumer.handlers.SessionHandler;
import org.gatein.wsrp.handler.CookieUtil;
import org.oasis.wsrp.v2.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerSessionInformation
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(ProducerSessionInformation.class);
    private boolean initCookieDone = false;
    private boolean perGroupCookies = false;
    private Map<String, List<CookieUtil.Cookie>> groupCookies;
    private Map<String, SessionInfo> portletSessions;
    private Map<String, String> sessionId2PortletHandle;
    private List<CookieUtil.Cookie> userCookie;
    private transient SessionHandler parent;
    private String parentSessionId;

    String getParentSessionId() {
        return this.parentSessionId;
    }

    void setParentSessionId(String parentSessionId) {
        boolean error = false;
        if (parentSessionId != null) {
            parentSessionId = SessionHandler.getRealId(parentSessionId);
            if (this.parentSessionId != null && !parentSessionId.equals(this.parentSessionId)) {
                error = true;
            }
        } else if (this.parentSessionId != null) {
            error = true;
        }
        if (error) {
            throw new IllegalStateException("Cannot modify Parent Session id once it has been set!");
        }
        this.parentSessionId = parentSessionId;
    }

    public List<String> getUserCookies() {
        this.userCookie = CookieUtil.purgeExpiredCookies(this.userCookie);
        if (this.userCookie.isEmpty()) {
            this.setInitCookieDone(false);
        }
        return CookieUtil.asExternalFormList(this.userCookie);
    }

    public void setUserCookies(List<CookieUtil.Cookie> userCookie) {
        if (!ParameterValidation.existsAndIsNotEmpty(userCookie)) {
            throw new IllegalArgumentException("Must provide a non-null, non-empty cookie list.");
        }
        this.userCookie = userCookie;
    }

    public boolean isInitCookieDone() {
        return this.initCookieDone;
    }

    public void setInitCookieDone(boolean initCookieDone) {
        this.initCookieDone = initCookieDone;
    }

    public boolean isPerGroupCookies() {
        return this.perGroupCookies;
    }

    public void setPerGroupCookies(boolean perGroupCookies) {
        this.perGroupCookies = perGroupCookies;
    }

    public void setGroupCookiesFor(String groupId, List<CookieUtil.Cookie> cookies) {
        if (!this.isPerGroupCookies()) {
            throw new IllegalStateException("Cannot add group cookie when cookie protocol is perUser.");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Cannot set cookie for a null portlet group id!");
        }
        if (!ParameterValidation.existsAndIsNotEmpty(cookies)) {
            throw new IllegalArgumentException("Must provide a non-null, non-empty group cookie list.");
        }
        if (this.groupCookies == null) {
            this.groupCookies = new HashMap<String, List<CookieUtil.Cookie>>();
        }
        if (this.groupCookies.containsKey(groupId)) {
            log.debug("Trying to set a cookie for an existing group: " + groupId);
        }
        this.groupCookies.put(groupId, cookies);
    }

    public List<String> getGroupCookiesFor(String groupId) {
        if (this.groupCookies == null) {
            return Collections.emptyList();
        }
        List<CookieUtil.Cookie> cookies = this.groupCookies.get(groupId);
        if (cookies != null) {
            if ((cookies = CookieUtil.purgeExpiredCookies(cookies)).isEmpty()) {
                this.setInitCookieDone(false);
            }
            this.groupCookies.put(groupId, cookies);
            return CookieUtil.asExternalFormList(cookies);
        }
        return Collections.emptyList();
    }

    public void clearGroupCookies() {
        this.groupCookies = null;
    }

    public void addSessionForPortlet(String portletHandle, SessionContext sessionContext) {
        SessionInfo info = new SessionInfo(sessionContext, portletHandle);
        if (this.portletSessions == null) {
            this.portletSessions = new HashMap<String, SessionInfo>();
            this.sessionId2PortletHandle = new HashMap<String, String>();
        }
        this.portletSessions.put(portletHandle, info);
        this.sessionId2PortletHandle.put(sessionContext.getSessionID(), portletHandle);
        if (this.parent != null) {
            this.parent.addSessionMapping(sessionContext.getSessionID(), this);
        }
    }

    public String getSessionIdForPortlet(String portletHandle) {
        SessionIdResult idResult = this.internalGetSessionIdForPortlet(portletHandle);
        if (idResult.expired) {
            return null;
        }
        return idResult.id;
    }

    public int getNumberOfSessions() {
        if (this.portletSessions != null) {
            return this.portletSessions.size();
        }
        return 0;
    }

    public String removeSession(String sessionId) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)sessionId, (String)"session id");
        String portletHandle = this.sessionId2PortletHandle.get(sessionId);
        if (portletHandle == null) {
            throw new IllegalArgumentException("No such session id: '" + sessionId + "'");
        }
        return this.removeSessionForPortlet(portletHandle);
    }

    public List<String> removeSessions() {
        ArrayList<String> idsToRelease = new ArrayList<String>(this.getNumberOfSessions());
        ArrayList<String> handlesCopy = new ArrayList<String>(this.portletSessions.keySet());
        for (String handle : handlesCopy) {
            SessionIdResult result = this.removeSessionIdForPortlet(handle);
            if (result.expired) continue;
            idsToRelease.add(result.id);
        }
        return idsToRelease;
    }

    public String removeSessionForPortlet(String portletHandle) {
        SessionIdResult result = this.removeSessionIdForPortlet(portletHandle);
        return result.expired ? null : result.id;
    }

    private SessionIdResult removeSessionIdForPortlet(String portletHandle) {
        SessionIdResult result = this.internalGetSessionIdForPortlet(portletHandle);
        String id = result.id;
        if (id == null) {
            throw new IllegalArgumentException("There is no Session associated with portlet '" + portletHandle + "'");
        }
        if (!result.expired) {
            this.portletSessions.remove(portletHandle);
            this.sessionId2PortletHandle.remove(id);
            if (this.parent != null) {
                this.parent.removeSessionId(id);
            }
        }
        return result;
    }

    public void replaceUserCookiesWith(ProducerSessionInformation currentSessionInfo) {
        if (currentSessionInfo != null && currentSessionInfo.userCookie != null && !currentSessionInfo.userCookie.isEmpty()) {
            this.userCookie = currentSessionInfo.userCookie;
        }
    }

    private SessionIdResult internalGetSessionIdForPortlet(String portletHandle) {
        SessionInfo session = this.getSessionInfoFor(portletHandle);
        if (session != null) {
            String id = session.getSessionId();
            if (!session.isStillValid()) {
                this.portletSessions.remove(session.getPortletHandle());
                this.sessionId2PortletHandle.remove(session.getSessionId());
                if (this.parent != null) {
                    this.parent.removeSessionId(session.getSessionId());
                }
                return new SessionIdResult(id, true);
            }
            return new SessionIdResult(id, false);
        }
        return new SessionIdResult(null, false);
    }

    private SessionInfo getSessionInfoFor(String portletHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", null);
        if (this.portletSessions == null) {
            return null;
        }
        return this.portletSessions.get(portletHandle);
    }

    Collection<String> getSessionIds() {
        return this.sessionId2PortletHandle.keySet();
    }

    void setParent(SessionHandler sessionHandler) {
        this.parent = sessionHandler;
    }

    public void updateHandleAssociatedInfo(String originalHandle, String newHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)originalHandle, (String)"original handle", (String)"Updating information associated with a portlet handle");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)newHandle, (String)"new handle", (String)"Updating information associated with a portlet handle");
        String sessionId = this.getSessionIdForPortlet(originalHandle);
        SessionInfo info = this.getSessionInfoFor(originalHandle);
        if (sessionId != null && info != null) {
            this.portletSessions.put(newHandle, info);
            this.portletSessions.remove(originalHandle);
            this.sessionId2PortletHandle.put(sessionId, newHandle);
            log.debug("Updated mapping information for '" + originalHandle + "' to reference '" + newHandle + "' instead.");
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private class SessionIdResult {
        private String id;
        private boolean expired;

        public SessionIdResult(String id, boolean expired) {
            this.id = id;
            this.expired = expired;
        }
    }

    private class SessionInfo
    implements Serializable {
        private long lastInvocationTime;
        private final String portletHandle;
        private final String sessionID;
        private final int expires;

        public SessionInfo(SessionContext sessionContext, String portletHandle) {
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)sessionContext, (String)"SessionContext");
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)sessionContext.getSessionID(), (String)"session id", (String)"SessionContext");
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", (String)"SessionInfo");
            this.sessionID = sessionContext.getSessionID();
            this.expires = sessionContext.getExpires();
            this.portletHandle = portletHandle;
            this.lastInvocationTime = ProducerSessionInformation.now();
        }

        private boolean isStillValid() {
            if (this.expires == -1) {
                return true;
            }
            long now = ProducerSessionInformation.now();
            long secondsSinceLastInvocation = (now - this.lastInvocationTime) / 1000L;
            this.lastInvocationTime = now;
            long diff = (long)this.expires - secondsSinceLastInvocation;
            log.debug("Session ID '" + this.sessionID + "' is " + (diff > 0L ? "" : "not") + " valid (time since last invocation: " + diff + ")");
            return diff > 0L;
        }

        private String getSessionId() {
            return this.sessionID;
        }

        private String getPortletHandle() {
            return this.portletHandle;
        }
    }
}

