/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import com.google.common.base.Function;
import java.io.Serializable;
import java.net.HttpCookie;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final Logger log = LoggerFactory.getLogger(CookieUtil.class);
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE = "Cookie";
    private static final String EMPTY = "";
    private static final Function<Cookie, String> COOKIE_STRING_FUNCTION = new Function<Cookie, String>(){

        public String apply(@Nullable Cookie input) {
            return input != null ? input.toString() : CookieUtil.EMPTY;
        }
    };

    public static List<Cookie> extractCookiesFrom(URL remoteAddress, List<String> cookieValues) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieValues.size());
        for (String cookieValue : cookieValues) {
            cookies.addAll(CookieUtil.extractCookies(remoteAddress, cookieValue));
        }
        return cookies;
    }

    public static String coalesceAndExternalizeCookies(List<Cookie> cookies) {
        if (ParameterValidation.existsAndIsNotEmpty(cookies)) {
            return CookieUtil.coalesceCookies(CookieUtil.asExternalFormList(cookies));
        }
        return EMPTY;
    }

    public static List<String> asExternalFormList(List<Cookie> cookies) {
        if (ParameterValidation.existsAndIsNotEmpty(cookies)) {
            return WSRPUtils.transform(cookies, COOKIE_STRING_FUNCTION);
        }
        return Collections.emptyList();
    }

    public static String coalesceCookies(List<String> cookies) {
        if (ParameterValidation.existsAndIsNotEmpty(cookies)) {
            int cookieNumber = cookies.size();
            int i = 0;
            StringBuffer logBuffer = null;
            if (log.isDebugEnabled()) {
                logBuffer = new StringBuffer(128);
                logBuffer.append("Cookie headers:\n");
            }
            StringBuffer cookieBuffer = new StringBuffer(128 * cookieNumber);
            for (String cookie : cookies) {
                cookieBuffer.append(cookie);
                if (i++ != cookieNumber - 1) {
                    cookieBuffer.append(",");
                }
                if (!log.isDebugEnabled()) continue;
                logBuffer.append("\t").append(i).append(":\t").append(cookie).append("\n");
            }
            if (log.isDebugEnabled()) {
                log.debug(logBuffer.toString());
            }
            return cookieBuffer.toString();
        }
        return EMPTY;
    }

    private static List<Cookie> extractCookies(URL hostURL, String cookieValue) {
        String host = hostURL.getHost();
        long creationTime = System.currentTimeMillis();
        List<HttpCookie> cookies = HttpCookie.parse(cookieValue);
        ArrayList<Cookie> result = new ArrayList<Cookie>(cookies.size());
        for (HttpCookie cookie : cookies) {
            String domain = cookie.getDomain();
            if (domain != null && !HttpCookie.domainMatches(domain, host)) {
                throw new IllegalArgumentException("Cookie '" + cookie + "' doesn't match host '" + host + "'");
            }
            result.add(new Cookie(cookie, creationTime));
        }
        return result;
    }

    public static javax.servlet.http.Cookie convertFrom(Cookie cookie) {
        if (cookie == null) {
            return null;
        }
        javax.servlet.http.Cookie result = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
        result.setComment(cookie.getComment());
        result.setDomain(cookie.getDomain());
        long maxAgeLong = cookie.getMaxAge();
        int maxAge = maxAgeLong >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxAgeLong;
        result.setMaxAge(maxAge);
        result.setPath(cookie.getPath());
        result.setSecure(cookie.getSecure());
        result.setVersion(cookie.getVersion());
        return result;
    }

    public static List<Cookie> purgeExpiredCookies(List<Cookie> cookies) {
        if (!ParameterValidation.existsAndIsNotEmpty(cookies)) {
            return Collections.emptyList();
        }
        ArrayList<Cookie> cleanCookies = new ArrayList<Cookie>(cookies);
        for (Cookie cookie : cookies) {
            if (!cookie.hasExpired()) continue;
            cleanCookies.remove(cookie);
        }
        return cleanCookies;
    }

    public static class Cookie
    implements Serializable {
        private final String externalForm;
        private final long maxAge;
        private final long creationTime;
        private final String name;
        private final String value;
        private final String comment;
        private final String domain;
        private final String path;
        private final boolean secure;
        private final int version;

        public Cookie(HttpCookie cookie, long creationTime) {
            this(cookie, cookie.getMaxAge(), creationTime);
        }

        public Cookie(String name, String value, int secondsBeforeExpiration) {
            this(new HttpCookie(name, value), secondsBeforeExpiration, System.currentTimeMillis());
        }

        private Cookie(HttpCookie cookie, long secondsBeforeExpiration, long creationTime) {
            this.externalForm = cookie.toString();
            this.maxAge = secondsBeforeExpiration;
            this.creationTime = creationTime;
            this.name = cookie.getName();
            this.value = cookie.getValue();
            this.comment = cookie.getComment();
            this.domain = cookie.getDomain();
            this.path = cookie.getPath();
            this.secure = cookie.getSecure();
            this.version = cookie.getVersion();
        }

        public boolean hasExpired() {
            if (this.maxAge == 0L) {
                return true;
            }
            if (this.maxAge < 0L) {
                return false;
            }
            long timeSinceCreated = (System.currentTimeMillis() - this.creationTime) / 1000L;
            return timeSinceCreated > this.maxAge;
        }

        public String toString() {
            return this.externalForm;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getComment() {
            return this.comment;
        }

        public String getDomain() {
            return this.domain;
        }

        public long getMaxAge() {
            return this.maxAge;
        }

        public String getPath() {
            return this.path;
        }

        public boolean getSecure() {
            return this.secure;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

