/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.util.Collection;
import java.util.List;
import javax.xml.ws.Holder;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.gatein.wsrp.consumer.handlers.MimeResponseHandler;
import org.gatein.wsrp.consumer.spi.WSRPConsumerSPI;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.UserContext;

public class RenderHandler
extends MimeResponseHandler<RenderInvocation, GetMarkup, MarkupResponse, MarkupContext> {
    public RenderHandler(WSRPConsumerSPI consumer) {
        super(consumer);
    }

    @Override
    protected SessionContext getSessionContextFrom(MarkupResponse response) {
        return response.getSessionContext();
    }

    @Override
    protected MarkupContext getMimeResponseFrom(MarkupResponse markupResponse) {
        return markupResponse.getMarkupContext();
    }

    @Override
    protected PortletInvocationResponse createContentResponse(MarkupContext markupContext, RenderInvocation invocation, ResponseProperties properties, String mimeType, byte[] bytes, String markup, CacheControl cacheControl) {
        if (markup != null) {
            return new FragmentResponse(properties, null, mimeType, null, markup, markupContext.getPreferredTitle(), cacheControl, invocation.getPortalContext().getModes());
        }
        return new FragmentResponse(properties, null, mimeType, null, bytes, markupContext.getPreferredTitle(), cacheControl, invocation.getPortalContext().getModes());
    }

    @Override
    protected GetMarkup prepareRequest(InvocationHandler.RequestPrecursor<RenderInvocation> requestPrecursor, RenderInvocation invocation) {
        PortletContext portletContext = requestPrecursor.getPortletContext();
        if (debug) {
            log.debug("Consumer about to attempt rendering portlet '" + portletContext.getPortletHandle() + "'");
        }
        return WSRPTypeFactory.createGetMarkup((RegistrationContext)requestPrecursor.getRegistrationContext(), (PortletContext)portletContext, (RuntimeContext)requestPrecursor.getRuntimeContext(), (UserContext)requestPrecursor.getUserContext(), (MarkupParams)requestPrecursor.getMarkupParams());
    }

    @Override
    protected List<Extension> getExtensionsFrom(MarkupResponse markupResponse) {
        return markupResponse.getExtensions();
    }

    @Override
    protected RuntimeContext getRuntimeContextFrom(GetMarkup request) {
        return request.getRuntimeContext();
    }

    @Override
    protected MarkupResponse performRequest(GetMarkup request) throws Exception {
        if (debug) {
            log.debug("getMarkup on '" + request.getPortletContext().getPortletHandle() + "'");
        }
        Holder sessionContextHolder = new Holder();
        Holder markupContextHolder = new Holder();
        Holder extensions = new Holder();
        this.consumer.getMarkupService().getMarkup(request.getRegistrationContext(), request.getPortletContext(), request.getRuntimeContext(), request.getUserContext(), request.getMarkupParams(), (Holder<MarkupContext>)markupContextHolder, (Holder<SessionContext>)sessionContextHolder, (Holder<List<Extension>>)extensions);
        MarkupResponse markupResponse = WSRPTypeFactory.createMarkupResponse((MarkupContext)((MarkupContext)markupContextHolder.value));
        markupResponse.setSessionContext((SessionContext)sessionContextHolder.value);
        if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)extensions.value)) && !WSRPUtils.isSingletonListWithNullOrEmptyElement((List)((List)extensions.value))) {
            markupResponse.getExtensions().addAll((Collection)extensions.value);
        }
        return markupResponse;
    }
}

