/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services.v1;

import com.google.common.base.Function;
import java.util.List;
import javax.xml.ws.Holder;
import org.gatein.common.NotYetImplemented;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.spec.v1.V1ToV2Converter;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1ResourceList;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.CopiedPortlet;
import org.oasis.wsrp.v2.ExportByValueNotSupported;
import org.oasis.wsrp.v2.ExportNoLongerValid;
import org.oasis.wsrp.v2.ExportedPortlet;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.FailedPortlets;
import org.oasis.wsrp.v2.ImportPortlet;
import org.oasis.wsrp.v2.ImportPortletsFailed;
import org.oasis.wsrp.v2.ImportedPortlet;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.PortletLifetime;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.PropertyList;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResetProperty;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.SetExportLifetime;
import org.oasis.wsrp.v2.UserContext;

public class V1PortletManagementService
extends PortletManagementService<WSRPV1PortletManagementPortType> {
    public V1PortletManagementService(WSRPV1PortletManagementPortType port) {
        super(port);
    }

    @Override
    public void getPortletDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, List<String> desiredLocales, Holder<PortletDescription> portletDescription, Holder<ResourceList> resourceList, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder v1PortletDescriptionHolder = new Holder();
            Holder v1ResourceListHolder = new Holder();
            Holder v1Extensions = new Holder();
            ((WSRPV1PortletManagementPortType)this.service).getPortletDescription(V2ToV1Converter.toV1RegistrationContext((RegistrationContext)registrationContext), V2ToV1Converter.toV1PortletContext((PortletContext)portletContext), V2ToV1Converter.toV1UserContext((UserContext)userContext), desiredLocales, v1PortletDescriptionHolder, v1ResourceListHolder, v1Extensions);
            portletDescription.value = V1ToV2Converter.toV2PortletDescription((V1PortletDescription)((V1PortletDescription)v1PortletDescriptionHolder.value));
            resourceList.value = V1ToV2Converter.toV2ResourceList((V1ResourceList)((V1ResourceList)v1ResourceListHolder.value));
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1AccessDenied v1AccessDenied) {
            throw (AccessDenied)V1ToV2Converter.toV2Exception(AccessDenied.class, (Exception)((Object)v1AccessDenied));
        }
        catch (V1InconsistentParameters v1InconsistentParameters) {
            WSRPExceptionFactory.throwWSException(InconsistentParameters.class, (String)v1InconsistentParameters.getMessage(), (Throwable)v1InconsistentParameters);
        }
        catch (V1InvalidHandle v1InvalidHandle) {
            WSRPExceptionFactory.throwWSException(InvalidHandle.class, (String)v1InvalidHandle.getMessage(), (Throwable)v1InvalidHandle);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            WSRPExceptionFactory.throwWSException(InvalidRegistration.class, (String)v1InvalidRegistration.getMessage(), (Throwable)v1InvalidRegistration);
        }
        catch (V1InvalidUserCategory v1InvalidUserCategory) {
            WSRPExceptionFactory.throwWSException(InvalidUserCategory.class, (String)v1InvalidUserCategory.getMessage(), (Throwable)v1InvalidUserCategory);
        }
        catch (V1MissingParameters v1MissingParameters) {
            WSRPExceptionFactory.throwWSException(MissingParameters.class, (String)v1MissingParameters.getMessage(), (Throwable)v1MissingParameters);
        }
        catch (V1OperationFailed v1OperationFailed) {
            WSRPExceptionFactory.throwWSException(OperationFailed.class, (String)v1OperationFailed.getMessage(), (Throwable)v1OperationFailed);
        }
    }

    @Override
    public void clonePortlet(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, Lifetime lifetime, Holder<String> portletHandle, Holder<byte[]> portletState, Holder<Lifetime> scheduledDestruction, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder v1Extensions = new Holder();
            ((WSRPV1PortletManagementPortType)this.service).clonePortlet(V2ToV1Converter.toV1RegistrationContext((RegistrationContext)registrationContext), V2ToV1Converter.toV1PortletContext((PortletContext)portletContext), V2ToV1Converter.toV1UserContext((UserContext)userContext), portletHandle, portletState, v1Extensions);
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1AccessDenied v1AccessDenied) {
            WSRPExceptionFactory.throwWSException(AccessDenied.class, (String)v1AccessDenied.getMessage(), (Throwable)v1AccessDenied);
        }
        catch (V1InconsistentParameters v1InconsistentParameters) {
            WSRPExceptionFactory.throwWSException(InconsistentParameters.class, (String)v1InconsistentParameters.getMessage(), (Throwable)v1InconsistentParameters);
        }
        catch (V1InvalidHandle v1InvalidHandle) {
            WSRPExceptionFactory.throwWSException(InvalidHandle.class, (String)v1InvalidHandle.getMessage(), (Throwable)v1InvalidHandle);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            WSRPExceptionFactory.throwWSException(InvalidRegistration.class, (String)v1InvalidRegistration.getMessage(), (Throwable)v1InvalidRegistration);
        }
        catch (V1InvalidUserCategory v1InvalidUserCategory) {
            WSRPExceptionFactory.throwWSException(InvalidUserCategory.class, (String)v1InvalidUserCategory.getMessage(), (Throwable)v1InvalidUserCategory);
        }
        catch (V1MissingParameters v1MissingParameters) {
            WSRPExceptionFactory.throwWSException(MissingParameters.class, (String)v1MissingParameters.getMessage(), (Throwable)v1MissingParameters);
        }
        catch (V1OperationFailed v1OperationFailed) {
            WSRPExceptionFactory.throwWSException(OperationFailed.class, (String)v1OperationFailed.getMessage(), (Throwable)v1OperationFailed);
        }
    }

    @Override
    public void destroyPortlets(RegistrationContext registrationContext, List<String> portletHandles, UserContext userContext, Holder<List<FailedPortlets>> failedPortlets, Holder<List<Extension>> extensions) throws InconsistentParameters, InvalidRegistration, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder destroyFailed = new Holder();
            Holder v1Extensions = new Holder();
            ((WSRPV1PortletManagementPortType)this.service).destroyPortlets(V2ToV1Converter.toV1RegistrationContext((RegistrationContext)registrationContext), portletHandles, destroyFailed, v1Extensions);
            failedPortlets.value = V1ToV2Converter.toV2FailedPortlets((List)((List)destroyFailed.value));
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1InconsistentParameters v1InconsistentParameters) {
            WSRPExceptionFactory.throwWSException(InconsistentParameters.class, (String)v1InconsistentParameters.getMessage(), (Throwable)v1InconsistentParameters);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            WSRPExceptionFactory.throwWSException(InvalidRegistration.class, (String)v1InvalidRegistration.getMessage(), (Throwable)v1InvalidRegistration);
        }
        catch (V1MissingParameters v1MissingParameters) {
            WSRPExceptionFactory.throwWSException(MissingParameters.class, (String)v1MissingParameters.getMessage(), (Throwable)v1MissingParameters);
        }
        catch (V1OperationFailed v1OperationFailed) {
            WSRPExceptionFactory.throwWSException(OperationFailed.class, (String)v1OperationFailed.getMessage(), (Throwable)v1OperationFailed);
        }
    }

    @Override
    public void getPortletsLifetime(RegistrationContext registrationContext, List<PortletContext> portletContext, UserContext userContext, Holder<List<PortletLifetime>> portletLifetime, Holder<List<FailedPortlets>> failedPortlets, Holder<ResourceList> resourceList, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRPExceptionFactory.throwWSException(OperationNotSupported.class, (String)"getPortletsLifetime not supported in WSRP 1", null);
    }

    @Override
    public void setPortletsLifetime(RegistrationContext registrationContext, List<PortletContext> portletContext, UserContext userContext, Lifetime lifetime, Holder<List<PortletLifetime>> updatedPortlet, Holder<List<FailedPortlets>> failedPortlets, Holder<ResourceList> resourceList, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRPExceptionFactory.throwWSException(OperationNotSupported.class, (String)"setPortletsLifetime not supported in WSRP 1", null);
    }

    @Override
    public void copyPortlets(RegistrationContext toRegistrationContext, UserContext toUserContext, RegistrationContext fromRegistrationContext, UserContext fromUserContext, List<PortletContext> fromPortletContexts, Lifetime lifetime, Holder<List<CopiedPortlet>> copiedPortlets, Holder<List<FailedPortlets>> failedPortlets, Holder<ResourceList> resourceList, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRPExceptionFactory.throwWSException(OperationNotSupported.class, (String)"copyPortlets not supported in WSRP 1", null);
    }

    @Override
    public void exportPortlets(RegistrationContext registrationContext, List<PortletContext> portletContext, UserContext userContext, Holder<Lifetime> lifetime, Boolean exportByValueRequired, Holder<byte[]> exportContext, Holder<List<ExportedPortlet>> exportedPortlet, Holder<List<FailedPortlets>> failedPortlets, Holder<ResourceList> resourceList, Holder<List<Extension>> extensions) throws AccessDenied, ExportByValueNotSupported, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRPExceptionFactory.throwWSException(OperationNotSupported.class, (String)"exportPortlets not supported in WSRP 1", null);
    }

    @Override
    public void importPortlets(RegistrationContext registrationContext, byte[] importContext, List<ImportPortlet> importPortlet, UserContext userContext, Lifetime lifetime, Holder<List<ImportedPortlet>> importedPortlets, Holder<List<ImportPortletsFailed>> importFailed, Holder<ResourceList> resourceList, Holder<List<Extension>> extensions) throws AccessDenied, ExportNoLongerValid, InconsistentParameters, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRPExceptionFactory.throwWSException(OperationNotSupported.class, (String)"importPortlets not supported in WSRP 1", null);
    }

    @Override
    public List<Extension> releaseExport(RegistrationContext registrationContext, byte[] exportContext, UserContext userContext) {
        throw new NotYetImplemented();
    }

    @Override
    public Lifetime setExportLifetime(SetExportLifetime setExportLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        throw (OperationNotSupported)WSRPExceptionFactory.throwWSException(OperationNotSupported.class, (String)"setExportLifetime not supported in WSRP 1", null);
    }

    @Override
    public void setPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, PropertyList propertyList, Holder<String> portletHandle, Holder<byte[]> portletState, Holder<Lifetime> scheduledDestruction, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder v1Extensions = new Holder();
            ((WSRPV1PortletManagementPortType)this.service).setPortletProperties(V2ToV1Converter.toV1RegistrationContext((RegistrationContext)registrationContext), V2ToV1Converter.toV1PortletContext((PortletContext)portletContext), V2ToV1Converter.toV1UserContext((UserContext)userContext), V2ToV1Converter.toV1PropertyList((PropertyList)propertyList), portletHandle, portletState, v1Extensions);
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1AccessDenied v1AccessDenied) {
            WSRPExceptionFactory.throwWSException(AccessDenied.class, (String)v1AccessDenied.getMessage(), (Throwable)v1AccessDenied);
        }
        catch (V1InconsistentParameters v1InconsistentParameters) {
            WSRPExceptionFactory.throwWSException(InconsistentParameters.class, (String)v1InconsistentParameters.getMessage(), (Throwable)v1InconsistentParameters);
        }
        catch (V1InvalidHandle v1InvalidHandle) {
            WSRPExceptionFactory.throwWSException(InvalidHandle.class, (String)v1InvalidHandle.getMessage(), (Throwable)v1InvalidHandle);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            WSRPExceptionFactory.throwWSException(InvalidRegistration.class, (String)v1InvalidRegistration.getMessage(), (Throwable)v1InvalidRegistration);
        }
        catch (V1InvalidUserCategory v1InvalidUserCategory) {
            WSRPExceptionFactory.throwWSException(InvalidUserCategory.class, (String)v1InvalidUserCategory.getMessage(), (Throwable)v1InvalidUserCategory);
        }
        catch (V1MissingParameters v1MissingParameters) {
            WSRPExceptionFactory.throwWSException(MissingParameters.class, (String)v1MissingParameters.getMessage(), (Throwable)v1MissingParameters);
        }
        catch (V1OperationFailed v1OperationFailed) {
            WSRPExceptionFactory.throwWSException(OperationFailed.class, (String)v1OperationFailed.getMessage(), (Throwable)v1OperationFailed);
        }
    }

    @Override
    public void getPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, List<String> names, Holder<List<Property>> properties, Holder<List<ResetProperty>> resetProperties, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder v1PropertyList = new Holder();
            Holder v1ResetPropertyList = new Holder();
            Holder v1Extensions = new Holder();
            ((WSRPV1PortletManagementPortType)this.service).getPortletProperties(V2ToV1Converter.toV1RegistrationContext((RegistrationContext)registrationContext), V2ToV1Converter.toV1PortletContext((PortletContext)portletContext), V2ToV1Converter.toV1UserContext((UserContext)userContext), names, v1PropertyList, v1ResetPropertyList, v1Extensions);
            properties.value = WSRPUtils.transform((List)((List)v1PropertyList.value), (Function)V1ToV2Converter.PROPERTY);
            resetProperties.value = WSRPUtils.transform((List)((List)v1ResetPropertyList.value), (Function)V1ToV2Converter.RESETPROPERTY);
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1AccessDenied v1AccessDenied) {
            WSRPExceptionFactory.throwWSException(AccessDenied.class, (String)v1AccessDenied.getMessage(), (Throwable)v1AccessDenied);
        }
        catch (V1InconsistentParameters v1InconsistentParameters) {
            WSRPExceptionFactory.throwWSException(InconsistentParameters.class, (String)v1InconsistentParameters.getMessage(), (Throwable)v1InconsistentParameters);
        }
        catch (V1InvalidHandle v1InvalidHandle) {
            WSRPExceptionFactory.throwWSException(InvalidHandle.class, (String)v1InvalidHandle.getMessage(), (Throwable)v1InvalidHandle);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            WSRPExceptionFactory.throwWSException(InvalidRegistration.class, (String)v1InvalidRegistration.getMessage(), (Throwable)v1InvalidRegistration);
        }
        catch (V1InvalidUserCategory v1InvalidUserCategory) {
            WSRPExceptionFactory.throwWSException(InvalidUserCategory.class, (String)v1InvalidUserCategory.getMessage(), (Throwable)v1InvalidUserCategory);
        }
        catch (V1MissingParameters v1MissingParameters) {
            WSRPExceptionFactory.throwWSException(MissingParameters.class, (String)v1MissingParameters.getMessage(), (Throwable)v1MissingParameters);
        }
        catch (V1OperationFailed v1OperationFailed) {
            WSRPExceptionFactory.throwWSException(OperationFailed.class, (String)v1OperationFailed.getMessage(), (Throwable)v1OperationFailed);
        }
    }

    @Override
    public void getPortletPropertyDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, List<String> desiredLocales, Holder<ModelDescription> modelDescription, Holder<ResourceList> resourceList, Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder v1ResourceListHolder = new Holder();
            Holder v1Extensions = new Holder();
            Holder v1ModelDescription = new Holder();
            ((WSRPV1PortletManagementPortType)this.service).getPortletPropertyDescription(V2ToV1Converter.toV1RegistrationContext((RegistrationContext)registrationContext), V2ToV1Converter.toV1PortletContext((PortletContext)portletContext), V2ToV1Converter.toV1UserContext((UserContext)userContext), desiredLocales, v1ModelDescription, v1ResourceListHolder, v1Extensions);
            modelDescription.value = V1ToV2Converter.toV2ModelDescription((V1ModelDescription)((V1ModelDescription)v1ModelDescription.value));
            resourceList.value = V1ToV2Converter.toV2ResourceList((V1ResourceList)((V1ResourceList)v1ResourceListHolder.value));
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1AccessDenied v1AccessDenied) {
            WSRPExceptionFactory.throwWSException(AccessDenied.class, (String)v1AccessDenied.getMessage(), (Throwable)v1AccessDenied);
        }
        catch (V1InconsistentParameters v1InconsistentParameters) {
            WSRPExceptionFactory.throwWSException(InconsistentParameters.class, (String)v1InconsistentParameters.getMessage(), (Throwable)v1InconsistentParameters);
        }
        catch (V1InvalidHandle v1InvalidHandle) {
            WSRPExceptionFactory.throwWSException(InvalidHandle.class, (String)v1InvalidHandle.getMessage(), (Throwable)v1InvalidHandle);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            WSRPExceptionFactory.throwWSException(InvalidRegistration.class, (String)v1InvalidRegistration.getMessage(), (Throwable)v1InvalidRegistration);
        }
        catch (V1InvalidUserCategory v1InvalidUserCategory) {
            WSRPExceptionFactory.throwWSException(InvalidUserCategory.class, (String)v1InvalidUserCategory.getMessage(), (Throwable)v1InvalidUserCategory);
        }
        catch (V1MissingParameters v1MissingParameters) {
            WSRPExceptionFactory.throwWSException(MissingParameters.class, (String)v1MissingParameters.getMessage(), (Throwable)v1MissingParameters);
        }
        catch (V1OperationFailed v1OperationFailed) {
            WSRPExceptionFactory.throwWSException(OperationFailed.class, (String)v1OperationFailed.getMessage(), (Throwable)v1OperationFailed);
        }
    }
}

