/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.util.Collection;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.federation.FederatedPortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.PortletInvokerResolver;
import org.gatein.pc.federation.impl.FederatedPortletInvokerService;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;

public class RegisteringPortletInvokerResolver
implements PortletInvokerResolver {
    private transient ConsumerRegistrySPI consumerRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederatedPortletInvoker resolvePortletInvokerFor(String invokerId, FederatingPortletInvoker callingInvoker, String compoundPortletId) throws NoSuchPortletException {
        WSRPConsumer consumer = this.consumerRegistry.getConsumer(invokerId);
        if (consumer == null) {
            if (compoundPortletId != null) {
                throw new NoSuchPortletException(compoundPortletId);
            }
            return null;
        }
        RegisteringPortletInvokerResolver registeringPortletInvokerResolver = this;
        synchronized (registeringPortletInvokerResolver) {
            try {
                this.consumerRegistry.registerWithFederatingPortletInvoker(consumer);
                return new FederatedPortletInvokerService(callingInvoker, invokerId, (PortletInvoker)consumer);
            }
            catch (ConsumerException e) {
                return null;
            }
        }
    }

    public boolean knows(String invoker) {
        return this.consumerRegistry.containsConsumer(invoker);
    }

    public Collection<String> getKnownInvokerIds() {
        return this.consumerRegistry.getConfiguredConsumersIds();
    }

    public void setConsumerRegistry(ConsumerRegistrySPI consumerRegistry) {
        this.consumerRegistry = consumerRegistry;
    }
}

