/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.api.extensions;

import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.wsrp.api.plugins.Plugins;
import org.gatein.wsrp.api.plugins.PluginsAccess;

public abstract class InvocationHandlerDelegate {
    private static InvocationHandlerDelegate consumerDelegate;
    private static InvocationHandlerDelegate producerDelegate;
    public static final String CONSUMER_DELEGATE_CLASSNAME = "org.gatein.wsrp.consumer.handlers.delegate";
    public static final String PRODUCER_DELEGATE_CLASSNAME = "org.gatein.wsrp.producer.handlers.delegate";

    private static InvocationHandlerDelegate createInstance(String propertyName, Plugins plugins) {
        String delegateClassName = System.getProperty(propertyName);
        if (delegateClassName != null && !delegateClassName.isEmpty()) {
            return plugins.createPluginInstance(delegateClassName, InvocationHandlerDelegate.class);
        }
        return null;
    }

    public static synchronized void registerConsumerDelegate(InvocationHandlerDelegate delegate) {
        consumerDelegate = delegate;
    }

    public static synchronized void registerProducerDelegate(InvocationHandlerDelegate delegate) {
        producerDelegate = delegate;
    }

    public static InvocationHandlerDelegate consumerDelegate() {
        return consumerDelegate;
    }

    public static InvocationHandlerDelegate producerDelegate() {
        return producerDelegate;
    }

    public abstract void processInvocation(PortletInvocation var1);

    public abstract void processInvocationResponse(PortletInvocationResponse var1, PortletInvocation var2);

    static {
        Plugins plugins = PluginsAccess.getPlugins();
        consumerDelegate = InvocationHandlerDelegate.createInstance(CONSUMER_DELEGATE_CLASSNAME, plugins);
        producerDelegate = InvocationHandlerDelegate.createInstance(PRODUCER_DELEGATE_CLASSNAME, plugins);
    }
}

