/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.api.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gatein.wsrp.api.plugins.Plugins;

public abstract class AbstractPlugins
implements Plugins {
    private static final List<String> KNOWN_PLUGIN_INTERFACES = new ArrayList<String>(3);

    @Override
    public List<String> getKnownPluginInterfaceNames() {
        return Collections.unmodifiableList(KNOWN_PLUGIN_INTERFACES);
    }

    @Override
    public List<String> getPluginImplementationNames(Class pluginClass, String defaultImplementationClassName) {
        try {
            List<String> implementations = this.getImplementationNamesFor(pluginClass.getCanonicalName(), defaultImplementationClassName);
            Collections.sort(implementations);
            return implementations;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract List<String> getImplementationNamesFor(String var1, String var2);

    @Override
    public <T> T createPluginInstance(String className, Class<T> pluginClass) {
        try {
            Class<T> clazz = this.getImplementationNamed(className, pluginClass);
            if (!pluginClass.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class does not implement" + pluginClass.getCanonicalName());
            }
            return pluginClass.cast(clazz.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't find class " + className, e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't instantiate class " + className, e);
        }
    }

    protected abstract <T> Class<? extends T> getImplementationNamed(String var1, Class<T> var2) throws ClassNotFoundException;

    static {
        KNOWN_PLUGIN_INTERFACES.add("org.gatein.registration.RegistrationPolicy");
        KNOWN_PLUGIN_INTERFACES.add("org.gatein.registration.policies.RegistrationPropertyValidator");
        KNOWN_PLUGIN_INTERFACES.add("org.gatein.wsrp.api.extensions.InvocationHandlerDelegate");
        KNOWN_PLUGIN_INTERFACES.add("javax.security.auth.callback.CallbackHandler");
    }
}

