/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.examples;

import java.util.List;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.wsrp.api.extensions.ConsumerExtensionAccessor;
import org.gatein.wsrp.api.extensions.ExtensionAccess;
import org.gatein.wsrp.api.extensions.InvocationHandlerDelegate;
import org.gatein.wsrp.api.extensions.UnmarshalledExtension;
import org.gatein.wsrp.examples.DOMUtils;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExampleConsumerInvocationHandlerDelegate
extends InvocationHandlerDelegate {
    private static final Logger log = LoggerFactory.getLogger(InvocationHandlerDelegate.class);

    public void processInvocation(PortletInvocation invocation) {
        if (invocation instanceof RenderInvocation) {
            String id = invocation.getDispatchedRequest().getSession().getId();
            log.info((Object)("Session id: " + id));
            String namespaceURI = "urn:gatein:wsrp:ext:examples";
            Element markupParamsExtension = DOMUtils.createElement("urn:gatein:wsrp:ext:examples", "MarkupParamsExtension");
            Node originalSessionId = DOMUtils.addChild(markupParamsExtension, "urn:gatein:wsrp:ext:examples", "OriginalSessionId");
            originalSessionId.setTextContent(id);
            ConsumerExtensionAccessor consumerExtensionAccessor = ExtensionAccess.getConsumerExtensionAccessor();
            consumerExtensionAccessor.addRequestExtension(MarkupParams.class, (Object)markupParamsExtension);
        }
    }

    public void processInvocationResponse(PortletInvocationResponse response, PortletInvocation invocation) {
        List extensions;
        UnmarshalledExtension unmarshalledExtension;
        if (response instanceof ContentResponse && (unmarshalledExtension = (UnmarshalledExtension)(extensions = ExtensionAccess.getConsumerExtensionAccessor().getResponseExtensionsFrom(MarkupResponse.class)).get(0)).isElement()) {
            Element element = (Element)unmarshalledExtension.getValue();
            String textContent = element.getTextContent();
            log.info((Object)("Got response: " + textContent));
            invocation.getDispatchedRequest().getSession().setAttribute("producerAnswered", (Object)textContent);
        }
    }
}

