/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.migration.mapping;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.common.io.IOTools;
import org.gatein.wsrp.consumer.migration.ExportInfo;
import org.gatein.wsrp.consumer.migration.mapping.ExportErrorMapping;
import org.gatein.wsrp.consumer.migration.mapping.ExportedStateMapping;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.jcr.mapping.BaseMapping;

@PrimaryType(name="wsrp:exportinfo")
public abstract class ExportInfoMapping
implements BaseMapping<ExportInfo, Object> {
    public static final String NODE_NAME = "wsrp:exportinfo";

    @Property(name="exporttime")
    public abstract long getExportTime();

    public abstract void setExportTime(long var1);

    @Property(name="expirationtime")
    public abstract long getExpirationTime();

    public abstract void setExpirationTime(long var1);

    @Property(name="exportcontext")
    public abstract InputStream getExportContext();

    public abstract void setExportContext(InputStream var1);

    @OneToMany
    public abstract List<ExportedStateMapping> getExportedStates();

    @Create
    public abstract ExportedStateMapping internalCreateExportedState(String var1);

    public ExportedStateMapping createExportedState(String portletHandle) {
        return this.internalCreateExportedState(ChromatticPersister.PortletNameFormatter.encode(portletHandle));
    }

    @OneToMany
    protected abstract List<ExportErrorMapping> getErrors();

    @Create
    public abstract ExportErrorMapping internalCreateError(String var1);

    public ExportErrorMapping createError(String errorCode) {
        return this.internalCreateError(ChromatticPersister.QNameFormatter.encode(errorCode));
    }

    @Override
    public void initFrom(ExportInfo exportInfo) {
        this.setExportTime(exportInfo.getExportTime());
        this.setExpirationTime(exportInfo.getExpirationTime());
        byte[] exportContext = exportInfo.getExportContext();
        if (exportContext != null && exportContext.length > 0) {
            ByteArrayInputStream is = new ByteArrayInputStream(exportContext);
            this.setExportContext(is);
        }
        List<ExportedStateMapping> exportedStates = this.getExportedStates();
        exportedStates.clear();
        for (String handle : exportInfo.getExportedPortletHandles()) {
            ExportedStateMapping exportedState = this.createExportedState(handle);
            exportedStates.add(exportedState);
            exportedState.initFrom(handle, exportInfo.getPortletStateFor(handle));
        }
        List<ExportErrorMapping> errors = this.getErrors();
        errors.clear();
        for (Map.Entry entry : exportInfo.getErrorCodesToFailedPortletHandlesMapping().entrySet()) {
            QName errorCode = (QName)entry.getKey();
            ExportErrorMapping error = this.createError(errorCode.toString());
            errors.add(error);
            error.initFrom(errorCode, (List)entry.getValue());
        }
    }

    @Override
    public ExportInfo toModel(ExportInfo initial, Object registry) {
        List<ExportedStateMapping> exportedStates = this.getExportedStates();
        TreeMap<String, byte[]> states = new TreeMap<String, byte[]>();
        for (ExportedStateMapping exportedState : exportedStates) {
            states.put(ChromatticPersister.PortletNameFormatter.decode(exportedState.getHandle()), IOTools.safeGetBytes((InputStream)exportedState.getState()));
        }
        List<ExportErrorMapping> errors = this.getErrors();
        TreeMap<QName, List<String>> errorCodesToHandles = new TreeMap<QName, List<String>>();
        for (ExportErrorMapping error : errors) {
            errorCodesToHandles.put(error.getErrorCode(), error.getPortletHandles());
        }
        return new ExportInfo(this.getExportTime(), errorCodesToHandles, states, IOTools.safeGetBytes((InputStream)this.getExportContext()));
    }

    @Override
    public Class<ExportInfo> getModelClass() {
        return ExportInfo.class;
    }
}

