/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.mapping;

import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.registry.mapping.EndpointInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.RegistrationInfoMapping;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;
import org.gatein.wsrp.jcr.mapping.BaseMapping;
import org.gatein.wsrp.jcr.mapping.mixins.LastModifiedMixinHolder;
import org.gatein.wsrp.jcr.mapping.mixins.ModifyRegistrationRequired;

@PrimaryType(name="wsrp:producerinfo")
public abstract class ProducerInfoMapping
extends LastModifiedMixinHolder
implements BaseMapping<ProducerInfo, ConsumerRegistrySPI> {
    public static final String NODE_NAME = "wsrp:producerinfo";

    @OneToOne
    @Owner
    @MappedBy(value="endpoint")
    public abstract EndpointInfoMapping getEndpointInfo();

    @OneToOne
    @Owner
    @MappedBy(value="registration")
    public abstract RegistrationInfoMapping getRegistrationInfo();

    @Property(name="producerid")
    public abstract String getId();

    public abstract void setId(String var1);

    @Property(name="cache")
    public abstract Integer getExpirationCacheSeconds();

    public abstract void setExpirationCacheSeconds(Integer var1);

    @Property(name="active")
    @DefaultValue(value={"false"})
    public abstract boolean getActive();

    public abstract void setActive(boolean var1);

    @Id
    public abstract String getKey();

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract ModifyRegistrationRequired getModifyRegistrationRequiredMixin();

    protected abstract void setModifyRegistrationRequiredMixin(ModifyRegistrationRequired var1);

    @Create
    protected abstract ModifyRegistrationRequired createModifyRegistrationRequiredMixin();

    public void setModifyRegistrationRequired(boolean modifyRegistrationRequired) {
        this.getCreatedModifyRegistrationRequiredMixin().setModifyRegistrationRequired(modifyRegistrationRequired);
    }

    public boolean getModifyRegistrationRequired() {
        return this.getCreatedModifyRegistrationRequiredMixin().isModifyRegistrationRequired();
    }

    @Override
    public void initFrom(ProducerInfo producerInfo) {
        this.setActive(producerInfo.isActive());
        this.setExpirationCacheSeconds(producerInfo.getExpirationCacheSeconds());
        this.setId(producerInfo.getId());
        this.setLastModified(producerInfo.getLastModified());
        EndpointInfoMapping eim = this.getEndpointInfo();
        eim.initFrom(producerInfo.getEndpointConfigurationInfo());
        RegistrationInfoMapping rim = this.getRegistrationInfo();
        RegistrationInfo regInfo = producerInfo.getRegistrationInfo();
        rim.initFrom(regInfo);
    }

    @Override
    public ProducerInfo toModel(ProducerInfo initial, ConsumerRegistrySPI registry) {
        ProducerInfo info = initial;
        if (initial == null) {
            info = new ProducerInfo(registry);
        }
        info.setKey(this.getKey());
        info.setId(this.getId());
        info.setActive(this.getActive());
        info.setExpirationCacheSeconds(this.getExpirationCacheSeconds());
        info.setLastModified(this.getLastModified());
        EndpointConfigurationInfo endInfo = this.getEndpointInfo().toModel(info.getEndpointConfigurationInfo(), info);
        info.setEndpointConfigurationInfo(endInfo);
        RegistrationInfo regInfo = this.getRegistrationInfo().toModel(info.getRegistrationInfo(), info);
        info.setRegistrationInfo(regInfo);
        return info;
    }

    @Override
    public Class<ProducerInfo> getModelClass() {
        return ProducerInfo.class;
    }

    private ModifyRegistrationRequired getCreatedModifyRegistrationRequiredMixin() {
        ModifyRegistrationRequired mmr = this.getModifyRegistrationRequiredMixin();
        if (mmr == null) {
            mmr = this.createModifyRegistrationRequiredMixin();
            this.setModifyRegistrationRequiredMixin(mmr);
            mmr.initializeValue();
        }
        return mmr;
    }
}

