/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.mapping;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.common.io.IOTools;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.RegistrationProperty;
import org.gatein.wsrp.consumer.registry.mapping.RegistrationPropertyMapping;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.jcr.mapping.BaseMapping;

@PrimaryType(name="wsrp:registrationinfo")
@FormattedBy(value=ChromatticPersister.QNameFormatter.class)
public abstract class RegistrationInfoMapping
implements BaseMapping<RegistrationInfo, ProducerInfo> {
    public static final String NODE_NAME = "wsrp:registrationinfo";

    @Property(name="consumername")
    public abstract String getConsumerName();

    public abstract void setConsumerName(String var1);

    @Property(name="handle")
    public abstract String getRegistrationHandle();

    public abstract void setRegistrationHandle(String var1);

    @Property(name="state")
    public abstract InputStream getRegistrationState();

    public abstract void setRegistrationState(InputStream var1);

    @OneToMany
    public abstract List<RegistrationPropertyMapping> getRegistrationProperties();

    @Create
    public abstract RegistrationPropertyMapping createRegistrationProperty(String var1);

    @Override
    public void initFrom(RegistrationInfo regInfo) {
        this.setConsumerName(regInfo.getConsumerName());
        this.setRegistrationHandle(regInfo.getRegistrationHandle());
        byte[] bytes = regInfo.getRegistrationState();
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.setRegistrationState(is);
        }
        List<RegistrationPropertyMapping> rpms = this.getRegistrationProperties();
        rpms.clear();
        for (RegistrationProperty property : regInfo.getRegistrationProperties().values()) {
            RegistrationPropertyMapping rpm = this.createRegistrationProperty(property.getName().toString());
            rpms.add(rpm);
            rpm.initFrom(property);
        }
    }

    @Override
    public RegistrationInfo toModel(RegistrationInfo initial, ProducerInfo registry) {
        initial.setConsumerName(this.getConsumerName());
        initial.setRegistrationHandle(this.getRegistrationHandle());
        initial.setRegistrationState(IOTools.safeGetBytes((InputStream)this.getRegistrationState()));
        List<RegistrationPropertyMapping> properties = this.getRegistrationProperties();
        HashMap<QName, RegistrationProperty> propertyMap = new HashMap<QName, RegistrationProperty>(properties.size());
        for (RegistrationPropertyMapping rpm : properties) {
            RegistrationProperty property = rpm.toModel(null, initial);
            propertyMap.put(property.getName(), property);
            property.setListener((RegistrationProperty.PropertyChangeListener)initial);
        }
        initial.setRegistrationProperties(propertyMap);
        return initial;
    }

    @Override
    public Class<RegistrationInfo> getModelClass() {
        return RegistrationInfo.class;
    }
}

