/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.xml.namespace.QName;
import org.chromattic.api.ChromatticSession;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.impl.AbstractRegistrationPersistenceManager;
import org.gatein.registration.spi.ConsumerGroupSPI;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.jcr.mapping.BaseMapping;
import org.gatein.wsrp.registration.mapping.ConsumerCapabilitiesMapping;
import org.gatein.wsrp.registration.mapping.ConsumerGroupMapping;
import org.gatein.wsrp.registration.mapping.ConsumerMapping;
import org.gatein.wsrp.registration.mapping.ConsumersAndGroupsMapping;
import org.gatein.wsrp.registration.mapping.RegistrationMapping;
import org.gatein.wsrp.registration.mapping.RegistrationPropertiesMapping;

public class JCRRegistrationPersistenceManager
extends AbstractRegistrationPersistenceManager {
    private ChromatticPersister persister;
    private final String rootNodePath;
    public static final List<Class> mappingClasses = new ArrayList<Class>(6);

    public JCRRegistrationPersistenceManager(ChromatticPersister persister) throws Exception {
        this(persister, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JCRRegistrationPersistenceManager(ChromatticPersister persister, String rootNodePath) throws Exception {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)persister, (String)"ChromatticPersister");
        this.rootNodePath = rootNodePath.endsWith("/") ? rootNodePath : rootNodePath + "/";
        this.persister = persister;
        try {
            ChromatticSession session = persister.getSession();
            ConsumersAndGroupsMapping mappings = (ConsumersAndGroupsMapping)session.findByPath(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
            if (mappings == null) {
                session.insert(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
                persister.save();
            }
        }
        finally {
            persister.closeSession(false);
        }
    }

    protected ChromatticPersister getPersister() {
        return this.persister;
    }

    public void removeRegistration(String registrationId) throws RegistrationException {
        this.internalRemoveRegistration(registrationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegistrationSPI internalRemoveRegistration(String registrationId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"identifier", null);
        Registration reg = this.getRegistration(registrationId);
        if (reg != null) {
            try {
                ChromatticSession session = this.persister.getSession();
                RegistrationMapping mapping = (RegistrationMapping)session.findById(RegistrationMapping.class, registrationId);
                session.remove((Object)mapping);
                this.persister.save();
            }
            finally {
                this.persister.closeSession(false);
            }
            return (RegistrationSPI)reg;
        }
        return null;
    }

    protected RegistrationSPI internalCreateRegistration(ConsumerSPI consumer, Map<QName, Object> registrationProperties) throws RegistrationException {
        RegistrationSPI registration = super.internalCreateRegistration(consumer, registrationProperties);
        try {
            ChromatticSession session = this.persister.getSession();
            ConsumerMapping cm = (ConsumerMapping)session.findById(ConsumerMapping.class, consumer.getPersistentKey());
            RegistrationMapping rm = cm.createAndAddRegistrationMappingFrom(null);
            rm.initFrom(registration);
            registration.setPersistentKey(rm.getPersistentKey());
            this.persister.save();
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            this.persister.closeSession(false);
        }
        return registration;
    }

    protected void internalAddConsumer(ConsumerSPI consumer) throws RegistrationException {
    }

    protected ConsumerSPI internalRemoveConsumer(String consumerId) throws RegistrationException {
        return this.remove(consumerId, ConsumerMapping.class, ConsumerSPI.class);
    }

    private <T extends BaseMapping, U> U remove(String name, Class<T> mappingClass, Class<U> modelClass) {
        try {
            ChromatticSession session = this.persister.getSession();
            T toRemove = this.getMapping(session, mappingClass, name);
            if (toRemove == null) {
                U u = null;
                return u;
            }
            U result = this.getModelFrom(toRemove, mappingClass, modelClass);
            session.remove(toRemove);
            this.persister.save();
            U u = result;
            return u;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    private <T extends BaseMapping, U> U getModelFrom(T mapping, Class<T> mappingClass, Class<U> modelClass) {
        Class aClass = mapping.getModelClass();
        if (!modelClass.isAssignableFrom(aClass)) {
            throw new IllegalArgumentException("Cannot convert a " + mappingClass.getSimpleName() + " to a " + modelClass.getSimpleName());
        }
        return modelClass.cast(mapping.toModel(null, (JCRRegistrationPersistenceManager)this));
    }

    private <T extends BaseMapping> T getMapping(ChromatticSession session, Class<T> mappingClass, String name) throws RepositoryException, NoSuchFieldException, IllegalAccessException {
        String jcrType = (String)mappingClass.getField("NODE_NAME").get(null);
        Query query = session.getJCRSession().getWorkspace().getQueryManager().createQuery("select jcr:uuid from " + jcrType + " where jcr:path = '/%/" + name + "'", "sql");
        QueryResult queryResult = query.execute();
        RowIterator rows = queryResult.getRows();
        long size = rows.getSize();
        if (size == 0L) {
            return null;
        }
        if (size != 1L) {
            throw new IllegalArgumentException("There should be only one " + mappingClass.getSimpleName() + " named " + name);
        }
        String id = rows.nextRow().getValue("jcr:uuid").getString();
        return (T)((BaseMapping)session.findById(mappingClass, id));
    }

    protected ConsumerSPI internalCreateConsumer(String consumerId, String consumerName) throws RegistrationException {
        ConsumerSPI consumer = super.internalCreateConsumer(consumerId, consumerName);
        try {
            ChromatticSession session = this.persister.getSession();
            ConsumersAndGroupsMapping mappings = (ConsumersAndGroupsMapping)session.findByPath(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
            ConsumerMapping cm = mappings.createConsumer(consumerId);
            mappings.getConsumers().add(cm);
            cm.initFrom(consumer);
            consumer.setPersistentKey(cm.getPersistentKey());
            this.persister.save();
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            this.persister.closeSession(false);
        }
        return consumer;
    }

    protected ConsumerSPI internalSaveChangesTo(Consumer consumer) throws RegistrationException {
        ConsumerSPI consumerSPI = (ConsumerSPI)consumer;
        try {
            ChromatticSession session = this.persister.getSession();
            ConsumerMapping cm = (ConsumerMapping)session.findById(ConsumerMapping.class, consumer.getPersistentKey());
            cm.initFrom(consumerSPI);
            this.persister.save();
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            this.persister.closeSession(false);
        }
        return consumerSPI;
    }

    protected RegistrationSPI internalSaveChangesTo(Registration registration) throws RegistrationException {
        RegistrationSPI registrationSPI = (RegistrationSPI)registration;
        try {
            ChromatticSession session = this.persister.getSession();
            RegistrationMapping cm = (RegistrationMapping)session.findById(RegistrationMapping.class, registration.getPersistentKey());
            cm.initFrom(registrationSPI);
            this.persister.save();
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            this.persister.closeSession(false);
        }
        return registrationSPI;
    }

    protected void internalAddConsumerGroup(ConsumerGroupSPI group) throws RegistrationException {
    }

    protected ConsumerGroupSPI internalRemoveConsumerGroup(String name) throws RegistrationException {
        return this.remove(name, ConsumerGroupMapping.class, ConsumerGroupSPI.class);
    }

    protected ConsumerGroupSPI internalCreateConsumerGroup(String name) throws RegistrationException {
        ConsumerGroupSPI group = super.internalCreateConsumerGroup(name);
        try {
            ChromatticSession session = this.persister.getSession();
            ConsumersAndGroupsMapping mappings = (ConsumersAndGroupsMapping)session.findByPath(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
            ConsumerGroupMapping cgm = mappings.createConsumerGroup(name);
            mappings.getConsumerGroups().add(cgm);
            group.setPersistentKey(cgm.getPersistentKey());
            cgm.initFrom(group);
            this.persister.save();
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            this.persister.closeSession(false);
        }
        return group;
    }

    protected ConsumerSPI getConsumerSPIById(String consumerId) throws RegistrationException {
        return this.getModel(consumerId, ConsumerSPI.class, ConsumerMapping.class);
    }

    private <T, B extends BaseMapping> T getModel(String id, Class<T> modelClass, Class<B> mappingClass) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"identifier", null);
        try {
            ChromatticSession session = this.persister.getSession();
            T t = this.getModel(id, modelClass, mappingClass, session);
            return t;
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    private <T, B extends BaseMapping> T getModel(String id, Class<T> modelClass, Class<B> mappingClass, ChromatticSession session) throws RegistrationException {
        try {
            B mapping = this.getMapping(session, mappingClass, id);
            if (mapping == null) {
                return null;
            }
            return this.getModelFrom((T)mapping, mappingClass, (Class)modelClass);
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
    }

    public ConsumerGroup getConsumerGroup(String name) throws RegistrationException {
        return this.getModel(name, ConsumerGroup.class, ConsumerGroupMapping.class);
    }

    public Consumer getConsumerById(String consumerId) throws IllegalArgumentException, RegistrationException {
        return this.getConsumerSPIById(consumerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends ConsumerGroup> getConsumerGroups() throws RegistrationException {
        try {
            ChromatticSession session = this.persister.getSession();
            ConsumersAndGroupsMapping mappings = (ConsumersAndGroupsMapping)session.findByPath(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
            List<ConsumerGroupMapping> groupMappings = mappings.getConsumerGroups();
            ArrayList<ConsumerGroupSPI> groups = new ArrayList<ConsumerGroupSPI>(groupMappings.size());
            for (ConsumerGroupMapping cgm : groupMappings) {
                groups.add(cgm.toModel(this.newConsumerGroupSPI(cgm.getName()), this));
            }
            ArrayList<ConsumerGroupSPI> arrayList = groups;
            return arrayList;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    public Registration getRegistration(String registrationId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"identifier", null);
        try {
            ChromatticSession session = this.persister.getSession();
            RegistrationMapping mapping = (RegistrationMapping)session.findById(RegistrationMapping.class, registrationId);
            if (mapping == null) {
                Registration registration = null;
                return registration;
            }
            ConsumerMapping parent = mapping.getParent();
            Registration registration = parent.toModel(null, this).getRegistration(registrationId);
            return registration;
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends Consumer> getConsumers() throws RegistrationException {
        try {
            ChromatticSession session = this.persister.getSession();
            ConsumersAndGroupsMapping mappings = (ConsumersAndGroupsMapping)session.findByPath(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
            List<ConsumerMapping> consumerMappings = mappings.getConsumers();
            ArrayList<ConsumerSPI> consumers = new ArrayList<ConsumerSPI>(consumerMappings.size());
            for (ConsumerMapping consumerMapping : consumerMappings) {
                consumers.add(consumerMapping.toModel(this.newConsumerSPI(consumerMapping.getId(), consumerMapping.getName()), this));
            }
            ArrayList<ConsumerSPI> arrayList = consumers;
            return arrayList;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    public Collection<? extends Registration> getRegistrations() throws RegistrationException {
        Collection<? extends Consumer> consumers = this.getConsumers();
        ArrayList registrations = new ArrayList(consumers.size() * 2);
        for (Consumer consumer : consumers) {
            registrations.addAll(consumer.getRegistrations());
        }
        return registrations;
    }

    public boolean isConsumerExisting(String consumerId) throws RegistrationException {
        return this.exists(consumerId);
    }

    private boolean exists(String name) {
        try {
            ChromatticSession session = this.persister.getSession();
            boolean bl = session.getJCRSession().itemExists(this.rootNodePath + "wsrp:consumersandgroups" + "/" + name);
            return bl;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    public boolean isConsumerGroupExisting(String consumerGroupId) throws RegistrationException {
        return this.exists(consumerGroupId);
    }

    protected void internalAddRegistration(RegistrationSPI registration) throws RegistrationException {
    }

    static {
        Collections.addAll(mappingClasses, ConsumersAndGroupsMapping.class, ConsumerMapping.class, ConsumerGroupMapping.class, RegistrationMapping.class, ConsumerCapabilitiesMapping.class, RegistrationPropertiesMapping.class);
    }
}

