/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration.mapping;

import javax.xml.namespace.QName;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.jcr.mapping.BaseMapping;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

@PrimaryType(name="wsrp:registrationpropertydescription")
public abstract class RegistrationPropertyDescriptionMapping
implements BaseMapping<RegistrationPropertyDescription, Object> {
    public static final String NODE_NAME = "wsrp:registrationpropertydescription";

    @Id
    public abstract String getPersistentKey();

    @Property(name="name")
    public abstract String getName();

    public abstract void setName(String var1);

    @Property(name="type")
    public abstract String getType();

    public abstract void setType(String var1);

    @Property(name="description")
    public abstract String getDescription();

    public abstract void setDescription(String var1);

    @Property(name="hint")
    public abstract String getHint();

    public abstract void setHint(String var1);

    @Property(name="label")
    public abstract String getLabel();

    public abstract void setLabel(String var1);

    @Override
    public void initFrom(RegistrationPropertyDescription desc) {
        LocalizedString label;
        LocalizedString hint;
        LocalizedString description = desc.getDescription();
        if (description != null) {
            this.setDescription(description.getValue());
        }
        if ((hint = desc.getHint()) != null) {
            this.setHint(hint.getValue());
        }
        if ((label = desc.getLabel()) != null) {
            this.setLabel(label.getValue());
        }
        this.setName(desc.getName().toString());
        this.setType(desc.getType().toString());
    }

    public RegistrationPropertyDescription toRegistrationPropertyDescription() {
        return this.toModel(null, null);
    }

    @Override
    public RegistrationPropertyDescription toModel(RegistrationPropertyDescription initial, Object registry) {
        String label;
        String hint;
        RegistrationPropertyDescription desc = initial;
        if (desc == null) {
            desc = new RegistrationPropertyDescription(this.getName(), QName.valueOf(this.getType()));
        } else {
            desc.setName(QName.valueOf(this.getName()));
            desc.setType(QName.valueOf(this.getType()));
        }
        desc.setPersistentKey(this.getPersistentKey());
        String description = this.getDescription();
        if (!ParameterValidation.isNullOrEmpty((String)description)) {
            desc.setDefaultDescription(description);
        }
        if (!ParameterValidation.isNullOrEmpty((String)(hint = this.getHint()))) {
            desc.setHint(new LocalizedString(hint));
        }
        if (!ParameterValidation.isNullOrEmpty((String)(label = this.getLabel()))) {
            desc.setLabel(new LocalizedString(label));
        }
        return desc;
    }

    @Override
    public Class<RegistrationPropertyDescription> getModelClass() {
        return RegistrationPropertyDescription.class;
    }
}

