/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.endpoints.v1;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import javax.jws.HandlerChain;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.cxf.feature.Features;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.endpoints.WSRPBaseEndpoint;
import org.gatein.wsrp.spec.v1.V1ToV2Converter;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1Property;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RegistrationData;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistration;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.RegistrationState;
import org.oasis.wsrp.v2.ResourceSuspended;

@WebService(name="WSRPV1RegistrationPortType", serviceName="WSRPService", portName="WSRPRegistrationService", targetNamespace="urn:oasis:names:tc:wsrp:v1:wsdl", wsdlLocation="/WEB-INF/wsdl/wsrp_services.wsdl", endpointInterface="org.oasis.wsrp.v1.WSRPV1RegistrationPortType")
@HandlerChain(file="../producer-handler-chains.xml")
@Features(features={"org.gatein.wsrp.cxf.WSRPEndpointFeature"})
public class RegistrationEndpoint
extends WSRPBaseEndpoint
implements WSRPV1RegistrationPortType {
    public void register(@WebParam(name="consumerName", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") String consumerName, @WebParam(name="consumerAgent", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") String consumerAgent, @WebParam(name="methodGetSupported", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") boolean methodGetSupported, @WebParam(name="consumerModes", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> consumerModes, @WebParam(name="consumerWindowStates", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> consumerWindowStates, @WebParam(name="consumerUserScopes", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> consumerUserScopes, @WebParam(name="customUserProfileData", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> customUserProfileData, @WebParam(name="registrationProperties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<V1Property> registrationProperties, @WebParam(mode=WebParam.Mode.INOUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions, @WebParam(mode=WebParam.Mode.OUT, name="registrationHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> registrationHandle, @WebParam(mode=WebParam.Mode.OUT, name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> registrationState) throws V1MissingParameters, V1OperationFailed {
        try {
            RegistrationData registrationData = WSRPTypeFactory.createRegistrationData((String)consumerName, (String)consumerAgent, (boolean)methodGetSupported);
            if (ParameterValidation.existsAndIsNotEmpty(consumerModes)) {
                registrationData.getConsumerModes().addAll(consumerModes);
            }
            if (ParameterValidation.existsAndIsNotEmpty(consumerWindowStates)) {
                registrationData.getConsumerWindowStates().addAll(consumerWindowStates);
            }
            if (ParameterValidation.existsAndIsNotEmpty(consumerUserScopes)) {
                registrationData.getConsumerUserScopes().addAll(consumerUserScopes);
            }
            if (ParameterValidation.existsAndIsNotEmpty(registrationProperties)) {
                registrationData.getRegistrationProperties().addAll(WSRPUtils.transform(registrationProperties, (Function)V1ToV2Converter.PROPERTY));
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)((Collection)extensions.value))) {
                registrationData.getExtensions().addAll(WSRPUtils.transform((List)((List)extensions.value), (Function)V1ToV2Converter.EXTENSION));
            }
            RegistrationContext registrationContext = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)registrationData, null, null));
            registrationHandle.value = registrationContext.getRegistrationHandle();
            registrationState.value = registrationContext.getRegistrationState();
            extensions.value = WSRPUtils.transform((List)registrationContext.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }

    public void deregister(@WebParam(name="registrationHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") String registrationHandle, @WebParam(name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") byte[] registrationState, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types", mode=WebParam.Mode.INOUT) Holder<List<V1Extension>> extensions) throws V1InvalidRegistration, V1OperationFailed {
        try {
            RegistrationContext rc = WSRPTypeFactory.createRegistrationContext((String)registrationHandle);
            rc.setRegistrationState(registrationState);
            this.producer.deregister(WSRPTypeFactory.createDeregister((RegistrationContext)rc, null));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }

    public void modifyRegistration(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="registrationData", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationData registrationData, @WebParam(mode=WebParam.Mode.OUT, name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> registrationState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InvalidRegistration, V1OperationFailed {
        try {
            ModifyRegistration modifyRegistration = WSRPTypeFactory.createModifyRegistration((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (RegistrationData)V1ToV2Converter.toV2RegistrationData((V1RegistrationData)registrationData));
            RegistrationState result = this.producer.modifyRegistration(modifyRegistration);
            if (result != null) {
                registrationState.value = result.getRegistrationState();
                extensions.value = WSRPUtils.transform((List)result.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
            }
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }
}

