/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gatein.exports.data.ExportData;
import org.gatein.exports.data.ExportPortletData;

public class ExportContext
extends ExportData {
    protected static final String TYPE = "WSRP_EC";
    private static final double VERSION = 1.0;
    private long currentTime;
    private long terminationTime;
    private long refreshDuration;
    private final boolean exportByValue;
    private Map<String, ExportPortletData> portlets;

    public ExportContext() {
        this(true, -1L, -1L, -1L);
    }

    public ExportContext(boolean exportByValue, long currentTime, long terminationTime, long refreshDuration) {
        if (exportByValue) {
            this.currentTime = currentTime;
            this.terminationTime = terminationTime;
            this.refreshDuration = refreshDuration;
        }
        this.exportByValue = exportByValue;
    }

    public boolean isExportByValue() {
        return this.exportByValue;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public long getTermintationTime() {
        return this.terminationTime;
    }

    public void setTerminationTime(long terminationTime) {
        this.terminationTime = terminationTime;
    }

    public long getRefreshDuration() {
        return this.refreshDuration;
    }

    public void setRefreshDuration(long refreshDuration) {
        this.refreshDuration = refreshDuration;
    }

    public void addPortlet(ExportPortletData portlet) {
        if (this.portlets == null) {
            this.portlets = new HashMap<String, ExportPortletData>(7);
        }
        portlet.setExportContext(this);
        this.portlets.put(portlet.getPortletHandle(), portlet);
    }

    public ExportPortletData removePortlet(ExportPortletData portlet) {
        if (this.portlets != null) {
            ExportPortletData remove = this.portlets.remove(portlet.getId());
            portlet.setExportContext(null);
            return remove;
        }
        return null;
    }

    public Collection<ExportPortletData> getPortlets() {
        return this.portlets != null ? this.portlets.values() : Collections.emptyList();
    }

    @Override
    protected void decodeExtraData(ObjectInputStream ois) throws IOException {
    }

    @Override
    protected void encodeExtraData(ObjectOutputStream oos) throws IOException {
    }

    @Override
    protected double getVersion() {
        return 1.0;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

