/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gatein.exports.ExportPersistenceManager;
import org.gatein.exports.data.ExportContext;
import org.gatein.exports.data.ExportPortletData;

public abstract class ExportData {
    protected static final String NO_ID = "__NO_ID__";
    private String id = "__NO_ID__";

    public static <T extends ExportData> T initExportData(Class<T> expected, byte[] encodedData, ExportPersistenceManager persistenceManager) {
        if (encodedData != null && encodedData.length > 0) {
            try {
                String id;
                ExportData exportData;
                ByteArrayInputStream bais = new ByteArrayInputStream(encodedData);
                ObjectInputStream ois = new ObjectInputStream(bais);
                String type = ois.readUTF();
                if ("WSRP_EC".equals(type)) {
                    exportData = new ExportContext();
                } else if ("WSRP_EPD".equals(type)) {
                    exportData = new ExportPortletData();
                } else {
                    throw new IllegalArgumentException("Unknown ExportData type '" + type + "'");
                }
                ExportData result = (ExportData)expected.cast(exportData);
                double version = ois.readDouble();
                if (!result.supports(version)) {
                    throw new IllegalArgumentException(expected.getSimpleName() + " doesn't know how to deal with version '" + version + "'");
                }
                exportData.id = id = ois.readUTF();
                if (NO_ID.equals(id)) {
                    result.decodeExtraData(ois);
                } else {
                    if (persistenceManager == null) {
                        throw new IllegalStateException("Encoded data points to persisted state, yet no ExportPersistenceManager has been provided to load state from persistence");
                    }
                    result = persistenceManager.loadExportData(id, expected);
                }
                return (T)result;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Couldn't read from byte array", e);
            }
        }
        throw new IllegalArgumentException("Cannot create ExportData from null or empty byte array");
    }

    protected boolean supports(double version) {
        return Double.compare(this.getVersion(), version) == 0;
    }

    protected abstract void decodeExtraData(ObjectInputStream var1) throws IOException;

    protected abstract void encodeExtraData(ObjectOutputStream var1) throws IOException;

    public byte[] encodeAsBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeUTF(this.getType());
        oos.writeDouble(this.getVersion());
        oos.writeUTF(this.id);
        this.encodeExtraData(oos);
        oos.close();
        return baos.toByteArray();
    }

    protected abstract double getVersion();

    protected abstract String getType();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

