/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gatein.exports.data.ExportContext;
import org.gatein.exports.data.ExportData;

public class ExportPortletData
extends ExportData {
    protected static final String TYPE = "WSRP_EPD";
    private static final double VERSION = 1.0;
    private String portletHandle;
    private byte[] portletState;
    private ExportContext exportContext;

    public ExportPortletData(String portletHandle, byte[] portletState) {
        this.portletHandle = portletHandle;
        this.portletState = portletState;
    }

    public ExportPortletData() {
    }

    public String getPortletHandle() {
        return this.portletHandle;
    }

    public byte[] getPortletState() {
        return this.portletState;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double getVersion() {
        return 1.0;
    }

    @Override
    protected void decodeExtraData(ObjectInputStream ois) throws IOException {
        this.portletHandle = ois.readUTF();
        if (ois.available() > 0) {
            this.portletState = new byte[ois.available()];
            ois.readFully(this.portletState);
        }
    }

    @Override
    protected void encodeExtraData(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.portletHandle);
        if (this.portletState != null) {
            oos.write(this.portletState);
        }
    }

    public static ExportPortletData decodeFrom(byte[] bytes) throws IOException {
        return ExportPortletData.initExportData(ExportPortletData.class, bytes, null);
    }

    void setExportContext(ExportContext exportContext) {
        this.exportContext = exportContext;
    }

    public ExportContext getExportContext() {
        return this.exportContext;
    }
}

