/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.gatein.exports.ExportManager;
import org.gatein.exports.ExportPersistenceManager;
import org.gatein.exports.data.ExportContext;
import org.gatein.exports.data.ExportData;
import org.gatein.exports.data.ExportPortletData;

public class ExportManagerImpl
implements ExportManager {
    protected ExportPersistenceManager exportPersistenceManager;
    protected boolean preferExportByValue = true;
    protected boolean supportExportByValue = true;

    @Override
    public ExportPersistenceManager getPersistenceManager() {
        return this.exportPersistenceManager;
    }

    @Override
    public void setPersistenceManager(ExportPersistenceManager exportPersistenceManager) {
        this.exportPersistenceManager = exportPersistenceManager;
    }

    @Override
    public ExportContext createExportContext(boolean exportByValueRequired, long currentTime, long terminationTime, long refreshDuration) throws UnsupportedEncodingException {
        boolean useExportByValue = true;
        if (this.exportPersistenceManager != null && !this.preferExportByValue) {
            useExportByValue = false;
        }
        return new ExportContext(useExportByValue, currentTime, terminationTime, refreshDuration);
    }

    @Override
    public boolean supportsExportByValue() {
        return this.supportExportByValue;
    }

    public void setPreferExportByValue(boolean preferExportByValue) {
        this.preferExportByValue = preferExportByValue;
    }

    @Override
    public ExportContext createExportContext(byte[] bytes) {
        return this.createExportData(ExportContext.class, bytes);
    }

    private <T extends ExportData> T createExportData(Class<T> expected, byte[] bytes) {
        return ExportData.initExportData(expected, bytes, this.exportPersistenceManager);
    }

    @Override
    public ExportPortletData createExportPortletData(ExportContext exportContextData, String portletHandle, byte[] portletState) throws UnsupportedEncodingException {
        return new ExportPortletData(portletHandle, portletState);
    }

    @Override
    public ExportPortletData createExportPortletData(ExportContext exportContextData, long currentTime, long terminationTime, long refreshDuration, byte[] bytes) {
        return this.createExportData(ExportPortletData.class, bytes);
    }

    @Override
    public byte[] encodeExportPortletData(ExportContext exportContextData, ExportPortletData exportPortletData) throws IOException {
        if (exportContextData.isExportByValue()) {
            return exportPortletData.encodeAsBytes();
        }
        ExportPortletData portletData = this.exportPersistenceManager.storeExportPortletData(exportContextData, exportPortletData);
        return portletData.encodeAsBytes();
    }

    @Override
    public byte[] encodeExportContextData(ExportContext exportContext) throws IOException {
        if (exportContext.isExportByValue()) {
            return exportContext.encodeAsBytes();
        }
        ExportContext stored = this.exportPersistenceManager.storeExportContext(exportContext);
        return stored.encodeAsBytes();
    }

    @Override
    public ExportContext setExportLifetime(byte[] exportContextBytes, long currentTime, long terminationTime, long refreshDuration) {
        if (this.getPersistenceManager() == null) {
            throw new UnsupportedOperationException("The producer only supports export by value. Cannot call setExportLifetime on this producer");
        }
        ExportContext exportContext = this.createExportContext(exportContextBytes);
        if (exportContext.isExportByValue()) {
            throw new IllegalStateException("Cannot set the lifetime for an export that was exported by value");
        }
        exportContext.setCurrentTime(currentTime);
        exportContext.setTerminationTime(terminationTime);
        exportContext.setRefreshDuration(refreshDuration);
        ExportContext updatedExportContext = this.getPersistenceManager().updateExportContext(exportContext);
        return updatedExportContext;
    }

    @Override
    public void releaseExport(byte[] bytes) throws IOException {
        if (bytes != null && bytes.length > 0 && this.exportPersistenceManager != null) {
            ExportContext exportContext = this.createExportContext(bytes);
            this.exportPersistenceManager.removeExportContext(exportContext.getId());
        }
    }
}

