/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.DuplicateRegistrationException;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.impl.ConsumerGroupImpl;
import org.gatein.registration.impl.ConsumerImpl;
import org.gatein.registration.impl.RegistrationImpl;
import org.gatein.registration.spi.ConsumerGroupSPI;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;

public abstract class AbstractRegistrationPersistenceManager
implements RegistrationPersistenceManager {
    private long lastRegistrationId;

    @Override
    public Consumer createConsumer(String consumerId, String consumerName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        if (this.isConsumerExisting(consumerId)) {
            throw new DuplicateRegistrationException("A Consumer with identifier '" + consumerId + "' has already been registered.");
        }
        ConsumerSPI consumer = this.internalCreateConsumer(consumerId, consumerName);
        this.internalAddConsumer(consumer);
        return consumer;
    }

    @Override
    public void saveChangesTo(Consumer consumer) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        if (consumer.getPersistentKey() == null) {
            throw new IllegalArgumentException("Consumer " + consumer + " hasn't yet been persisted and thus cannot be updated.");
        }
        this.internalSaveChangesTo(consumer);
    }

    @Override
    public void saveChangesTo(Registration registration) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        if (registration.getPersistentKey() == null) {
            throw new IllegalArgumentException("Registration " + registration + " hasn't yet been persisted and thus cannot be updated");
        }
        this.internalSaveChangesTo(registration);
    }

    @Override
    public ConsumerGroup createConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"ConsumerGroup name", null);
        if (this.isConsumerGroupExisting(name)) {
            throw new DuplicateRegistrationException("A ConsumerGroup named '" + name + "' has already been registered.");
        }
        ConsumerGroupSPI group = this.internalCreateConsumerGroup(name);
        this.internalAddConsumerGroup(group);
        return group;
    }

    @Override
    public void removeConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"ConsumerGroup name", null);
        if (this.internalRemoveConsumerGroup(name) == null) {
            throw new NoSuchRegistrationException("There is no ConsumerGroup named '" + name + "'.");
        }
    }

    @Override
    public void removeConsumer(String consumerId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        if (this.internalRemoveConsumer(consumerId) == null) {
            throw new RegistrationException("There is no Consumer with identity '" + consumerId + "'.");
        }
    }

    @Override
    public void removeRegistration(String registrationId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration identity", null);
        RegistrationSPI registration = this.internalRemoveRegistration(registrationId);
        if (registration == null) {
            throw new NoSuchRegistrationException("There is no Registration with id '" + registrationId + "'");
        }
        ConsumerSPI consumer = registration.getConsumer();
        consumer.removeRegistration(registration);
    }

    @Override
    public RegistrationSPI addRegistrationFor(String consumerId, Map<QName, Object> registrationProperties) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNull(registrationProperties, (String)"Registration properties");
        ConsumerSPI consumer = this.getConsumerSPIById(consumerId);
        if (consumer == null) {
            throw new NoSuchRegistrationException("There is no Consumer with identity '" + consumerId + "' to add a Registration to...");
        }
        return this.addRegistrationFor(consumer, registrationProperties);
    }

    @Override
    public RegistrationSPI addRegistrationFor(ConsumerSPI consumer, Map<QName, Object> registrationProperties) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        ParameterValidation.throwIllegalArgExceptionIfNull(registrationProperties, (String)"Registration properties");
        RegistrationSPI registration = this.internalCreateRegistration(consumer, registrationProperties);
        consumer.addRegistration(registration);
        this.internalAddRegistration(registration);
        return registration;
    }

    @Override
    public Consumer addConsumerToGroupNamed(String consumerId, String groupName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)groupName, (String)"ConsumerGroup name", null);
        ConsumerGroup group = this.getConsumerGroup(groupName);
        if (group == null) {
            throw new NoSuchRegistrationException("There is no ConsumerGroup named '" + groupName + "' to add a Consumer to...");
        }
        ConsumerSPI consumer = this.getConsumerSPIById(consumerId);
        if (consumer == null) {
            throw new NoSuchRegistrationException("There is no Consumer with identity '" + consumerId + "' to add to ConsumerGroup named '" + groupName + "'. Did you create it?");
        }
        group.addConsumer(consumer);
        return consumer;
    }

    @Override
    public boolean isConsumerExisting(String consumerId) throws RegistrationException {
        return this.getConsumerById(consumerId) != null;
    }

    @Override
    public boolean isConsumerGroupExisting(String consumerGroupId) throws RegistrationException {
        return this.getConsumerGroup(consumerGroupId) != null;
    }

    protected abstract void internalAddRegistration(RegistrationSPI var1) throws RegistrationException;

    protected abstract RegistrationSPI internalRemoveRegistration(String var1) throws RegistrationException;

    protected RegistrationSPI internalCreateRegistration(ConsumerSPI consumer, Map<QName, Object> registrationProperties) throws RegistrationException {
        RegistrationSPI registrationSPI = this.newRegistrationSPI(consumer, registrationProperties);
        registrationSPI.setPersistentKey("" + this.lastRegistrationId++);
        return registrationSPI;
    }

    protected abstract void internalAddConsumer(ConsumerSPI var1) throws RegistrationException;

    protected abstract ConsumerSPI internalRemoveConsumer(String var1) throws RegistrationException;

    protected ConsumerSPI internalCreateConsumer(String consumerId, String consumerName) throws RegistrationException {
        ConsumerSPI consumerSPI = this.newConsumerSPI(consumerId, consumerName);
        consumerSPI.setPersistentKey(consumerId);
        return consumerSPI;
    }

    protected abstract ConsumerSPI internalSaveChangesTo(Consumer var1) throws RegistrationException;

    protected abstract RegistrationSPI internalSaveChangesTo(Registration var1) throws RegistrationException;

    protected abstract void internalAddConsumerGroup(ConsumerGroupSPI var1) throws RegistrationException;

    protected abstract ConsumerGroupSPI internalRemoveConsumerGroup(String var1) throws RegistrationException;

    protected ConsumerGroupSPI internalCreateConsumerGroup(String name) throws RegistrationException {
        ConsumerGroupSPI groupSPI = this.newConsumerGroupSPI(name);
        groupSPI.setPersistentKey(name);
        return groupSPI;
    }

    protected abstract ConsumerSPI getConsumerSPIById(String var1) throws RegistrationException;

    public RegistrationSPI newRegistrationSPI(ConsumerSPI consumer, Map<QName, Object> registrationProperties) {
        return new RegistrationImpl(consumer, RegistrationStatus.PENDING, registrationProperties, this);
    }

    public ConsumerSPI newConsumerSPI(String consumerId, String consumerName) {
        return new ConsumerImpl(consumerId, consumerName);
    }

    public ConsumerGroupSPI newConsumerGroupSPI(String name) {
        return new ConsumerGroupImpl(name);
    }
}

