/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.impl.AbstractRegistrationPersistenceManager;
import org.gatein.registration.spi.ConsumerGroupSPI;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;

public class RegistrationPersistenceManagerImpl
extends AbstractRegistrationPersistenceManager {
    private Map<String, ConsumerSPI> consumers = new HashMap<String, ConsumerSPI>();
    private Map<String, ConsumerGroupSPI> groups = new HashMap<String, ConsumerGroupSPI>();
    private Map<String, RegistrationSPI> registrations = new HashMap<String, RegistrationSPI>();

    public Collection<ConsumerSPI> getConsumers() throws RegistrationException {
        return Collections.unmodifiableCollection(this.consumers.values());
    }

    public Collection<RegistrationSPI> getRegistrations() throws RegistrationException {
        return Collections.unmodifiableCollection(this.registrations.values());
    }

    public Collection<ConsumerGroupSPI> getConsumerGroups() throws RegistrationException {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public Registration getRegistration(String registrationId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration id", null);
        return this.registrations.get(registrationId);
    }

    @Override
    public ConsumerGroup getConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"ConsumerGroup name", null);
        return this.groups.get(name);
    }

    @Override
    public Consumer getConsumerById(String consumerId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        return this.consumers.get(consumerId);
    }

    @Override
    protected void internalAddRegistration(RegistrationSPI registration) throws RegistrationException {
        this.registrations.put(registration.getPersistentKey(), registration);
    }

    @Override
    protected RegistrationSPI internalRemoveRegistration(String registrationId) throws RegistrationException {
        return this.registrations.remove(registrationId);
    }

    @Override
    protected void internalAddConsumer(ConsumerSPI consumer) throws RegistrationException {
        this.consumers.put(consumer.getId(), consumer);
    }

    @Override
    protected ConsumerSPI internalRemoveConsumer(String consumerId) throws RegistrationException {
        return this.consumers.remove(consumerId);
    }

    @Override
    protected void internalAddConsumerGroup(ConsumerGroupSPI group) throws RegistrationException {
        this.groups.put(group.getName(), group);
    }

    @Override
    protected ConsumerGroupSPI internalRemoveConsumerGroup(String name) throws RegistrationException {
        return this.groups.remove(name);
    }

    @Override
    protected ConsumerSPI getConsumerSPIById(String consumerId) throws RegistrationException {
        return (ConsumerSPI)this.getConsumerById(consumerId);
    }

    @Override
    protected ConsumerSPI internalSaveChangesTo(Consumer consumer) throws RegistrationException {
        return (ConsumerSPI)consumer;
    }

    @Override
    protected RegistrationSPI internalSaveChangesTo(Registration registration) throws RegistrationException {
        return (RegistrationSPI)registration;
    }
}

