/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.policies;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletContext;
import org.gatein.registration.InvalidConsumerDataException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.wsrp.registration.PropertyDescription;

public class RegistrationPolicyWrapper
implements RegistrationPolicy {
    private final RegistrationPolicy delegate;

    public static RegistrationPolicy wrap(RegistrationPolicy policy) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)policy, (String)"RegistrationPolicy to wrap");
        if (!policy.isWrapped()) {
            return new RegistrationPolicyWrapper(policy);
        }
        return policy;
    }

    public static RegistrationPolicy unwrap(RegistrationPolicy policy) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)policy, (String)"RegistrationPolicy to unwrap");
        if (policy.isWrapped()) {
            return ((RegistrationPolicyWrapper)policy).getDelegate();
        }
        return policy;
    }

    private RegistrationPolicyWrapper(RegistrationPolicy delegate) {
        this.delegate = delegate;
    }

    private RegistrationPolicy getDelegate() {
        return this.delegate;
    }

    @Override
    public void validateRegistrationDataFor(Map<QName, Object> registrationProperties, String consumerIdentity, Map<QName, ? extends PropertyDescription> expectations, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
        this.delegate.validateRegistrationDataFor(registrationProperties, consumerIdentity, expectations, manager);
    }

    @Override
    public String createRegistrationHandleFor(String registrationId) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration id", null);
        return this.delegate.createRegistrationHandleFor(registrationId);
    }

    @Override
    public String getAutomaticGroupNameFor(String consumerName) throws IllegalArgumentException {
        return this.delegate.getAutomaticGroupNameFor(RegistrationPolicyWrapper.sanitizeConsumerName(consumerName));
    }

    @Override
    public String getConsumerIdFrom(String consumerName, Map<QName, Object> registrationProperties) throws IllegalArgumentException, InvalidConsumerDataException {
        return this.delegate.getConsumerIdFrom(RegistrationPolicyWrapper.sanitizeConsumerName(consumerName), registrationProperties);
    }

    @Override
    public void validateConsumerName(String consumerName, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
        this.delegate.validateConsumerName(RegistrationPolicyWrapper.sanitizeConsumerName(consumerName), manager);
    }

    @Override
    public void validateConsumerGroupName(String groupName, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
        this.delegate.validateConsumerGroupName(groupName, manager);
    }

    @Override
    public boolean allowAccessTo(PortletContext portletContext, Registration registration, String operation) {
        return this.delegate.allowAccessTo(portletContext, registration, operation);
    }

    @Override
    public boolean isWrapped() {
        return true;
    }

    @Override
    public String getClassName() {
        return this.delegate.getClassName();
    }

    @Override
    public Class<? extends RegistrationPolicy> getRealClass() {
        return this.delegate.getClass();
    }

    static String sanitizeConsumerName(String consumerName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        consumerName = consumerName.trim();
        consumerName = consumerName.replaceAll(",", "_");
        consumerName = consumerName.replaceAll(" ", "_");
        consumerName = consumerName.replaceAll("/", "_");
        return consumerName;
    }
}

